/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.golem;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1427;
import net.minecraft.class_174;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2700;
import net.minecraft.class_3222;
import net.minecraft.class_4538;
import party.lemons.biomemakeover.entity.PlayerCreatable;

public final class GolemHandler {
    private static List<GolemInstance> golems = Lists.newArrayList();

    public static void addPattern(class_2700 fullPattern, class_2700 basePattern, GolemResult result) {
        golems.add(new GolemInstance(fullPattern, basePattern, result));
    }

    public static boolean canDispenseGolem(class_4538 levelReader, class_2338 blockPos) {
        for (GolemInstance golemInstance : golems) {
            if (golemInstance.basePattern.method_11708(levelReader, blockPos) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean checkAndCreateGolem(class_1937 level, class_2338 pos) {
        for (GolemInstance golem : golems) {
            class_2700.class_2702 fullMatch = golem.fullPattern.method_11708((class_4538)level, pos);
            if (fullMatch == null) continue;
            for (int x = 0; x < golem.fullPattern.method_11710(); ++x) {
                for (int y = 0; y < golem.fullPattern.method_11713(); ++y) {
                    class_2694 block = fullMatch.method_11717(x, y, 0);
                    level.method_8652(block.method_11683(), class_2246.field_10124.method_9564(), 2);
                    level.method_20290(2001, block.method_11683(), class_2248.method_9507((class_2680)block.method_11681()));
                }
            }
            class_2338 placePosition = fullMatch.method_11717(golem.fullPattern.method_11710() / 2, golem.fullPattern.method_11713() - 1, 0).method_11683();
            if (golem.result.spawnGolem(level, golem, pos, placePosition)) {
                for (int x = 0; x < golem.fullPattern.method_11710(); ++x) {
                    for (int y = 0; y < golem.fullPattern.method_11713(); ++y) {
                        class_2694 removePosition = fullMatch.method_11717(x, y, 0);
                        level.method_8408(removePosition.method_11683(), class_2246.field_10124);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private GolemHandler() {
    }

    public record GolemInstance(class_2700 fullPattern, class_2700 basePattern, GolemResult result) {
    }

    @FunctionalInterface
    public static interface GolemResult {
        public boolean spawnGolem(class_1937 var1, GolemInstance var2, class_2338 var3, class_2338 var4);
    }

    public static class SummonGolemResult<T extends class_1427>
    implements GolemResult {
        private final class_1299<T> golemType;

        public SummonGolemResult(class_1299<T> golem) {
            this.golemType = golem;
        }

        @Override
        public boolean spawnGolem(class_1937 level, GolemInstance golemInstance, class_2338 pumpkinPos, class_2338 placePosition) {
            class_1427 golem = (class_1427)this.golemType.method_5883(level);
            ((PlayerCreatable)golem).setPlayerCreated(true);
            golem.method_5808((double)placePosition.method_10263() + 0.5, (double)placePosition.method_10264() + 0.05, (double)placePosition.method_10260() + 0.5, 0.0f, 0.0f);
            level.method_8649((class_1297)golem);
            for (class_3222 serverPlayer : level.method_18467(class_3222.class, golem.method_5829().method_1014(5.0))) {
                class_174.field_1182.method_9124(serverPlayer, (class_1297)golem);
            }
            return true;
        }
    }
}

