/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature.mansion.room;

import java.util.List;
import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2960;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_6626;
import party.lemons.biomemakeover.level.feature.mansion.LayoutType;
import party.lemons.biomemakeover.level.feature.mansion.MansionFeature;
import party.lemons.biomemakeover.level.feature.mansion.MansionLayout;
import party.lemons.biomemakeover.level.feature.mansion.RoomLayout;
import party.lemons.biomemakeover.level.feature.mansion.RoomType;
import party.lemons.biomemakeover.util.BMUtil;
import party.lemons.biomemakeover.util.Grid;

public class MansionRoom {
    protected final RoomLayout layout = new RoomLayout();
    protected final class_2338 position;
    protected RoomType type;
    protected LayoutType layoutType;
    public boolean active = true;
    private int sortValue = 0;

    public MansionRoom(class_2338 position, RoomType type) {
        this.position = position;
        this.type = type;
        this.layoutType = LayoutType.NORMAL;
    }

    public RoomType getRoomType() {
        return this.type;
    }

    public void setRoomType(RoomType type) {
        this.type = type;
    }

    public void setLayout(MansionLayout layout, Random random) {
        Grid<MansionRoom> lo = layout.getLayout();
        for (int i = 0; i < 4; ++i) {
            class_2350 dir = class_2350.method_10139((int)i);
            MansionRoom neighbour = lo.get(this.getPosition().method_10093(dir));
            if (neighbour == null) continue;
            switch (this.layoutType) {
                case REQUIRED: {
                    this.layout.put(dir, true);
                    neighbour.layout.put(dir.method_10153(), true);
                }
            }
        }
    }

    public RoomLayout getLayout() {
        return this.layout;
    }

    public void setLayoutType(LayoutType layoutType) {
        this.layoutType = layoutType;
    }

    public class_2338 getPosition() {
        return this.position;
    }

    public class_2960 getTemplate(Random random) {
        if (this.type != RoomType.CORRIDOR) {
            return this.type.getRandomTemplate(this.position, random);
        }
        List<class_2960> ids = switch (this.layout.doorCount()) {
            case 1 -> MansionFeature.CORRIDOR_STRAIGHT;
            case 2 -> {
                if (((Boolean)this.layout.get(class_2350.field_11043)).booleanValue() && ((Boolean)this.layout.get(class_2350.field_11035)).booleanValue() || ((Boolean)this.layout.get(class_2350.field_11034)).booleanValue() && ((Boolean)this.layout.get(class_2350.field_11039)).booleanValue()) {
                    yield MansionFeature.CORRIDOR_STRAIGHT;
                }
                yield MansionFeature.CORRIDOR_CORNER;
            }
            case 3 -> MansionFeature.CORRIDOR_T;
            case 4 -> MansionFeature.CORRIDOR_CROSS;
            default -> MansionFeature.STAIR_DOWN;
        };
        return ids.get(random.nextInt(ids.size()));
    }

    public class_2470 getRotation(Random random) {
        if (this.type.hasColumnRotation()) {
            int index = Math.abs((this.getPosition().method_10263() + this.getPosition().method_10260()) % 4);
            return class_2470.values()[index];
        }
        if (this.type == RoomType.GARDEN) {
            return class_2470.method_16548((Random)random);
        }
        if (this.type != RoomType.CORRIDOR) {
            return class_2470.method_16548((Random)random);
        }
        switch (this.layout.doorCount()) {
            case 1: {
                if (((Boolean)this.layout.get(class_2350.field_11035)).booleanValue()) {
                    return class_2470.field_11467;
                }
                if (((Boolean)this.layout.get(class_2350.field_11043)).booleanValue()) {
                    return class_2470.field_11464;
                }
                if (((Boolean)this.layout.get(class_2350.field_11034)).booleanValue()) {
                    return class_2470.field_11463;
                }
                if (((Boolean)this.layout.get(class_2350.field_11039)).booleanValue()) {
                    return class_2470.field_11465;
                }
            }
            case 2: {
                if (((Boolean)this.layout.get(class_2350.field_11035)).booleanValue() && ((Boolean)this.layout.get(class_2350.field_11043)).booleanValue()) {
                    return class_2470.field_11467;
                }
                if (((Boolean)this.layout.get(class_2350.field_11035)).booleanValue() && ((Boolean)this.layout.get(class_2350.field_11034)).booleanValue()) {
                    return class_2470.field_11463;
                }
                if (((Boolean)this.layout.get(class_2350.field_11035)).booleanValue() && ((Boolean)this.layout.get(class_2350.field_11039)).booleanValue()) {
                    return class_2470.field_11464;
                }
                if (((Boolean)this.layout.get(class_2350.field_11034)).booleanValue() && ((Boolean)this.layout.get(class_2350.field_11039)).booleanValue()) {
                    return class_2470.field_11463;
                }
                if (((Boolean)this.layout.get(class_2350.field_11043)).booleanValue() && ((Boolean)this.layout.get(class_2350.field_11034)).booleanValue()) {
                    return class_2470.field_11467;
                }
                if (((Boolean)this.layout.get(class_2350.field_11043)).booleanValue() && ((Boolean)this.layout.get(class_2350.field_11039)).booleanValue()) {
                    return class_2470.field_11465;
                }
            }
            case 3: {
                if (((Boolean)this.layout.get(class_2350.field_11043)).booleanValue() && ((Boolean)this.layout.get(class_2350.field_11035)).booleanValue() && ((Boolean)this.layout.get(class_2350.field_11039)).booleanValue()) {
                    return class_2470.field_11464;
                }
                if (((Boolean)this.layout.get(class_2350.field_11043)).booleanValue() && ((Boolean)this.layout.get(class_2350.field_11035)).booleanValue() && ((Boolean)this.layout.get(class_2350.field_11034)).booleanValue()) {
                    return class_2470.field_11467;
                }
                if (((Boolean)this.layout.get(class_2350.field_11043)).booleanValue() && ((Boolean)this.layout.get(class_2350.field_11034)).booleanValue() && ((Boolean)this.layout.get(class_2350.field_11039)).booleanValue()) {
                    return class_2470.field_11465;
                }
                if (((Boolean)this.layout.get(class_2350.field_11035)).booleanValue() && ((Boolean)this.layout.get(class_2350.field_11034)).booleanValue() && ((Boolean)this.layout.get(class_2350.field_11039)).booleanValue()) {
                    return class_2470.field_11463;
                }
            }
            case 4: {
                return class_2470.values()[random.nextInt(class_2470.values().length)];
            }
            case 0: {
                return class_2470.field_11467;
            }
        }
        return null;
    }

    public class_2338 getOffsetForRotation(class_2338 offsetPos, class_2470 rotation) {
        switch (rotation) {
            case field_11467: {
                return offsetPos;
            }
            case field_11463: {
                return offsetPos.method_10069(10, 0, 0);
            }
            case field_11464: {
                return offsetPos.method_10069(10, 0, 10);
            }
            case field_11465: {
                return offsetPos.method_10069(0, 0, 10);
            }
        }
        return offsetPos;
    }

    public boolean isConnected(class_2350 direction) {
        return (Boolean)this.layout.get(direction);
    }

    public boolean canSupportRoof() {
        return true;
    }

    public void setSortValue(int sortValue) {
        this.sortValue = sortValue;
    }

    public int getSortValue() {
        return this.sortValue;
    }

    public boolean hasGroundModifications() {
        return this.getPosition().method_10264() == 0;
    }

    public void addWalls(Random random, class_2338 wallPos, class_3485 manager, Grid<MansionRoom> roomGrid, class_6626 children) {
        boolean ground = this.hasGroundModifications();
        if (this.getRoomType().hasWalls()) {
            class_2338 cornerPos1;
            if (this.isConnected(class_2350.field_11043)) {
                children.method_35462((class_3443)new MansionFeature.Piece(manager, this.getInnerWall(random), wallPos.method_10079(class_2350.field_11043, 2), class_2470.field_11467, ground, false));
            } else if (!roomGrid.contains(this.getPosition().method_10095()) || !roomGrid.get(this.getPosition().method_10095()).getRoomType().hasWalls()) {
                children.method_35462((class_3443)new MansionFeature.Piece(manager, this.getOuterWall(class_2350.field_11043, roomGrid, random), wallPos.method_10079(class_2350.field_11034, 11), class_2470.field_11464, ground, true));
            } else if (roomGrid.contains(this.getPosition().method_10095())) {
                children.method_35462((class_3443)new MansionFeature.Piece(manager, this.getFlatWall(random), wallPos.method_10079(class_2350.field_11043, 2), class_2470.field_11467, ground, false));
            }
            if (this.isConnected(class_2350.field_11039)) {
                children.method_35462((class_3443)new MansionFeature.Piece(manager, this.getInnerWall(random), wallPos, class_2470.field_11463, ground, false));
            } else if (!roomGrid.contains(this.getPosition().method_10067()) || !roomGrid.get(this.getPosition().method_10067()).getRoomType().hasWalls()) {
                children.method_35462((class_3443)new MansionFeature.Piece(manager, this.getOuterWall(class_2350.field_11039, roomGrid, random), wallPos.method_10095(), class_2470.field_11463, ground, true));
            } else if (roomGrid.contains(this.getPosition().method_10067())) {
                children.method_35462((class_3443)new MansionFeature.Piece(manager, this.getFlatWall(random), wallPos, class_2470.field_11463, ground, false));
            }
            if (!roomGrid.contains(this.getPosition().method_10078()) || !roomGrid.get(this.getPosition().method_10078()).getRoomType().hasWalls()) {
                children.method_35462((class_3443)new MansionFeature.Piece(manager, this.getOuterWall(class_2350.field_11034, roomGrid, random), wallPos.method_10079(class_2350.field_11034, 11).method_10067().method_10077(11), class_2470.field_11465, ground, true));
            }
            if (!roomGrid.contains(this.getPosition().method_10072()) || !roomGrid.get(this.getPosition().method_10072()).getRoomType().hasWalls()) {
                children.method_35462((class_3443)new MansionFeature.Piece(manager, this.getOuterWall(class_2350.field_11035, roomGrid, random), wallPos.method_10079(class_2350.field_11035, 10).method_10067(), class_2470.field_11467, ground, true));
            }
            if (roomGrid.contains(cornerPos1 = this.getPosition().method_10093(class_2350.field_11043).method_10093(class_2350.field_11039)) && roomGrid.get(cornerPos1).getRoomType().hasWalls()) {
                children.method_35462((class_3443)new MansionFeature.Piece(manager, MansionFeature.CORNER_FILLER.toString(), wallPos.method_10093(class_2350.field_11039).method_10093(class_2350.field_11043).method_10069(0, 0, 0), class_2470.field_11467, ground, false));
            }
        }
    }

    public String getInnerWall(Random random) {
        return MansionFeature.INNER_WALL.get(random.nextInt(MansionFeature.INNER_WALL.size())).toString();
    }

    public String getFlatWall(Random random) {
        return MansionFeature.FLAT_WALL.get(random.nextInt(MansionFeature.FLAT_WALL.size())).toString();
    }

    public String getOuterWall(class_2350 dir, Grid<MansionRoom> roomGrid, Random random) {
        if (this.getPosition().method_10264() > 0) {
            if (this.getRoomType().hasWindows() && random.nextFloat() < 0.95f && !roomGrid.contains(this.getPosition().method_10093(dir))) {
                return MansionFeature.OUTER_WINDOW.get(random.nextInt(MansionFeature.OUTER_WINDOW.size())).toString();
            }
            return MansionFeature.OUTER_WALL.get(random.nextInt(MansionFeature.OUTER_WALL.size())).toString();
        }
        return MansionFeature.OUTER_WALL_BASE.get(random.nextInt(MansionFeature.OUTER_WALL_BASE.size())).toString();
    }

    public void setLayout(MansionRoom currentRoom) {
        for (class_2350 direction : BMUtil.HORIZONTALS) {
            this.getLayout().put(direction, (Boolean)currentRoom.getLayout().get(direction));
        }
    }
}

