/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature.mansion;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import party.lemons.biomemakeover.level.feature.mansion.LayoutType;
import party.lemons.biomemakeover.level.feature.mansion.RoomType;
import party.lemons.biomemakeover.level.feature.mansion.processor.CorridorReplaceProcessor;
import party.lemons.biomemakeover.level.feature.mansion.processor.FloorRoomReplaceProcessor;
import party.lemons.biomemakeover.level.feature.mansion.processor.GardenRoomReplaceProcessor;
import party.lemons.biomemakeover.level.feature.mansion.room.BigMansionRoom;
import party.lemons.biomemakeover.level.feature.mansion.room.BossRoom;
import party.lemons.biomemakeover.level.feature.mansion.room.DungeonRoom;
import party.lemons.biomemakeover.level.feature.mansion.room.EntranceRoom;
import party.lemons.biomemakeover.level.feature.mansion.room.MansionRoom;
import party.lemons.biomemakeover.level.feature.mansion.room.RoofMansionRoom;
import party.lemons.biomemakeover.util.BMUtil;
import party.lemons.biomemakeover.util.Grid;
import party.lemons.biomemakeover.util.RandomUtil;

public class MansionLayout {
    protected final Grid<MansionRoom> layout = new Grid();
    protected final List<FloorRoomReplaceProcessor> floorProcessors = Lists.newArrayList();

    public MansionLayout() {
        this.floorProcessors.add(new CorridorReplaceProcessor());
        this.floorProcessors.add(new GardenRoomReplaceProcessor());
    }

    public void generateLayout(Random random, int startY) {
        int floorCorridorTarget = 10 + random.nextInt(5);
        int floors = 4 + random.nextInt(4);
        int floorRoomTarget = floorCorridorTarget - random.nextInt(5);
        ArrayList allRooms = Lists.newArrayList();
        ArrayList corridorStarts = Lists.newArrayList((Object[])new class_2338.class_2339[]{new class_2338.class_2339(0, 0, 0)});
        for (int floor = 0; floor < floors; ++floor) {
            List<MansionRoom> corridors = this.placeCorridors(floor, floorCorridorTarget, corridorStarts, random);
            allRooms.addAll(corridors.stream().filter(c -> c.getRoomType() != RoomType.CORRIDOR).collect(Collectors.toList()));
            corridors.removeIf(c -> c.getRoomType() != RoomType.CORRIDOR);
            List<Object> rooms = Lists.newArrayList();
            if (corridors.size() > 0) {
                rooms = this.placeRooms(floor, floorRoomTarget, random);
            }
            if (floor < floors - 1 && corridors.size() > 0) {
                corridorStarts.clear();
                for (int i = 0; i < Math.max(1, 1 + random.nextInt(3) - floor); ++i) {
                    MansionRoom stairCase = corridors.get(random.nextInt(corridors.size()));
                    stairCase.setRoomType(RoomType.STAIRS_UP);
                    class_2338 stairPos = stairCase.getPosition().method_10084();
                    MansionRoom upStairs = new MansionRoom(stairPos, RoomType.STAIRS_DOWN);
                    upStairs.setLayoutType(LayoutType.REQUIRED);
                    this.layout.put(stairPos, upStairs);
                    corridorStarts.add(new class_2338.class_2339(stairPos.method_10263(), stairPos.method_10264(), stairPos.method_10260()));
                }
            }
            floorCorridorTarget = (int)((float)floorCorridorTarget / 1.5f);
            floorRoomTarget = (int)((float)floorRoomTarget / 1.5f);
            allRooms.addAll(rooms);
            allRooms.addAll(corridors);
            int size = allRooms.size();
            ArrayList floorRooms = Lists.newArrayList();
            floorRooms.addAll(rooms);
            floorRooms.addAll(corridors);
            block2: for (int i = 0; i < floorRooms.size(); ++i) {
                MansionRoom room = (MansionRoom)floorRooms.get(i);
                if (!room.getRoomType().isReplaceable()) continue;
                for (FloorRoomReplaceProcessor processor : this.floorProcessors) {
                    if (!processor.isValid(random, floor, this.layout, room)) continue;
                    room.active = false;
                    MansionRoom newRoom = processor.getReplaceRoom(room);
                    newRoom.active = true;
                    this.layout.put(room.getPosition(), newRoom);
                    rooms.add(newRoom);
                    continue block2;
                }
            }
            rooms.removeIf(rm -> !rm.active);
            corridors.removeIf(rm -> !rm.active);
            allRooms.removeIf(rm -> !rm.active);
        }
        this.layout.getEntries().forEach(rm -> rm.setLayout(this, random));
        this.layout.getEntries().forEach(rm -> {
            if (rm.getRoomType() == RoomType.CORRIDOR && (random.nextFloat() < 0.3f || rm.getLayout().doorCount() < 2)) {
                rm.setRoomType(RoomType.ROOM);
            }
        });
        allRooms.removeIf(rm -> !rm.active);
        this.createEntrance(random, allRooms);
        this.createDungeon(random, allRooms, startY);
        this.createTowers(random, allRooms);
        this.createBigRooms(random, allRooms);
        Iterator it = allRooms.iterator();
        class_2338.class_2339 upPos = new class_2338.class_2339();
        ArrayList roofs = Lists.newArrayList();
        while (it.hasNext()) {
            MansionRoom rm2 = (MansionRoom)it.next();
            upPos.method_10103(rm2.getPosition().method_10263(), rm2.getPosition().method_10264() + 1, rm2.getPosition().method_10260());
            if (!rm2.canSupportRoof() || this.layout.contains((class_2338)upPos)) continue;
            class_2338 immu = upPos.method_10062();
            RoofMansionRoom roofRoom = new RoofMansionRoom(immu);
            this.layout.put(immu, roofRoom);
            roofs.add(roofRoom);
        }
        roofs.forEach(rm -> rm.setLayout(this, random));
    }

    private void createBigRooms(Random random, List<MansionRoom> allRooms) {
        block0: for (int i = 0; i < allRooms.size(); ++i) {
            MansionRoom currentRoom = allRooms.get(i);
            if (!currentRoom.active || currentRoom.getRoomType() != RoomType.ROOM) continue;
            for (class_2350 dir : BMUtil.randomOrderedHorizontals()) {
                class_2338 offset = currentRoom.getPosition().method_10093(dir);
                if (!this.getLayout().contains(offset)) continue;
                MansionRoom offsetRoom = this.getLayout().get(offset);
                if (!offsetRoom.active || offsetRoom.getRoomType() != RoomType.ROOM || !(random.nextFloat() < 0.25f)) continue;
                BigMansionRoom bigRoom = new BigMansionRoom(currentRoom.getPosition(), dir, false);
                BigMansionRoom bigRoomDummy = new BigMansionRoom(offset, dir.method_10153(), true);
                bigRoom.setLayout(currentRoom);
                bigRoomDummy.setLayout(offsetRoom);
                currentRoom.active = false;
                offsetRoom.active = false;
                this.getLayout().put(currentRoom.getPosition(), bigRoom);
                this.getLayout().put(offset, bigRoomDummy);
                continue block0;
            }
        }
    }

    protected void createEntrance(Random random, List<MansionRoom> allRooms) {
        MansionRoom entranceConnected = null;
        class_2350 offsetDirection = null;
        List possibleRooms = allRooms.stream().filter(room -> room.getPosition().method_10264() == 0 && room.getRoomType().hasWalls()).collect(Collectors.toList());
        Collections.shuffle(possibleRooms);
        for (MansionRoom room2 : possibleRooms) {
            class_2350 outSide;
            if (room2.getPosition().method_10264() != 0 || !room2.getRoomType().hasWalls() || (outSide = this.getOutsideDirection(room2.getPosition())) == null) continue;
            entranceConnected = room2;
            offsetDirection = outSide;
            break;
        }
        class_2338 entrancePos = entranceConnected.getPosition().method_10093(offsetDirection);
        EntranceRoom entranceRoom = new EntranceRoom(entrancePos, RoomType.ENTRANCE);
        entranceRoom.getLayout().put(offsetDirection.method_10153(), true);
        entranceConnected.getLayout().put(offsetDirection, true);
        this.layout.put(entrancePos, entranceRoom);
        allRooms.add(entranceRoom);
    }

    private class_2350 getOutsideDirection(class_2338 pos) {
        if (this.layout.getMinX() == pos.method_10263()) {
            return class_2350.field_11039;
        }
        if (this.layout.getMaxX() == pos.method_10263()) {
            return class_2350.field_11034;
        }
        if (this.layout.getMinZ() == pos.method_10260()) {
            return class_2350.field_11043;
        }
        if (this.layout.getMaxZ() == pos.method_10260()) {
            return class_2350.field_11035;
        }
        return null;
    }

    protected void createTowers(Random random, List<MansionRoom> allRooms) {
        int maxTowers = 3;
        int maxTowerHeight = 3;
        for (int i = 1; i < 3; ++i) {
            MansionRoom room = allRooms.get(random.nextInt(allRooms.size()));
            if (!room.canSupportRoof()) continue;
            while (this.layout.contains(room.getPosition().method_10084())) {
                room = this.layout.get(room.getPosition().method_10084());
            }
            if (!room.getRoomType().isReplaceable()) continue;
            room.setRoomType(RoomType.TOWER_BASE);
            class_2338 towerPos = room.getPosition().method_10084();
            int height = 1 + random.nextInt(3);
            for (int t = 0; t < height; ++t) {
                this.layout.put(towerPos, new MansionRoom(towerPos, RoomType.TOWER_MID));
                towerPos = towerPos.method_10084();
            }
            this.layout.put(towerPos, new MansionRoom(towerPos, RoomType.TOWER_TOP));
        }
    }

    protected void createDungeon(Random random, List<MansionRoom> allRooms, int startY) {
        MansionRoom dungeonStairs;
        int maxY = 30;
        int downStep = 7;
        while ((dungeonStairs = allRooms.get(random.nextInt(allRooms.size()))).getPosition().method_10264() != 0 || !dungeonStairs.getRoomType().isReplaceable()) {
        }
        dungeonStairs.setRoomType(RoomType.DUNGEON_STAIRS_TOP);
        float downDiff = startY - 30;
        int amt = (int)Math.floor(downDiff / 7.0f);
        class_2338 dungeonPos = dungeonStairs.getPosition().method_10074();
        for (int i = 0; i < amt - 1; ++i) {
            MansionRoom dungeonStairsMid = new MansionRoom(dungeonPos, RoomType.DUNGEON_STAIRS_MID);
            this.layout.put(dungeonPos, dungeonStairsMid);
            dungeonPos = dungeonPos.method_10074();
        }
        DungeonRoom dungeonStairsBottom = new DungeonRoom(dungeonPos, RoomType.DUNGEON_STAIRS_BOTTOM);
        this.layout.put(dungeonPos, dungeonStairsBottom);
        class_2338 dungeonStart = new class_2338((class_2382)dungeonPos);
        class_2350 bossDir = BMUtil.randomHorizontal();
        ArrayList dungeonRooms = Lists.newArrayList();
        dungeonRooms.add(dungeonStairsBottom);
        int dungeonCorridorLength = RandomUtil.randomRange(4, 6);
        for (int i = 1; i < dungeonCorridorLength; ++i) {
            class_2338 roomPos = dungeonStart.method_10079(bossDir, i);
            DungeonRoom room = new DungeonRoom(roomPos, RoomType.DUNGEON_ROOM);
            room.setLayoutType(LayoutType.REQUIRED);
            room.getLayout().put(bossDir, true);
            this.layout.put(roomPos, room);
            dungeonRooms.add(room);
        }
        class_2338 bossPos = dungeonStart.method_10079(bossDir, dungeonCorridorLength + 1);
        BossRoom bossRoom = new BossRoom(bossPos);
        bossRoom.getLayout().put(bossDir.method_10153(), true);
        this.layout.put(bossPos, bossRoom);
        for (int i = 0; i < 10; ++i) {
            class_2350 dir;
            MansionRoom rm2;
            while ((rm2 = (MansionRoom)dungeonRooms.get(random.nextInt(dungeonRooms.size()))).getPosition().equals((Object)dungeonPos.method_10079(bossDir, dungeonCorridorLength - 1))) {
            }
            while ((dir = BMUtil.randomHorizontal()) == bossDir || dir == bossDir.method_10153()) {
            }
            class_2338 offPos = rm2.getPosition().method_10093(dir);
            if (this.layout.contains(offPos)) continue;
            DungeonRoom offsetRoom = new DungeonRoom(offPos, RoomType.DUNGEON_ROOM);
            offsetRoom.setLayoutType(LayoutType.REQUIRED);
            this.layout.put(offPos, offsetRoom);
            dungeonRooms.add(offsetRoom);
        }
        dungeonRooms.forEach(rm -> rm.setLayout(this, random));
    }

    public List<MansionRoom> placeCorridors(int y, int maxCount, List<class_2338.class_2339> positions, Random random) {
        int attempts = 20;
        int placed = 0;
        ArrayList corridors = Lists.newArrayList();
        for (class_2338 class_23382 : positions) {
            MansionRoom room = this.layout.get(class_23382.method_10062());
            if (room == null) continue;
            corridors.add(room);
        }
        class_2338.class_2339 pos = y == 0 ? positions.get(0) : ((MansionRoom)corridors.get(random.nextInt(corridors.size()))).getPosition().method_25503();
        while (placed < maxCount && attempts > 0) {
            if (!this.layout.contains((class_2338)pos)) {
                attempts = 20;
                if (y != 0 && !this.layout.contains(pos.method_10074())) {
                    this.setNextPos(corridors, random, y, pos);
                    continue;
                }
                if (y == 0 || this.layout.get(pos.method_10074()).canSupportRoof()) {
                    MansionRoom mansionRoom = new MansionRoom(pos.method_10062(), RoomType.CORRIDOR);
                    mansionRoom.setLayoutType(LayoutType.REQUIRED);
                    this.layout.put(pos.method_10062(), mansionRoom);
                    corridors.add(mansionRoom);
                    ++placed;
                }
            }
            this.setNextPos(corridors, random, y, pos);
            --attempts;
        }
        return corridors;
    }

    private void setNextPos(List<MansionRoom> corridors, Random random, int y, class_2338.class_2339 pos) {
        class_2338 nextPos;
        class_2338 checkPos = nextPos = corridors.get(random.nextInt(corridors.size())).getPosition();
        for (class_2350 dir : BMUtil.randomOrderedHorizontals()) {
            checkPos = nextPos.method_10093(dir);
            if (y != 0 && (!this.layout.contains(checkPos.method_10074()) || !this.layout.get(checkPos.method_10074()).canSupportRoof())) continue;
            break;
        }
        pos.method_10103(checkPos.method_10263(), checkPos.method_10264(), checkPos.method_10260());
    }

    public List<MansionRoom> placeRooms(int y, int maxCount, Random random) {
        int roomsPlaced = 0;
        int roomTarget = maxCount;
        int attempts = 500;
        ArrayList rooms = Lists.newArrayList();
        class_2338 lastSuccess = null;
        while (attempts > 0 && roomsPlaced < roomTarget) {
            class_2338.class_2339 randomPos = new class_2338.class_2339(RandomUtil.randomRange(this.layout.getMinX(), this.layout.getMaxX()), y, RandomUtil.randomRange(this.layout.getMinZ(), this.layout.getMaxZ()));
            if (lastSuccess != null && random.nextFloat() < 0.1f) {
                randomPos = new class_2338.class_2339(lastSuccess.method_10263(), lastSuccess.method_10264(), lastSuccess.method_10260());
            }
            if (this.layout.contains((class_2338)randomPos)) {
                if (y != 0 && !this.layout.contains(randomPos.method_10074())) continue;
                MansionRoom existingRoom = this.layout.get((class_2338)randomPos);
                if (this.layout.contains((class_2338)(randomPos = randomPos.method_10098(class_2350.method_10139((int)random.nextInt(4))))) || y != 0 && (!this.layout.contains(randomPos.method_10074()) || !this.layout.get(randomPos.method_10074()).canSupportRoof())) continue;
                MansionRoom newRoom = new MansionRoom(randomPos.method_10062(), RoomType.ROOM);
                this.layout.put((class_2338)randomPos, newRoom);
                if (existingRoom.getRoomType() == RoomType.ROOM) {
                    newRoom.setLayoutType(LayoutType.REQUIRED);
                }
                rooms.add(newRoom);
                ++roomsPlaced;
                lastSuccess = new class_2338(randomPos.method_10263(), randomPos.method_10264(), randomPos.method_10260());
                continue;
            }
            --attempts;
        }
        return rooms;
    }

    public Grid<MansionRoom> getLayout() {
        return this.layout;
    }
}

