/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature.mansion;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3037;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3470;
import net.minecraft.class_3485;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3730;
import net.minecraft.class_3793;
import net.minecraft.class_4638;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5539;
import net.minecraft.class_6622;
import net.minecraft.class_6625;
import net.minecraft.class_6626;
import net.minecraft.class_6796;
import net.minecraft.class_6819;
import net.minecraft.class_6834;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.block.AbstractTapestryBlock;
import party.lemons.biomemakeover.block.AbstractTapestryWallBlock;
import party.lemons.biomemakeover.block.IvyBlock;
import party.lemons.biomemakeover.entity.OwlEntity;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorEntity;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.init.BMWorldGen;
import party.lemons.biomemakeover.level.feature.mansion.MansionLayout;
import party.lemons.biomemakeover.level.feature.mansion.RoomType;
import party.lemons.biomemakeover.level.feature.mansion.room.MansionRoom;
import party.lemons.biomemakeover.util.DirectionalDataHandler;
import party.lemons.biomemakeover.util.Grid;
import party.lemons.biomemakeover.util.RandomUtil;
import party.lemons.biomemakeover.util.extension.Stuntable;
import party.lemons.biomemakeover.util.registry.WoodTypeInfo;

public class MansionFeature
extends class_3195<class_3111> {
    public static final class_3793 IGNORE_AIR_AND_STRUCTURE_BLOCKS = new class_3793((List)ImmutableList.of((Object)class_2246.field_10124, (Object)class_2246.field_10465, (Object)BMBlocks.DIRECTIONAL_DATA));
    public static final class_3793 IGNORE_STRUCTURE_BLOCKS = new class_3793((List)ImmutableList.of((Object)class_2246.field_10465, (Object)BMBlocks.DIRECTIONAL_DATA));
    private static final class_2960 LOOT_ARROW = BiomeMakeover.ID("mansion/arrows");
    private static final class_2960 LOOT_DUNGEON_JUNK = BiomeMakeover.ID("mansion/dungeon_junk");
    private static final class_2960 LOOT_DUNGEON_STANDARD = BiomeMakeover.ID("mansion/dungeon");
    private static final class_2960 LOOT_DUNGEON_GOOD = BiomeMakeover.ID("mansion/dungeon_good");
    private static final class_2960 LOOT_JUNK = BiomeMakeover.ID("mansion/junk");
    private static final class_2960 LOOT_STANDARD = BiomeMakeover.ID("mansion/standard");
    private static final class_2960 LOOT_GOOD = BiomeMakeover.ID("mansion/good");
    public static List<class_2960> CORRIDOR_STRAIGHT = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/corridor/straight/corridor_straight_1"), BiomeMakeover.ID("mansion/corridor/straight/corridor_straight_2"), BiomeMakeover.ID("mansion/corridor/straight/corridor_straight_3"), BiomeMakeover.ID("mansion/corridor/straight/corridor_straight_4"), BiomeMakeover.ID("mansion/corridor/straight/corridor_straight_5"), BiomeMakeover.ID("mansion/corridor/straight/corridor_straight_6"), BiomeMakeover.ID("mansion/corridor/straight/corridor_straight_7"), BiomeMakeover.ID("mansion/corridor/straight/corridor_straight_8")});
    public static List<class_2960> CORRIDOR_CORNER = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/corridor/corner/corridor_corner_1"), BiomeMakeover.ID("mansion/corridor/corner/corridor_corner_2"), BiomeMakeover.ID("mansion/corridor/corner/corridor_corner_3")});
    public static List<class_2960> CORRIDOR_T = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/corridor/t/corridor_t_1"), BiomeMakeover.ID("mansion/corridor/t/corridor_t_2"), BiomeMakeover.ID("mansion/corridor/t/corridor_t_3")});
    public static List<class_2960> CORRIDOR_CROSS = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/corridor/cross/corridor_cross_1"), BiomeMakeover.ID("mansion/corridor/cross/corridor_cross_2"), BiomeMakeover.ID("mansion/corridor/cross/corridor_cross_3"), BiomeMakeover.ID("mansion/corridor/cross/corridor_cross_4")});
    public static List<class_2960> ROOMS = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/room/room_1"), BiomeMakeover.ID("mansion/room/room_2"), BiomeMakeover.ID("mansion/room/room_3"), BiomeMakeover.ID("mansion/room/room_4"), BiomeMakeover.ID("mansion/room/room_5"), BiomeMakeover.ID("mansion/room/room_6"), BiomeMakeover.ID("mansion/room/room_7"), BiomeMakeover.ID("mansion/room/room_8"), BiomeMakeover.ID("mansion/room/room_9"), BiomeMakeover.ID("mansion/room/room_10"), BiomeMakeover.ID("mansion/room/room_11"), BiomeMakeover.ID("mansion/room/room_12"), BiomeMakeover.ID("mansion/room/room_13"), BiomeMakeover.ID("mansion/room/room_14"), BiomeMakeover.ID("mansion/room/room_15"), BiomeMakeover.ID("mansion/room/room_16"), BiomeMakeover.ID("mansion/room/room_17"), BiomeMakeover.ID("mansion/room/room_18"), BiomeMakeover.ID("mansion/room/room_19"), BiomeMakeover.ID("mansion/room/room_20"), BiomeMakeover.ID("mansion/room/room_21"), BiomeMakeover.ID("mansion/room/room_22"), BiomeMakeover.ID("mansion/room/room_23"), BiomeMakeover.ID("mansion/room/room_24"), BiomeMakeover.ID("mansion/room/room_25"), BiomeMakeover.ID("mansion/room/room_26"), BiomeMakeover.ID("mansion/room/room_27"), BiomeMakeover.ID("mansion/room/room_28"), BiomeMakeover.ID("mansion/room/room_29"), BiomeMakeover.ID("mansion/room/room_30"), BiomeMakeover.ID("mansion/room/room_31"), BiomeMakeover.ID("mansion/room/room_32"), BiomeMakeover.ID("mansion/room/room_33"), BiomeMakeover.ID("mansion/room/room_34")});
    public static List<class_2960> ROOM_BIG = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/room/big/room_big_1"), BiomeMakeover.ID("mansion/room/big/room_big_2"), BiomeMakeover.ID("mansion/room/big/room_big_3"), BiomeMakeover.ID("mansion/room/big/room_big_4"), BiomeMakeover.ID("mansion/room/big/room_big_5"), BiomeMakeover.ID("mansion/room/big/room_big_6"), BiomeMakeover.ID("mansion/room/big/room_big_7"), BiomeMakeover.ID("mansion/room/big/room_big_8"), BiomeMakeover.ID("mansion/room/big/room_big_9"), BiomeMakeover.ID("mansion/room/big/room_big_10"), BiomeMakeover.ID("mansion/room/big/room_big_11")});
    public static List<class_2960> STAIR_UP = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/stairs/up/stairs_up_1"), BiomeMakeover.ID("mansion/stairs/up/stairs_up_2")});
    public static List<class_2960> STAIR_DOWN = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/stairs/down/stairs_down_1"), BiomeMakeover.ID("mansion/stairs/down/stairs_down_2")});
    public static List<class_2960> INNER_WALL = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/wall/inner/wall_1"), BiomeMakeover.ID("mansion/wall/inner/wall_2"), BiomeMakeover.ID("mansion/wall/inner/wall_3"), BiomeMakeover.ID("mansion/wall/inner/wall_4"), BiomeMakeover.ID("mansion/wall/inner/wall_5"), BiomeMakeover.ID("mansion/wall/inner/wall_6"), BiomeMakeover.ID("mansion/wall/inner/wall_7"), BiomeMakeover.ID("mansion/wall/inner/wall_8"), BiomeMakeover.ID("mansion/wall/inner/wall_9")});
    public static List<class_2960> FLAT_WALL = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/wall/flat/wall_flat_1")});
    public static List<class_2960> OUTER_WALL_BASE = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/wall/outer/base/wall_outer_base_2"), BiomeMakeover.ID("mansion/wall/outer/base/wall_outer_base_3"), BiomeMakeover.ID("mansion/wall/outer/base/wall_outer_base_4"), BiomeMakeover.ID("mansion/wall/outer/base/wall_outer_base_5"), BiomeMakeover.ID("mansion/wall/outer/base/wall_outer_base_6"), BiomeMakeover.ID("mansion/wall/outer/base/wall_outer_base_7")});
    public static List<class_2960> OUTER_WALL = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/wall/outer/wall_outer_2"), BiomeMakeover.ID("mansion/wall/outer/wall_outer_3"), BiomeMakeover.ID("mansion/wall/outer/wall_outer_4"), BiomeMakeover.ID("mansion/wall/outer/wall_outer_5"), BiomeMakeover.ID("mansion/wall/outer/wall_outer_6")});
    public static List<class_2960> OUTER_WINDOW = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/wall/outer/window/wall_window_1"), BiomeMakeover.ID("mansion/wall/outer/window/wall_window_2"), BiomeMakeover.ID("mansion/wall/outer/window/wall_window_3"), BiomeMakeover.ID("mansion/wall/outer/window/wall_window_4"), BiomeMakeover.ID("mansion/wall/outer/window/wall_window_5"), BiomeMakeover.ID("mansion/wall/outer/window/wall_window_6"), BiomeMakeover.ID("mansion/wall/outer/window/wall_window_7"), BiomeMakeover.ID("mansion/wall/outer/window/wall_window_8"), BiomeMakeover.ID("mansion/wall/outer/window/wall_window_9"), BiomeMakeover.ID("mansion/wall/outer/window/wall_window_10")});
    public static List<class_2960> GARDEN = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/garden/garden_1"), BiomeMakeover.ID("mansion/garden/garden_2"), BiomeMakeover.ID("mansion/garden/garden_3"), BiomeMakeover.ID("mansion/garden/garden_4"), BiomeMakeover.ID("mansion/garden/garden_5"), BiomeMakeover.ID("mansion/garden/garden_6"), BiomeMakeover.ID("mansion/garden/garden_7")});
    public static List<class_2960> TOWER_BASE = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/tower/base/tower_base_1")});
    public static List<class_2960> TOWER_MID = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/tower/mid/tower_middle_1")});
    public static List<class_2960> TOWER_TOP = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/tower/top/tower_top_1")});
    public static List<class_2960> ROOF_0 = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/roof/roof_0_1"), BiomeMakeover.ID("mansion/roof/roof_0_2"), BiomeMakeover.ID("mansion/roof/roof_0_3"), BiomeMakeover.ID("mansion/roof/roof_0_4")});
    public static List<class_2960> ROOF_1 = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/roof/roof_1_1"), BiomeMakeover.ID("mansion/roof/roof_1_2"), BiomeMakeover.ID("mansion/roof/roof_1_3")});
    public static List<class_2960> ROOF_2 = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/roof/roof_2_1"), BiomeMakeover.ID("mansion/roof/roof_2_2")});
    public static List<class_2960> ROOF_2_STRAIGHT = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/roof/roof_2_straight_1"), BiomeMakeover.ID("mansion/roof/roof_2_straight_2")});
    public static List<class_2960> ROOF_3 = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/roof/roof_3_1"), BiomeMakeover.ID("mansion/roof/roof_3_2"), BiomeMakeover.ID("mansion/roof/roof_3_3")});
    public static List<class_2960> ROOF_4 = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/roof/roof_4_1"), BiomeMakeover.ID("mansion/roof/roof_4_2"), BiomeMakeover.ID("mansion/roof/roof_4_3"), BiomeMakeover.ID("mansion/roof/roof_4_4")});
    public static List<class_2960> ROOF_SPLIT = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/roof/roof_split_1"), BiomeMakeover.ID("mansion/roof/roof_split_2"), BiomeMakeover.ID("mansion/roof/roof_split_3"), BiomeMakeover.ID("mansion/roof/roof_split_4"), BiomeMakeover.ID("mansion/roof/roof_split_5")});
    public static List<class_2960> DUNGEON_DOOR = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/dungeon/door_1"), BiomeMakeover.ID("mansion/dungeon/door_2"), BiomeMakeover.ID("mansion/dungeon/door_3"), BiomeMakeover.ID("mansion/dungeon/door_4"), BiomeMakeover.ID("mansion/dungeon/door_5"), BiomeMakeover.ID("mansion/dungeon/door_6"), BiomeMakeover.ID("mansion/dungeon/door_7")});
    public static List<class_2960> DUNGEON_WALL = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/dungeon/wall_1")});
    public static List<class_2960> DUNGEON_ROOM = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/dungeon/room_1"), BiomeMakeover.ID("mansion/dungeon/room_2"), BiomeMakeover.ID("mansion/dungeon/room_3"), BiomeMakeover.ID("mansion/dungeon/room_4"), BiomeMakeover.ID("mansion/dungeon/room_5"), BiomeMakeover.ID("mansion/dungeon/room_6"), BiomeMakeover.ID("mansion/dungeon/room_7"), BiomeMakeover.ID("mansion/dungeon/room_8"), BiomeMakeover.ID("mansion/dungeon/room_9"), BiomeMakeover.ID("mansion/dungeon/room_10"), BiomeMakeover.ID("mansion/dungeon/room_11"), BiomeMakeover.ID("mansion/dungeon/room_12"), BiomeMakeover.ID("mansion/dungeon/room_13"), BiomeMakeover.ID("mansion/dungeon/room_14"), BiomeMakeover.ID("mansion/dungeon/room_15"), BiomeMakeover.ID("mansion/dungeon/room_16"), BiomeMakeover.ID("mansion/dungeon/room_17"), BiomeMakeover.ID("mansion/dungeon/room_18")});
    public static List<class_2960> DUNGEON_STAIR_BOTTOM = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/dungeon/stair_bottom")});
    public static List<class_2960> DUNGEON_STAIR_MID = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/dungeon/stair_mid_1"), BiomeMakeover.ID("mansion/dungeon/stair_mid_2")});
    public static List<class_2960> DUNGEON_STAIR_TOP = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/dungeon/stair_top")});
    public static List<class_2960> BOSS_ROOM = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/boss_room")});
    public static List<class_2960> ENTRANCE = Lists.newArrayList((Object[])new class_2960[]{BiomeMakeover.ID("mansion/entrance/entrance_1")});
    public static final class_2960 CORNER_FILLER = BiomeMakeover.ID("mansion/corner_filler");
    public static final class_2960 EMPTY = BiomeMakeover.ID("mansion/empty");
    private static final class_1299[] enemies = new class_1299[]{class_1299.field_6117, class_1299.field_6090, class_1299.field_6105};
    private static final class_1299[] ranged_enemies = new class_1299[]{class_1299.field_6105};
    private static final class_1299[] golem_enemies = new class_1299[]{BMEntities.STONE_GOLEM};
    private static final class_1299[] ravagers = new class_1299[]{class_1299.field_6134};
    private static final class_1299[] cow = new class_1299[]{class_1299.field_6085};
    private static final class_2680[] SHROOMS = new class_2680[]{class_2246.field_10559.method_9564(), class_2246.field_10251.method_9564(), BMBlocks.WILD_MUSHROOMS.method_9564()};

    public MansionFeature(Codec<class_3111> codec) {
        super(codec, class_6834.simple((Predicate)class_6834.checkForBiomeOnTop((class_2902.class_2903)class_2902.class_2903.field_13194), MansionFeature::generatePieces));
    }

    public class_2893.class_2895 method_28663() {
        return class_2893.class_2895.field_13173;
    }

    private static <C extends class_3037> void generatePieces(class_6626 builder, class_6622.class_6623<C> ctx) {
        MansionLayout layout = new MansionLayout();
        class_1923 chunkPos = ctx.comp_127();
        class_2794 chunkGenerator = ctx.comp_125();
        class_5539 levelHeightAccessor = ctx.comp_129();
        class_2919 random = ctx.comp_130();
        int x = chunkPos.field_9181 * 16;
        int z = chunkPos.field_9180 * 16;
        class_2338 pos = new class_2338(x, chunkGenerator.method_16397(x, z, class_2902.class_2903.field_13194, levelHeightAccessor), z);
        layout.generateLayout((Random)random, pos.method_10264());
        Grid<MansionRoom> roomGrid = layout.getLayout();
        Collection sortedRooms = roomGrid.getEntries();
        sortedRooms = sortedRooms.stream().sorted(Comparator.comparingInt(MansionRoom::getSortValue)).collect(Collectors.toList());
        sortedRooms.forEach(arg_0 -> MansionFeature.lambda$generatePieces$0(pos, (Random)random, builder, ctx, roomGrid, arg_0));
    }

    protected boolean method_27219() {
        return false;
    }

    private static /* synthetic */ void lambda$generatePieces$0(class_2338 pos, Random random, class_6626 builder, class_6622.class_6623 ctx, Grid roomGrid, MansionRoom rm) {
        int xx = pos.method_10263() + rm.getPosition().method_10263() * 12;
        int yy = pos.method_10264() + rm.getPosition().method_10264() * 7;
        int zz = pos.method_10260() + rm.getPosition().method_10260() * 12;
        class_2338 offsetPos = new class_2338(xx, yy, zz);
        class_2470 rotation = rm.getRotation(random);
        offsetPos = rm.getOffsetForRotation(offsetPos, rotation);
        boolean ground = rm.getPosition().method_10264() == 0;
        class_2960 template = rm.getTemplate(random);
        builder.method_35462((class_3443)new Piece(ctx.comp_126(), template.toString(), offsetPos, rotation, ground, rm.getRoomType() == RoomType.TOWER_MID || rm.getRoomType() == RoomType.TOWER_TOP));
        class_2338 wallPos = new class_2338(xx, yy, zz);
        rm.addWalls(random, wallPos, ctx.comp_126(), roomGrid, builder);
    }

    public static class Piece
    extends class_3470
    implements DirectionalDataHandler {
        private final boolean ground;
        private final boolean isWall;

        public Piece(class_3485 structureManager, String string, class_2338 blockPos, class_2470 rotation, boolean needsGroundAdjustment, boolean isWall) {
            super(BMWorldGen.DarkForest.MANSION_PIECE, 0, structureManager, new class_2960(string), string, Piece.makeSettings(rotation, isWall), blockPos);
            this.ground = needsGroundAdjustment;
            this.isWall = isWall;
        }

        public Piece(class_3485 structureManager, class_2487 compoundTag) {
            super(BMWorldGen.DarkForest.MANSION_PIECE, compoundTag, structureManager, resourceLocation -> Piece.makeSettings(class_2470.valueOf((String)compoundTag.method_10558("Rotation")), compoundTag.method_10577("IsWall")));
            this.ground = compoundTag.method_10577("Ground");
            this.isWall = compoundTag.method_10577("IsWall");
        }

        public Piece(class_6625 ctx, class_2487 compoundTag) {
            this(ctx.comp_135(), compoundTag);
        }

        private static class_3492 makeSettings(class_2470 rotation, boolean isWall) {
            return new class_3492().method_15133(true).method_35476(false).method_15123(rotation).method_15125(class_2415.field_11302).method_16184((class_3491)(isWall ? IGNORE_AIR_AND_STRUCTURE_BLOCKS : IGNORE_STRUCTURE_BLOCKS));
        }

        protected void method_14943(class_6625 structurePieceSerializationContext, class_2487 compoundTag) {
            super.method_14943(structurePieceSerializationContext, compoundTag);
            compoundTag.method_10582("Rotation", this.field_15434.method_15113().name());
            compoundTag.method_10556("Ground", this.ground);
            compoundTag.method_10556("IsWall", this.isWall);
        }

        protected void method_15026(String metadata, class_2338 pos, class_5425 level, Random random, class_3341 boundingBox) {
            if (metadata.equals("boss")) {
                this.spawnBoss(level, pos);
            } else if (metadata.equals("arena_pos")) {
                level.method_8652(pos, class_2246.field_9978.method_9564(), 2);
            }
        }

        private void spawnBoss(class_5425 level, class_2338 pos) {
            AdjudicatorEntity boss = (AdjudicatorEntity)BMEntities.ADJUDICATOR.method_5883((class_1937)level.method_8410());
            boss.method_5971();
            boss.method_5725(pos, 0.0f, 0.0f);
            boss.method_5943(level, level.method_8404(pos), class_3730.field_16474, null, null);
            level.method_30771((class_1297)boss);
            level.method_8652(pos, class_2246.field_10124.method_9564(), 2);
        }

        @Override
        public void handleDirectionalMetadata(String meta, class_2350 dir, class_2338 pos, class_5281 world, Random random) {
            world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
            class_2338 offsetPos = pos.method_10093(dir);
            class_2680 offsetState = world.method_8320(offsetPos);
            switch (meta) {
                case "ivy": {
                    this.generateIvy(dir, pos, world, random);
                    break;
                }
                case "tapestry": {
                    this.generateTapestry(dir, pos, world, random);
                    break;
                }
                case "bonemeal": {
                    break;
                }
                case "spawner_spiders": {
                    class_2586 be;
                    if (offsetState.method_26204() != class_2246.field_10260 || !((be = world.method_8321(offsetPos)) instanceof class_2636)) break;
                    class_2636 spawner = (class_2636)be;
                    spawner.method_11390().method_8274(RandomUtil.choose(class_1299.field_6084, class_1299.field_6079));
                    be.method_5431();
                    break;
                }
                case "owl": {
                    OwlEntity e = (OwlEntity)BMEntities.OWL.method_5883((class_1937)world.method_8410());
                    e.method_5725(pos, 0.0f, 0.0f);
                    if (random.nextFloat() < 0.25f) {
                        Stuntable.setStunted((class_1296)e, true);
                    }
                    world.method_8649((class_1297)e);
                    break;
                }
                case "shroom": {
                    world.method_8652(pos, RandomUtil.choose(SHROOMS), 3);
                }
            }
            if (meta.startsWith("loot")) {
                String[] splits = meta.split("_");
                String table = splits[1];
                int chance = splits.length < 3 ? 100 : Integer.parseInt(splits[2]);
                class_2680 setState = null;
                if (splits.length >= 4) {
                    StringBuilder name = new StringBuilder();
                    for (int i = 3; i < splits.length; ++i) {
                        name.append(splits[i]).append("_");
                    }
                    setState = ((class_2248)class_2378.field_11146.method_10223(new class_2960(name.substring(0, name.length() - 1)))).method_9564();
                }
                if (random.nextInt(100) <= chance) {
                    class_2960 tableID = null;
                    switch (table) {
                        case "arrow": {
                            tableID = LOOT_ARROW;
                            break;
                        }
                        case "dungeonjunk": {
                            tableID = LOOT_DUNGEON_JUNK;
                        }
                        case "dungeon": {
                            tableID = LOOT_DUNGEON_STANDARD;
                            break;
                        }
                        case "dungeongood": {
                            tableID = LOOT_DUNGEON_GOOD;
                            break;
                        }
                        case "junk": {
                            tableID = LOOT_JUNK;
                            break;
                        }
                        case "standard": 
                        case "common": {
                            tableID = LOOT_STANDARD;
                            break;
                        }
                        case "loot_good": 
                        case "good": {
                            tableID = LOOT_GOOD;
                            break;
                        }
                        default: {
                            System.out.println(table);
                        }
                    }
                    class_2586 be = world.method_8321(offsetPos);
                    if (be instanceof class_2621) {
                        class_2621 container = (class_2621)be;
                        container.method_11285(tableID, random.nextLong());
                    }
                } else {
                    world.method_8652(offsetPos, class_2246.field_10124.method_9564(), 3);
                }
                if (setState != null) {
                    world.method_8652(pos, setState, 3);
                }
            } else if (meta.startsWith("enemy")) {
                this.handleSpawning(meta, world, pos, enemies);
            } else if (meta.startsWith("ranger")) {
                this.handleSpawning(meta, world, pos, ranged_enemies);
            } else if (!meta.startsWith("golem")) {
                if (meta.startsWith("ravager")) {
                    this.handleSpawning(meta, world, pos, ravagers);
                } else if (meta.startsWith("cow")) {
                    this.handleSpawning(meta, world, pos, cow);
                }
            }
        }

        private void handleSpawning(String meta, class_5281 world, class_2338 pos, class_1299<?>[] pool) {
            int chance;
            String[] splits = meta.split("_");
            if (splits.length < 2) {
                chance = 100;
            } else {
                chance = Integer.parseInt(splits[1]);
                chance /= 2;
            }
            if (world.method_8409().nextInt(100) <= chance) {
                class_1299<?> type = RandomUtil.choose(pool);
                class_1297 e = type.method_5883((class_1937)world.method_8410());
                if (e == null) {
                    return;
                }
                e.method_5725(pos, 0.0f, 0.0f);
                if (e instanceof class_1308) {
                    class_1308 mob = (class_1308)e;
                    mob.method_5943((class_5425)world, world.method_8404(pos), class_3730.field_16474, null, null);
                    mob.method_5971();
                }
                world.method_30771(e);
            }
        }

        private void doBonemealEffect(class_5281 level, class_2338 pos, Random random) {
            class_2338 blockPos = pos.method_10084();
            class_2680 blockState = class_2246.field_10479.method_9564();
            for (int i = 0; i < 128; ++i) {
                class_2338 placePos = blockPos;
                for (int j = 0; j < i / 16; ++j) {
                    if (level.method_8320((placePos = placePos.method_10069(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).method_10074()).method_27852(class_2246.field_10219) && !level.method_8320(placePos).method_26234((class_1922)level, placePos)) continue;
                }
                class_2338 blockPos2 = blockPos.method_10084();
                class_2680 blockState2 = class_2246.field_10479.method_9564();
                block2: for (int l = 0; l < 128; ++l) {
                    class_6796 placedFeature;
                    class_2338 blockPos3 = blockPos2;
                    for (int j = 0; j < l / 16; ++j) {
                        if (!level.method_8320((blockPos3 = blockPos3.method_10069(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).method_10074()).method_27852(class_2246.field_10219) || level.method_8320(blockPos3).method_26234((class_1922)level, blockPos3)) continue block2;
                    }
                    class_2680 blockState3 = level.method_8320(blockPos3);
                    if (blockState3.method_27852(blockState2.method_26204()) && random.nextInt(10) == 0) {
                        ((class_2256)blockState2.method_26204()).method_9652(level.method_8410(), random, blockPos3, blockState3);
                    }
                    if (!blockState3.method_26215()) continue;
                    if (random.nextInt(8) == 0) {
                        List list = level.method_23753(blockPos3).method_30970().method_30982();
                        if (list.isEmpty()) continue;
                        placedFeature = (class_6796)((class_4638)((class_2975)list.get(0)).method_30381()).comp_155().get();
                    } else {
                        placedFeature = class_6819.field_36173;
                    }
                    placedFeature.method_39644(level, level.method_8410().method_14178().method_12129(), random, blockPos3);
                }
            }
        }

        private void generateTapestry(class_2350 dir, class_2338 pos, class_5281 world, Random random) {
            if (dir == class_2350.field_11033 || dir == class_2350.field_11036) {
                class_2248 tapestryBlock = RandomUtil.choose(BMBlocks.TAPESTRY_FLOOR_BLOCKS);
                world.method_8652(pos, (class_2680)tapestryBlock.method_9564().method_11657((class_2769)AbstractTapestryBlock.ROTATION, (Comparable)Integer.valueOf(class_2470.method_16548((Random)random).ordinal())), 3);
            } else {
                class_2248 tapestryBlock = RandomUtil.choose(BMBlocks.TAPESTRY_WALL_BLOCKS);
                world.method_8652(pos, (class_2680)tapestryBlock.method_9564().method_11657((class_2769)AbstractTapestryWallBlock.FACING, (Comparable)dir.method_10153()), 3);
            }
        }

        private void generateIvy(class_2350 dir, class_2338 pos, class_5281 world, Random random) {
            class_2338 endPos;
            class_2338 startPos;
            if (random.nextFloat() < 0.25f) {
                return;
            }
            class_2338 topPos = world.method_8598(class_2902.class_2903.field_13197, pos.method_10079(dir.method_10153(), 2)).method_10074();
            class_2680 topState = world.method_8320(topPos);
            if (topState.method_27852(BMBlocks.ANCIENT_OAK_WOOD_INFO.getBlock(WoodTypeInfo.Type.SLAB)) || topState.method_27852(BMBlocks.ANCIENT_OAK_WOOD_INFO.getBlock(WoodTypeInfo.Type.STAIR))) {
                return;
            }
            int size = 3;
            if (dir.method_10164() == 0) {
                class_2350 rot1 = dir.method_10170();
                class_2350 rot2 = dir.method_10160();
                startPos = pos.method_10079(rot1, size).method_10079(class_2350.field_11036, size);
                endPos = pos.method_10079(rot2, size).method_10079(class_2350.field_11033, size);
            } else {
                startPos = pos.method_10069(-size, 0, -size);
                endPos = pos.method_10069(size, 0, size);
            }
            class_2338.method_10097((class_2338)startPos, (class_2338)endPos).forEach(p -> {
                class_2338 onPos;
                class_2680 onState;
                class_2680 currentState = world.method_8320(p);
                if (random.nextFloat() <= 0.25f && (currentState.method_26215() || currentState.method_27852((class_2248)BMBlocks.IVY)) && (onState = world.method_8320(onPos = p.method_10093(dir))).method_26206((class_1922)world, onPos, dir.method_10153())) {
                    if (currentState.method_27852((class_2248)BMBlocks.IVY)) {
                        world.method_8652(p, (class_2680)currentState.method_11657((class_2769)IvyBlock.getPropertyForDirection(dir), (Comparable)Boolean.valueOf(true)), 3);
                    } else {
                        world.method_8652(p, (class_2680)BMBlocks.IVY.method_9564().method_11657((class_2769)IvyBlock.getPropertyForDirection(dir), (Comparable)Boolean.valueOf(true)), 3);
                    }
                }
            });
        }

        public boolean doesModifyGround() {
            return this.ground;
        }
    }
}

