/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature.foliage;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3341;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4648;
import net.minecraft.class_6017;
import party.lemons.biomemakeover.init.BMWorldGen;

public class WillowFoliagePlacer
extends class_4647 {
    protected final int height;
    protected final boolean doWillows;
    public static final Codec<WillowFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> WillowFoliagePlacer.buildCodec(instance).apply((Applicative)instance, WillowFoliagePlacer::new));

    public WillowFoliagePlacer(class_6017 radius, class_6017 offset, int height, boolean doWillows) {
        super(radius, offset);
        this.height = height;
        this.doWillows = doWillows;
    }

    protected class_4648<?> method_28843() {
        return BMWorldGen.Swamp.WILLOW_FOLIAGE;
    }

    protected void method_23448(class_3746 level, BiConsumer<class_2338, class_2680> biConsumer, Random random, class_4643 treeConfiguration, int trunkHeight, class_4647.class_5208 attachment, int foliageHeight, int radius, int offset) {
        class_3341 box = new class_3341(attachment.method_27388());
        for (int placeOffset = offset; placeOffset >= offset - foliageHeight; --placeOffset) {
            int baseHeight = attachment.method_27389() > 0 ? Math.max(radius + attachment.method_27389() - 1 - placeOffset / 2, 0) : Math.max(radius + attachment.method_27389() - placeOffset / 2, 0);
            this.placeLeavesRow(level, biConsumer, random, treeConfiguration, attachment.method_27388(), baseHeight, placeOffset, attachment.method_27390(), box);
        }
    }

    protected void placeLeavesRow(class_3746 levelSimulatedReader, BiConsumer<class_2338, class_2680> biConsumer, Random random, class_4643 treeConfiguration, class_2338 blockPos, int i, int j, boolean bl, class_3341 box) {
        int k = bl ? 1 : 0;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (int l = -i; l <= i + k; ++l) {
            for (int m = -i; m <= i + k; ++m) {
                if (this.method_27387(random, l, j, m, i, bl)) continue;
                mutableBlockPos.method_25504((class_2382)blockPos, l, j, m);
                class_4647.method_34359((class_3746)levelSimulatedReader, biConsumer, (Random)random, (class_4643)treeConfiguration, (class_2338)mutableBlockPos);
                box.method_34389(new class_2338((class_2382)mutableBlockPos));
            }
        }
    }

    public int method_26989(Random random, int i, class_4643 treeConfiguration) {
        return this.height;
    }

    protected boolean method_23451(Random random, int baseHeight, int dx, int dy, int dz, boolean giantTrunk) {
        if (baseHeight + dy >= 4) {
            return true;
        }
        return baseHeight * baseHeight + dy * dy > dz * dz;
    }

    protected static <P extends WillowFoliagePlacer> Products.P4<RecordCodecBuilder.Mu<P>, class_6017, class_6017, Integer, Boolean> buildCodec(RecordCodecBuilder.Instance<P> instance) {
        return WillowFoliagePlacer.method_30411(instance).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(cdc -> cdc.height)).and((App)Codec.BOOL.fieldOf("doWillows").forGetter(cdc -> cdc.doWillows));
    }
}

