/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature.foliage;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2944;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import party.lemons.biomemakeover.init.BMWorldGen;
import party.lemons.biomemakeover.util.HorizontalDirection;
import party.lemons.biomemakeover.util.RandomUtil;

public class AncientOakTrunkPlacer
extends class_5141 {
    public static final Codec<AncientOakTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> AncientOakTrunkPlacer.method_28904((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, AncientOakTrunkPlacer::new));

    public AncientOakTrunkPlacer(int i, int j, int k) {
        super(i, j, k);
    }

    protected class_5142<?> method_28903() {
        return BMWorldGen.DarkForest.ANCIENT_OAK_TRUNK;
    }

    public List<class_4647.class_5208> method_26991(class_3746 level, BiConsumer<class_2338, class_2680> biConsumer, Random random, int trunkHeight, class_2338 pos, class_4643 treeConfiguration) {
        ArrayList list = Lists.newArrayList();
        class_2338 blockPos = pos.method_10074();
        AncientOakTrunkPlacer.method_27400((class_3746)level, biConsumer, (Random)random, (class_2338)blockPos, (class_4643)treeConfiguration);
        AncientOakTrunkPlacer.method_27400((class_3746)level, biConsumer, (Random)random, (class_2338)blockPos.method_10078(), (class_4643)treeConfiguration);
        AncientOakTrunkPlacer.method_27400((class_3746)level, biConsumer, (Random)random, (class_2338)blockPos.method_10072(), (class_4643)treeConfiguration);
        AncientOakTrunkPlacer.method_27400((class_3746)level, biConsumer, (Random)random, (class_2338)blockPos.method_10072().method_10078(), (class_4643)treeConfiguration);
        int knobSpot = Math.max(5, trunkHeight / 2 - random.nextInt(4));
        boolean knobCount = true;
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        int foliageX = x;
        int foliageZ = z;
        int foliageY = y + trunkHeight - 2;
        for (int genY = 0; genY < trunkHeight; ++genY) {
            int placeY = y + genY;
            class_2338 placePos = new class_2338(foliageX, placeY, foliageZ);
            if (!class_2944.method_16420((class_3746)level, (class_2338)placePos)) continue;
            AncientOakTrunkPlacer.method_35375((class_3746)level, biConsumer, (Random)random, (class_2338)placePos, (class_4643)treeConfiguration);
            AncientOakTrunkPlacer.method_35375((class_3746)level, biConsumer, (Random)random, (class_2338)placePos.method_10078(), (class_4643)treeConfiguration);
            AncientOakTrunkPlacer.method_35375((class_3746)level, biConsumer, (Random)random, (class_2338)placePos.method_10072(), (class_4643)treeConfiguration);
            AncientOakTrunkPlacer.method_35375((class_3746)level, biConsumer, (Random)random, (class_2338)placePos.method_10078().method_10072(), (class_4643)treeConfiguration);
        }
        list.add(new class_4647.class_5208(new class_2338(foliageX, foliageY + 3, foliageZ), 2, true));
        for (int offsetX = -1; offsetX <= 2; ++offsetX) {
            for (int offsetZ = -1; offsetZ <= 2; ++offsetZ) {
                if (offsetX >= 0 && offsetX <= 1 && offsetZ >= 0 && offsetZ <= 1 || random.nextInt(3) > 0) continue;
                int u = random.nextInt(3) + 2;
                for (int v = 0; v < u; ++v) {
                    AncientOakTrunkPlacer.method_35375((class_3746)level, biConsumer, (Random)random, (class_2338)new class_2338(x + offsetX, foliageY - v - 1, z + offsetZ), (class_4643)treeConfiguration);
                }
                list.add(new class_4647.class_5208(new class_2338(foliageX + offsetX, foliageY, foliageZ + offsetZ), 0, false));
            }
        }
        ArrayList directions = Lists.newArrayList();
        for (int i = 0; i < 1 + random.nextInt(4); ++i) {
            this.makeBranch(level, biConsumer, random, list, directions, foliageX, y, foliageZ, RandomUtil.randomRange(trunkHeight - 13, trunkHeight - 7), trunkHeight, treeConfiguration);
        }
        return list;
    }

    public void makeBranch(class_3746 level, BiConsumer<class_2338, class_2680> biConsumer, Random random, List<class_4647.class_5208> foliage, List<HorizontalDirection> directions, int foliageX, int genY, int foliageZ, int branchY, int trunkHeight, class_4643 config) {
        HorizontalDirection lastDirection = null;
        for (int i = 0; i < 2; ++i) {
            int yy;
            HorizontalDirection direction;
            if (lastDirection == null) {
                direction = HorizontalDirection.random(random);
                while (directions.contains((Object)direction)) {
                    direction = HorizontalDirection.random(random);
                }
                directions.add(direction);
                directions.add(direction.opposite());
                lastDirection = direction;
            } else {
                direction = lastDirection.opposite();
                lastDirection = null;
            }
            int genX = foliageX + direction.x;
            int genZ = foliageZ + direction.z;
            int offsetCount = 0;
            for (yy = branchY; yy < trunkHeight - 5 + random.nextInt(4); ++yy) {
                int placeGenY = genY + yy;
                class_2338 placePos2 = new class_2338(genX, placeGenY, genZ);
                if (class_2944.method_16420((class_3746)level, (class_2338)placePos2)) {
                    AncientOakTrunkPlacer.method_35375((class_3746)level, biConsumer, (Random)random, (class_2338)placePos2, (class_4643)config);
                    AncientOakTrunkPlacer.method_35375((class_3746)level, biConsumer, (Random)random, (class_2338)placePos2.method_10078(), (class_4643)config);
                    AncientOakTrunkPlacer.method_35375((class_3746)level, biConsumer, (Random)random, (class_2338)placePos2.method_10072(), (class_4643)config);
                    AncientOakTrunkPlacer.method_35375((class_3746)level, biConsumer, (Random)random, (class_2338)placePos2.method_10078().method_10072(), (class_4643)config);
                }
                if (!random.nextBoolean() || offsetCount > 5) continue;
                ++offsetCount;
                if (direction.isStraight) {
                    genX += direction.x;
                    genZ += direction.z;
                    continue;
                }
                if (yy % 2 == 0) {
                    genX += direction.x;
                    continue;
                }
                genZ += direction.z;
            }
            foliage.add(new class_4647.class_5208(new class_2338(genX, genY + yy + 1, genZ), 1, false));
        }
    }
}

