/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_244;
import net.minecraft.class_251;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2944;
import net.minecraft.class_3031;
import net.minecraft.class_3341;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3499;
import net.minecraft.class_3612;
import net.minecraft.class_3614;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_5281;
import net.minecraft.class_5821;

public class WaterTreeFeature
extends class_3031<class_4643> {
    public WaterTreeFeature(Codec<class_4643> codec) {
        super(codec);
    }

    public static boolean isFree(class_3746 levelSimulatedReader, class_2338 blockPos) {
        return WaterTreeFeature.validTreePos(levelSimulatedReader, blockPos) || levelSimulatedReader.method_16358(blockPos, blockState -> blockState.method_26164((class_3494)class_3481.field_15475));
    }

    private static boolean isVine(class_3746 levelSimulatedReader, class_2338 blockPos) {
        return levelSimulatedReader.method_16358(blockPos, blockState -> blockState.method_27852(class_2246.field_10597));
    }

    private static boolean isBlockWater(class_3746 levelSimulatedReader, class_2338 blockPos) {
        return levelSimulatedReader.method_16358(blockPos, blockState -> blockState.method_27852(class_2246.field_10382));
    }

    private static void setBlockKnownShape(class_1945 levelWriter, class_2338 blockPos, class_2680 blockState) {
        levelWriter.method_8652(blockPos, blockState, 19);
    }

    private static boolean isReplaceablePlant(class_3746 levelSimulatedReader, class_2338 blockPos) {
        return levelSimulatedReader.method_16358(blockPos, blockState -> {
            class_3614 material = blockState.method_26207();
            return material == class_3614.field_15956;
        });
    }

    public static boolean validTreePos(class_3746 levelSimulatedReader, class_2338 blockPos) {
        return class_2944.method_16420((class_3746)levelSimulatedReader, (class_2338)blockPos) || WaterTreeFeature.isReplaceablePlant(levelSimulatedReader, blockPos) || WaterTreeFeature.isBlockWater(levelSimulatedReader, blockPos);
    }

    private boolean doPlace(class_5281 worldGenLevel, Random random, class_2338 blockPos, BiConsumer<class_2338, class_2680> biConsumer, BiConsumer<class_2338, class_2680> biConsumer2, class_4643 treeConfiguration) {
        int i = treeConfiguration.field_24136.method_26993(random);
        int j = treeConfiguration.field_24135.method_26989(random, i, treeConfiguration);
        int k = i - j;
        int l = treeConfiguration.field_24135.method_23452(random, k);
        if (blockPos.method_10264() < worldGenLevel.method_31607() + 1 || blockPos.method_10264() + i + 1 > worldGenLevel.method_31600()) {
            return false;
        }
        OptionalInt optionalInt = treeConfiguration.field_24137.method_27377();
        int m = this.getMaxFreeTreeHeight((class_3746)worldGenLevel, i, blockPos, treeConfiguration);
        if (!(m >= i || optionalInt.isPresent() && m >= optionalInt.getAsInt())) {
            return false;
        }
        List list = treeConfiguration.field_24136.method_26991((class_3746)worldGenLevel, biConsumer, random, m, blockPos, treeConfiguration);
        list.forEach(foliageAttachment -> treeConfiguration.field_24135.method_27385((class_3746)worldGenLevel, biConsumer2, random, treeConfiguration, m, foliageAttachment, j, l));
        return true;
    }

    private int getMaxFreeTreeHeight(class_3746 levelSimulatedReader, int i, class_2338 blockPos, class_4643 treeConfiguration) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (int j = 0; j <= i + 1; ++j) {
            int k = treeConfiguration.field_24137.method_27378(i, j);
            for (int l = -k; l <= k; ++l) {
                for (int m = -k; m <= k; ++m) {
                    mutableBlockPos.method_25504((class_2382)blockPos, l, j, m);
                    if (WaterTreeFeature.isFree(levelSimulatedReader, (class_2338)mutableBlockPos) && (treeConfiguration.field_24138 || !WaterTreeFeature.isVine(levelSimulatedReader, (class_2338)mutableBlockPos))) continue;
                    return j - 2;
                }
            }
        }
        return i;
    }

    protected void method_13153(class_1945 levelWriter, class_2338 blockPos, class_2680 blockState) {
        WaterTreeFeature.setBlockKnownShape(levelWriter, blockPos, blockState);
    }

    public final boolean method_13151(class_5821<class_4643> featurePlaceContext) {
        class_5281 worldGenLevel = featurePlaceContext.method_33652();
        Random random = featurePlaceContext.method_33654();
        class_2338 blockPos2 = featurePlaceContext.method_33655();
        if (featurePlaceContext.method_33652().method_8316(featurePlaceContext.method_33655()).method_15772() != class_3612.field_15910) {
            return false;
        }
        class_4643 treeConfiguration = (class_4643)featurePlaceContext.method_33656();
        HashSet set = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        HashSet set3 = Sets.newHashSet();
        BiConsumer<class_2338, class_2680> biConsumer = (blockPos, blockState) -> {
            set.add(blockPos.method_10062());
            worldGenLevel.method_8652(blockPos, blockState, 19);
        };
        BiConsumer<class_2338, class_2680> biConsumer2 = (blockPos, blockState) -> {
            set2.add(blockPos.method_10062());
            worldGenLevel.method_8652(blockPos, blockState, 19);
        };
        BiConsumer<class_2338, class_2680> biConsumer3 = (blockPos, blockState) -> {
            set3.add(blockPos.method_10062());
            worldGenLevel.method_8652(blockPos, blockState, 19);
        };
        boolean bl = this.doPlace(worldGenLevel, random, blockPos2, biConsumer, biConsumer2, treeConfiguration);
        if (!bl || set.isEmpty() && set2.isEmpty()) {
            return false;
        }
        if (!treeConfiguration.field_21290.isEmpty()) {
            ArrayList list = Lists.newArrayList((Iterable)set);
            ArrayList list2 = Lists.newArrayList((Iterable)set2);
            list.sort(Comparator.comparingInt(class_2382::method_10264));
            list2.sort(Comparator.comparingInt(class_2382::method_10264));
            treeConfiguration.field_21290.forEach(treeDecorator -> treeDecorator.method_23469((class_3746)worldGenLevel, biConsumer3, random, (List)list, (List)list2));
        }
        return class_3341.method_35411((Iterable)Iterables.concat((Iterable)set, (Iterable)set2, (Iterable)set3)).map(bb -> {
            class_251 discreteVoxelShape = WaterTreeFeature.updateLeaves((class_1936)worldGenLevel, bb, set, set3);
            class_3499.method_20532((class_1936)worldGenLevel, (int)3, (class_251)discreteVoxelShape, (int)bb.method_35415(), (int)bb.method_35416(), (int)bb.method_35417());
            return true;
        }).orElse(false);
    }

    private static class_251 updateLeaves(class_1936 levelAccessor, class_3341 boundingBox, Set<class_2338> set, Set<class_2338> set2) {
        ArrayList list = Lists.newArrayList();
        class_244 discreteVoxelShape = new class_244(boundingBox.method_35414(), boundingBox.method_14660(), boundingBox.method_14663());
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (class_2338 blockPos : Lists.newArrayList(set2)) {
            if (!boundingBox.method_14662((class_2382)blockPos)) continue;
            discreteVoxelShape.method_1049(blockPos.method_10263() - boundingBox.method_35415(), blockPos.method_10264() - boundingBox.method_35416(), blockPos.method_10260() - boundingBox.method_35417());
        }
        for (class_2338 blockPos : Lists.newArrayList(set)) {
            if (boundingBox.method_14662((class_2382)blockPos)) {
                discreteVoxelShape.method_1049(blockPos.method_10263() - boundingBox.method_35415(), blockPos.method_10264() - boundingBox.method_35416(), blockPos.method_10260() - boundingBox.method_35417());
            }
            for (class_2350 direction : class_2350.values()) {
                class_2680 blockState;
                mutableBlockPos.method_25505((class_2382)blockPos, direction);
                if (set.contains(mutableBlockPos) || !(blockState = levelAccessor.method_8320((class_2338)mutableBlockPos)).method_28498((class_2769)class_2741.field_12541)) continue;
                ((Set)list.get(0)).add(mutableBlockPos.method_10062());
                WaterTreeFeature.setBlockKnownShape((class_1945)levelAccessor, (class_2338)mutableBlockPos, (class_2680)blockState.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(1)));
                if (!boundingBox.method_14662((class_2382)mutableBlockPos)) continue;
                discreteVoxelShape.method_1049(mutableBlockPos.method_10263() - boundingBox.method_35415(), mutableBlockPos.method_10264() - boundingBox.method_35416(), mutableBlockPos.method_10260() - boundingBox.method_35417());
            }
        }
        for (int k = 1; k < 6; ++k) {
            Set set3 = (Set)list.get(k - 1);
            Set set4 = (Set)list.get(k);
            for (class_2338 blockPos2 : set3) {
                if (boundingBox.method_14662((class_2382)blockPos2)) {
                    discreteVoxelShape.method_1049(blockPos2.method_10263() - boundingBox.method_35415(), blockPos2.method_10264() - boundingBox.method_35416(), blockPos2.method_10260() - boundingBox.method_35417());
                }
                for (class_2350 direction2 : class_2350.values()) {
                    int l;
                    class_2680 blockState2;
                    mutableBlockPos.method_25505((class_2382)blockPos2, direction2);
                    if (set3.contains(mutableBlockPos) || set4.contains(mutableBlockPos) || !(blockState2 = levelAccessor.method_8320((class_2338)mutableBlockPos)).method_28498((class_2769)class_2741.field_12541) || (l = ((Integer)blockState2.method_11654((class_2769)class_2741.field_12541)).intValue()) <= k + 1) continue;
                    class_2680 blockState3 = (class_2680)blockState2.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(k + 1));
                    WaterTreeFeature.setBlockKnownShape((class_1945)levelAccessor, (class_2338)mutableBlockPos, blockState3);
                    if (boundingBox.method_14662((class_2382)mutableBlockPos)) {
                        discreteVoxelShape.method_1049(mutableBlockPos.method_10263() - boundingBox.method_35415(), mutableBlockPos.method_10264() - boundingBox.method_35416(), mutableBlockPos.method_10260() - boundingBox.method_35417());
                    }
                    set4.add(mutableBlockPos.method_10062());
                }
            }
        }
        return discreteVoxelShape;
    }
}

