/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1640;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3037;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3470;
import net.minecraft.class_3481;
import net.minecraft.class_3485;
import net.minecraft.class_3486;
import net.minecraft.class_3488;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3494;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3730;
import net.minecraft.class_3793;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5847;
import net.minecraft.class_6130;
import net.minecraft.class_6622;
import net.minecraft.class_6625;
import net.minecraft.class_6626;
import net.minecraft.class_6834;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.init.BMWorldGen;
import party.lemons.biomemakeover.util.RandomUtil;

public class SunkenRuinFeature
extends class_3195<SunkenRuinFeatureConfig> {
    private static final class_2960[] LARGE_PIECES = new class_2960[]{BiomeMakeover.ID("sunken_ruins/sunken_1"), BiomeMakeover.ID("sunken_ruins/sunken_2"), BiomeMakeover.ID("sunken_ruins/sunken_3")};
    private static final class_2960[] SMALL_PIECES = new class_2960[]{BiomeMakeover.ID("sunken_ruins/sunken_small_1"), BiomeMakeover.ID("sunken_ruins/sunken_small_2"), BiomeMakeover.ID("sunken_ruins/sunken_small_3"), BiomeMakeover.ID("sunken_ruins/sunken_small_4"), BiomeMakeover.ID("sunken_ruins/sunken_small_5"), BiomeMakeover.ID("sunken_ruins/sunken_small_6")};
    private static final class_2960 LOOT = BiomeMakeover.ID("sunken_ruin");

    public SunkenRuinFeature(Codec<SunkenRuinFeatureConfig> codec) {
        super(codec, class_6834.simple((Predicate)class_6834.checkForBiomeOnTop((class_2902.class_2903)class_2902.class_2903.field_13194), SunkenRuinFeature::generatePieces));
    }

    public class_2893.class_2895 method_28663() {
        return class_2893.class_2895.field_13171;
    }

    private static <C extends class_3037> void generatePieces(class_6626 builder, class_6622.class_6623<SunkenRuinFeatureConfig> ctx) {
        class_2338 blockPos = new class_2338(ctx.comp_127().method_8326(), 90, ctx.comp_127().method_8328());
        class_2470 rotation = class_2470.method_16548((Random)ctx.comp_130());
        SunkenRuinFeature.addPieces(ctx.comp_126(), blockPos, rotation, (class_6130)builder, (Random)ctx.comp_130(), (SunkenRuinFeatureConfig)ctx.comp_305());
    }

    public static void addPieces(class_3485 manager, class_2338 blockPos, class_2470 rotation, class_6130 pieceAccessor, Random random, SunkenRuinFeatureConfig cfg) {
        boolean isLarge = random.nextFloat() <= cfg.largeProbability;
        float f = isLarge ? 0.9f : 0.8f;
        SunkenRuinFeature.addPiece(manager, blockPos, rotation, pieceAccessor, random, cfg, isLarge, f);
        if (isLarge && random.nextFloat() <= cfg.clusterProbability) {
            SunkenRuinFeature.addClusterRuins(manager, random, rotation, blockPos, cfg, pieceAccessor);
        }
    }

    private static void addPiece(class_3485 structureManager, class_2338 blockPos, class_2470 rotation, class_6130 structurePieceAccessor, Random random, SunkenRuinFeatureConfig oceanRuinConfiguration, boolean bl, float f) {
        class_2960 resourceLocation = bl ? LARGE_PIECES[random.nextInt(LARGE_PIECES.length)] : SMALL_PIECES[random.nextInt(SMALL_PIECES.length)];
        structurePieceAccessor.method_35462((class_3443)new SunkenRuinPiece(structureManager, resourceLocation, blockPos, rotation, 1.0f, bl));
    }

    private static void addClusterRuins(class_3485 structureManager, Random random, class_2470 rotation, class_2338 blockPos, SunkenRuinFeatureConfig oceanRuinConfiguration, class_6130 structurePieceAccessor) {
        class_2338 blockPos2 = new class_2338(blockPos.method_10263(), 90, blockPos.method_10260());
        class_2338 blockPos3 = class_3499.method_15168((class_2338)new class_2338(15, 0, 15), (class_2415)class_2415.field_11302, (class_2470)rotation, (class_2338)class_2338.field_10980).method_10081((class_2382)blockPos2);
        class_3341 boundingBox = class_3341.method_34390((class_2382)blockPos2, (class_2382)blockPos3);
        class_2338 blockPos4 = new class_2338(Math.min(blockPos2.method_10263(), blockPos3.method_10263()), blockPos2.method_10264(), Math.min(blockPos2.method_10260(), blockPos3.method_10260()));
        List<class_2338> list = SunkenRuinFeature.allPositions(random, blockPos4);
        int i = class_3532.method_15395((Random)random, (int)4, (int)8);
        for (int j = 0; j < i; ++j) {
            class_2470 rotation2;
            class_2338 blockPos6;
            int k;
            class_2338 blockPos5;
            class_3341 boundingBox2;
            if (list.isEmpty() || (boundingBox2 = class_3341.method_34390((class_2382)(blockPos5 = list.remove(k = random.nextInt(list.size()))), (class_2382)(blockPos6 = class_3499.method_15168((class_2338)new class_2338(5, 0, 6), (class_2415)class_2415.field_11302, (class_2470)(rotation2 = class_2470.method_16548((Random)random)), (class_2338)class_2338.field_10980).method_10081((class_2382)blockPos5)))).method_14657(boundingBox)) continue;
            SunkenRuinFeature.addPiece(structureManager, blockPos5, rotation2, structurePieceAccessor, random, oceanRuinConfiguration, false, 1.0f);
        }
    }

    private static List<class_2338> allPositions(Random random, class_2338 blockPos) {
        ArrayList list = Lists.newArrayList();
        list.add(blockPos.method_10069(-16 + class_3532.method_15395((Random)random, (int)1, (int)8), 0, 16 + class_3532.method_15395((Random)random, (int)1, (int)7)));
        list.add(blockPos.method_10069(-16 + class_3532.method_15395((Random)random, (int)1, (int)8), 0, class_3532.method_15395((Random)random, (int)1, (int)7)));
        list.add(blockPos.method_10069(-16 + class_3532.method_15395((Random)random, (int)1, (int)8), 0, -16 + class_3532.method_15395((Random)random, (int)4, (int)8)));
        list.add(blockPos.method_10069(class_3532.method_15395((Random)random, (int)1, (int)7), 0, 16 + class_3532.method_15395((Random)random, (int)1, (int)7)));
        list.add(blockPos.method_10069(class_3532.method_15395((Random)random, (int)1, (int)7), 0, -16 + class_3532.method_15395((Random)random, (int)4, (int)6)));
        list.add(blockPos.method_10069(16 + class_3532.method_15395((Random)random, (int)1, (int)7), 0, 16 + class_3532.method_15395((Random)random, (int)3, (int)8)));
        list.add(blockPos.method_10069(16 + class_3532.method_15395((Random)random, (int)1, (int)7), 0, class_3532.method_15395((Random)random, (int)1, (int)7)));
        list.add(blockPos.method_10069(16 + class_3532.method_15395((Random)random, (int)1, (int)7), 0, -16 + class_3532.method_15395((Random)random, (int)4, (int)8)));
        return list;
    }

    public static class SunkenRuinFeatureConfig
    implements class_3037 {
        public static final Codec<SunkenRuinFeatureConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("large_probability").forGetter(cfg -> Float.valueOf(cfg.largeProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("cluster_probability").forGetter(cfg -> Float.valueOf(cfg.clusterProbability))).apply((Applicative)instance, SunkenRuinFeatureConfig::new));
        public final float largeProbability;
        public final float clusterProbability;

        public SunkenRuinFeatureConfig(float largeProbability, float clusterProbability) {
            this.largeProbability = largeProbability;
            this.clusterProbability = clusterProbability;
        }
    }

    public static class SunkenRuinPiece
    extends class_3470 {
        private final float integrity;
        private final boolean isLarge;

        public SunkenRuinPiece(class_3485 structureManager, class_2960 resourceLocation, class_2338 blockPos, class_2470 rotation, float f, boolean bl) {
            super(BMWorldGen.Swamp.SUNKEN_RUIN_PIECE, 0, structureManager, resourceLocation, resourceLocation.toString(), SunkenRuinPiece.makeSettings(rotation), blockPos);
            this.integrity = f;
            this.isLarge = bl;
        }

        public SunkenRuinPiece(class_3485 structureManager, class_2487 compoundTag) {
            super(BMWorldGen.Swamp.SUNKEN_RUIN_PIECE, compoundTag, structureManager, resourceLocation -> SunkenRuinPiece.makeSettings(class_2470.valueOf((String)compoundTag.method_10558("Rot"))));
            this.integrity = compoundTag.method_10583("Integrity");
            this.isLarge = compoundTag.method_10577("IsLarge");
        }

        public SunkenRuinPiece(class_6625 structurePieceSerializationContext, class_2487 compoundTag) {
            super(BMWorldGen.Swamp.SUNKEN_RUIN_PIECE, compoundTag, structurePieceSerializationContext.comp_135(), resourceLocation -> SunkenRuinPiece.makeSettings(class_2470.valueOf((String)compoundTag.method_10558("Rot"))));
            this.integrity = compoundTag.method_10583("Integrity");
            this.isLarge = compoundTag.method_10577("IsLarge");
        }

        private static class_3492 makeSettings(class_2470 rotation) {
            return new class_3492().method_15123(rotation).method_15125(class_2415.field_11302).method_16184((class_3491)class_3793.field_16721);
        }

        public class_5847 method_33882() {
            return class_5847.field_28923;
        }

        protected void method_14943(class_6625 structurePieceSerializationContext, class_2487 compoundTag) {
            super.method_14943(structurePieceSerializationContext, compoundTag);
            compoundTag.method_10582("Rot", this.field_15434.method_15113().name());
            compoundTag.method_10548("Integrity", this.integrity);
            compoundTag.method_10556("IsLarge", this.isLarge);
        }

        protected void method_15026(String metadata, class_2338 pos, class_5425 level, Random random, class_3341 boundingBox) {
            if ("chest".equals(metadata)) {
                level.method_8652(pos, (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10772, (Comparable)Boolean.valueOf(level.method_8316(pos).method_15767((class_3494)class_3486.field_15517))), 2);
                class_2586 blockEntity = level.method_8321(pos);
                if (blockEntity instanceof class_2595) {
                    ((class_2595)blockEntity).method_11285(LOOT, random.nextLong());
                }
            } else if ("witch".equals(metadata) && random.nextBoolean() && level.method_8320(pos.method_10084()).method_26215()) {
                class_1640 witch = (class_1640)class_1299.field_6145.method_5883((class_1937)level.method_8410());
                witch.method_5971();
                witch.method_5725(pos, 0.0f, 0.0f);
                witch.method_5943(level, level.method_8404(pos), class_3730.field_16474, null, null);
                level.method_30771((class_1297)witch);
                if (pos.method_10264() >= level.method_8615()) {
                    level.method_8652(pos, class_2246.field_10124.method_9564(), 2);
                } else {
                    level.method_8652(pos, class_2246.field_10382.method_9564(), 2);
                }
            }
        }

        public void method_14931(class_5281 worldGenLevel, class_5138 structureFeatureManager, class_2794 chunkGenerator, Random random, class_3341 boundingBox, class_1923 chunkPos, class_2338 blockPos) {
            this.field_15434.method_16183().method_16184((class_3491)new class_3488(this.integrity)).method_16184((class_3491)class_3793.field_16721);
            int i = worldGenLevel.method_8624(class_2902.class_2903.field_13195, this.field_15432.method_10263(), this.field_15432.method_10260()) - RandomUtil.randomRange(1, 4);
            this.field_15432 = new class_2338(this.field_15432.method_10263(), i, this.field_15432.method_10260());
            class_2338 blockPos2 = class_3499.method_15168((class_2338)new class_2338(this.field_15433.method_15160().method_10263() - 1, 0, this.field_15433.method_15160().method_10260() - 1), (class_2415)class_2415.field_11302, (class_2470)this.field_15434.method_15113(), (class_2338)class_2338.field_10980).method_10081((class_2382)this.field_15432);
            this.field_15432 = new class_2338(this.field_15432.method_10263(), this.getHeight(this.field_15432, (class_1922)worldGenLevel, blockPos2), this.field_15432.method_10260());
            super.method_14931(worldGenLevel, structureFeatureManager, chunkGenerator, random, boundingBox, chunkPos, blockPos);
        }

        private int getHeight(class_2338 blockPos, class_1922 blockGetter, class_2338 blockPos2) {
            int i = blockPos.method_10264();
            int j = 512;
            int k = i - 1;
            int l = 0;
            for (class_2338 blockPos3 : class_2338.method_10097((class_2338)blockPos, (class_2338)blockPos2)) {
                int m = blockPos3.method_10263();
                int n = blockPos3.method_10260();
                int o = blockPos.method_10264() - 1;
                class_2338.class_2339 mutableBlockPos = new class_2338.class_2339(m, o, n);
                class_2680 blockState = blockGetter.method_8320((class_2338)mutableBlockPos);
                class_3610 fluidState = blockGetter.method_8316((class_2338)mutableBlockPos);
                while ((blockState.method_26215() || fluidState.method_15767((class_3494)class_3486.field_15517) || blockState.method_26164((class_3494)class_3481.field_15467)) && o > blockGetter.method_31607() + 1) {
                    mutableBlockPos.method_10103(m, --o, n);
                    blockState = blockGetter.method_8320((class_2338)mutableBlockPos);
                    fluidState = blockGetter.method_8316((class_2338)mutableBlockPos);
                }
                j = Math.min(j, o);
                if (o >= k - 2) continue;
                ++l;
            }
            int p = Math.abs(blockPos.method_10263() - blockPos2.method_10263());
            if (k - j > 2 && l > p - 2) {
                i = j + 1;
            }
            return i;
        }
    }
}

