/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import party.lemons.biomemakeover.entity.TumbleweedEntity;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.util.RandomUtil;

public class TumbleweedSpawner {
    public static void update(class_3218 level) {
        ArrayList groups = Lists.newArrayList();
        for (class_3222 pl : level.method_18766(p -> true)) {
            if (pl.method_7325()) continue;
            boolean added = false;
            for (TumbleweedPlayerGroup group : groups) {
                if (!group.addPlayer(pl)) continue;
                added = true;
                break;
            }
            if (added) continue;
            groups.add(new TumbleweedPlayerGroup(pl));
        }
        for (TumbleweedPlayerGroup group : groups) {
            class_2338 pos;
            if (level.field_9229.nextInt(200) != 0 || (pos = group.getSpawnPos()) == null || !level.method_22340(pos) || !level.method_22347(pos) || level.method_23753(pos).method_8688() != class_1959.class_1961.field_9354) continue;
            TumbleweedEntity tumble = (TumbleweedEntity)BMEntities.TUMBLEWEED.method_5883((class_1937)level);
            tumble.method_5808((float)pos.method_10263() + 0.5f, (float)pos.method_10264() + 0.5f, (float)pos.method_10260() + 0.5f, 0.0f, 0.0f);
            level.method_8649((class_1297)tumble);
        }
    }

    private static class TumbleweedPlayerGroup {
        private static final int MAX_DISTANCE = 50;
        private final class_3222 main;
        private final List<class_3222> nearPlayers;

        private TumbleweedPlayerGroup(class_3222 main) {
            this.main = main;
            this.nearPlayers = Lists.newArrayList((Object[])new class_3222[]{main});
        }

        public boolean addPlayer(class_3222 playerEntity) {
            if (playerEntity.method_5739((class_1297)this.main) <= 50.0f) {
                this.nearPlayers.add(playerEntity);
                return true;
            }
            return false;
        }

        public class_2338 getSpawnPos() {
            int minX = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            for (class_3222 p : this.nearPlayers) {
                if (p.method_23317() + 20.0 + 45.0 > (double)maxX) {
                    maxX = (int)p.method_23317() + 20 + 45;
                }
                if (p.method_23321() + 20.0 + 45.0 > (double)maxZ) {
                    maxZ = (int)p.method_23321() + 20 + 45;
                }
                if (p.method_23317() - 20.0 - 45.0 < (double)minX) {
                    minX = (int)p.method_23317() - 20 - 45;
                }
                if (!(p.method_23321() - 20.0 - 45.0 < (double)minZ)) continue;
                minZ = (int)p.method_23321() - 20 - 45;
            }
            int spawnX = RandomUtil.randomRange(minX, maxX);
            int spawnZ = RandomUtil.randomRange(minZ, maxZ);
            int spawnY = this.main.field_6002.method_8624(class_2902.class_2903.field_13202, spawnX, spawnZ);
            int attempts = 20;
            while (!this.isOutOfRange(spawnX, spawnY, spawnZ) && attempts-- > 0) {
                spawnX = RandomUtil.randomRange(minX, maxX);
                spawnZ = RandomUtil.randomRange(minZ, maxZ);
                spawnY = this.main.field_6002.method_8624(class_2902.class_2903.field_13202, spawnX, spawnZ);
            }
            if (attempts <= 0) {
                return null;
            }
            return new class_2338(spawnX, spawnY, spawnZ);
        }

        private boolean isOutOfRange(double x, double y, double z) {
            for (class_3222 pl : this.nearPlayers) {
                if (!(pl.method_5649(x, y, z) < 20.0)) continue;
                return false;
            }
            return true;
        }
    }
}

