/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2401;
import net.minecraft.class_2533;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3614;
import net.minecraft.class_3709;
import net.minecraft.class_4538;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.network.S2C_DoPoltergeistParticle;

public class PoltergeistHandler {
    private static final Map<class_3494<class_2248>, PoltergeistBehaviour> BEHAVIOUR_TAG = Maps.newHashMap();
    private static final Map<class_2248, PoltergeistBehaviour> BEHAVIOUR_BLOCK = Maps.newHashMap();

    public static void doPoltergeist(class_1937 level, class_2338 pos, int range) {
        int volume = range * range * range;
        int geistIndex = level.field_9229.nextInt(volume);
        int half = range / 2;
        int pZ = geistIndex % range;
        int pY = geistIndex / range % range;
        int pX = geistIndex / (range * range);
        class_2338 checkPos = new class_2338((pX += pos.method_10263()) - half, (pY += pos.method_10264()) - half, (pZ += pos.method_10260()) - half);
        if (PoltergeistHandler.doBehaviour(level, checkPos)) {
            Random random = level.field_9229;
            PoltergeistHandler.doParticles(level, checkPos);
            float pitch = random.nextFloat() * 0.4f + random.nextFloat() > 0.9f ? 0.6f : 0.0f;
            level.method_8396(null, pos, BMEffects.POLTERGEIST_ACTION, class_3419.field_15245, pitch, 0.6f + random.nextFloat() * 0.4f);
        }
    }

    public static void doParticles(class_1937 world, class_2338 pos) {
        new S2C_DoPoltergeistParticle(pos).sendToChunkListeners(world.method_8500(pos));
    }

    public static boolean doBehaviour(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        class_2248 bl = state.method_26204();
        if (state.method_26215() || state.method_27852(class_2246.field_10340)) {
            return false;
        }
        if (BEHAVIOUR_BLOCK.containsKey(bl)) {
            return BEHAVIOUR_BLOCK.get(bl).handle(level, pos, state);
        }
        for (class_3494<class_2248> tag : BEHAVIOUR_TAG.keySet()) {
            if (!tag.method_15141((Object)bl)) continue;
            return BEHAVIOUR_TAG.get(tag).handle(level, pos, state);
        }
        return false;
    }

    public static void registerBehaviour(class_3494<class_2248> blockTag, PoltergeistBehaviour behaviour) {
        BEHAVIOUR_TAG.put(blockTag, behaviour);
    }

    public static void registerBehaviour(class_2248 block, PoltergeistBehaviour behaviour) {
        BEHAVIOUR_BLOCK.put(block, behaviour);
    }

    public static void init() {
    }

    static {
        PoltergeistHandler.registerBehaviour((class_3494<class_2248>)class_3481.field_15495, (class_1937 w, class_2338 p, class_2680 st) -> {
            if (st.method_11654((class_2769)class_2323.field_10946) != class_2756.field_12607 || st.method_26207() == class_3614.field_15953) {
                return false;
            }
            w.method_8652(p, (class_2680)st.method_28493((class_2769)class_2323.field_10945), 10);
            int sound = (Boolean)st.method_11654((class_2769)class_2323.field_10945) != false ? 1012 : 1006;
            w.method_8444(null, sound, p, 0);
            return true;
        });
        PoltergeistHandler.registerBehaviour((class_3494<class_2248>)class_3481.field_15493, (class_1937 w, class_2338 p, class_2680 st) -> {
            if (((Boolean)st.method_11654((class_2769)class_2269.field_10729)).booleanValue()) {
                return false;
            }
            ((class_2269)st.method_26204()).method_21845(st, w, p);
            w.method_8396(null, p, class_3417.field_14699, class_3419.field_15245, 0.3f, 0.6f);
            return true;
        });
        PoltergeistHandler.registerBehaviour((class_3494<class_2248>)class_3481.field_15487, (class_1937 w, class_2338 p, class_2680 st) -> {
            if (st.method_26207() == class_3614.field_15953) {
                return false;
            }
            class_2680 newState = (class_2680)st.method_28493((class_2769)class_2533.field_11631);
            w.method_8652(p, newState, 2);
            if (((Boolean)newState.method_11654((class_2769)class_2533.field_11626)).booleanValue()) {
                w.method_39281(p, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)w));
            }
            w.method_8444(null, (Boolean)st.method_11654((class_2769)class_2533.field_11631) != false ? 1007 : 1013, p, 0);
            return true;
        });
        PoltergeistHandler.registerBehaviour(class_2246.field_10363, (class_1937 w, class_2338 p, class_2680 st) -> {
            ((class_2401)st.method_26204()).method_21846(st, w, p);
            float pitch = (Boolean)st.method_11654((class_2769)class_2401.field_11265) != false ? 0.6f : 0.5f;
            w.method_8396(null, p, class_3417.field_14962, class_3419.field_15245, 0.3f, pitch);
            return true;
        });
        PoltergeistHandler.registerBehaviour(class_2246.field_10179, (class_1937 w, class_2338 p, class_2680 st) -> {
            if (w.method_8320(p.method_10084()).method_26215()) {
                w.method_8427(p, st.method_26204(), 0, 0);
                return true;
            }
            return false;
        });
        PoltergeistHandler.registerBehaviour((class_3494<class_2248>)class_3481.field_25147, (class_1937 w, class_2338 p, class_2680 st) -> {
            st = (class_2680)st.method_28493((class_2769)class_2349.field_11026);
            w.method_8652(p, st, 10);
            w.method_8444(null, (Boolean)st.method_11654((class_2769)class_2349.field_11026) != false ? 1008 : 1014, p, 0);
            return true;
        });
        PoltergeistHandler.registerBehaviour(class_2246.field_16332, (class_1937 w, class_2338 p, class_2680 st) -> {
            ((class_3709)st.method_26204()).method_33600(w, p, null);
            return true;
        });
    }

    public static interface PoltergeistBehaviour {
        public boolean handle(class_1937 var1, class_2338 var2, class_2680 var3);
    }
}

