/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_5134;

public class BMArmorItem
extends class_1738 {
    private final Multimap<class_1320, class_1322> attributes;
    private final int protection;
    private final float toughness;

    public BMArmorItem(class_1741 material, Multimap<class_1320, class_1322> attributes, int protection, float toughness, class_1304 slot, class_1792.class_1793 properties) {
        super(material, slot, properties);
        this.attributes = attributes;
        this.protection = protection;
        this.toughness = toughness;
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 equipmentSlot) {
        return equipmentSlot == this.field_7880 ? this.attributes : ImmutableMultimap.of();
    }

    public float method_26353() {
        return this.toughness;
    }

    public int method_7687() {
        return this.protection;
    }

    public static class Builder {
        private static final UUID DUMMY_UUID = UUID.randomUUID();
        private static final UUID[] MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
        private final LinkedListMultimap<class_1320, class_1322> attributes = LinkedListMultimap.create();
        private final class_1741 material;
        private int protection;
        private boolean overrideProtection = false;
        private float toughness;
        private float knockbackResistance;

        public static Builder create(class_1741 material) {
            return new Builder(material);
        }

        public Builder protection(int amount) {
            this.protection = amount;
            this.overrideProtection = true;
            return this;
        }

        public Builder toughness(float amount) {
            this.toughness = amount;
            return this;
        }

        public Builder knockbackResistance(float amount) {
            this.knockbackResistance = amount;
            return this;
        }

        public Builder attribute(String name, class_1320 attribute, double value, class_1322.class_1323 operation) {
            this.attributes.put((Object)attribute, (Object)new class_1322(DUMMY_UUID, name, value, operation));
            return this;
        }

        public BMArmorItem build(class_1304 slot, class_1792.class_1793 properties) {
            if (!this.overrideProtection) {
                this.protection = this.material.method_7697(slot);
            }
            this.attributes.removeAll((Object)class_5134.field_23724);
            this.attributes.removeAll((Object)class_5134.field_23725);
            this.attributes.removeAll((Object)class_5134.field_23718);
            this.attributes.put((Object)class_5134.field_23724, (Object)new class_1322(DUMMY_UUID, "Armor modifier", (double)this.protection, class_1322.class_1323.field_6328));
            this.attributes.put((Object)class_5134.field_23725, (Object)new class_1322(DUMMY_UUID, "Armor toughness", (double)this.toughness, class_1322.class_1323.field_6328));
            if (this.knockbackResistance != 0.0f) {
                this.attributes.put((Object)class_5134.field_23718, (Object)new class_1322(DUMMY_UUID, "Armor knockback resistance", (double)this.knockbackResistance, class_1322.class_1323.field_6328));
            }
            return new BMArmorItem(this.material, (Multimap<class_1320, class_1322>)this.buildAttributes(slot), this.protection, this.toughness, slot, properties);
        }

        private LinkedListMultimap<class_1320, class_1322> buildAttributes(class_1304 slot) {
            LinkedListMultimap atts = LinkedListMultimap.create();
            for (class_1320 attribute : this.attributes.keys()) {
                for (class_1322 modifier : this.attributes.get((Object)attribute)) {
                    atts.put((Object)attribute, (Object)new class_1322(MODIFIERS[slot.method_5927()], modifier.method_6185(), modifier.method_6186(), modifier.method_6182()));
                }
            }
            return atts;
        }

        private Builder(class_1741 material) {
            this.material = material;
            this.toughness = material.method_7700();
            this.knockbackResistance = material.method_24355();
        }
    }
}

