/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.fabric;

import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModification;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.loot.v1.event.LootTableLoadingCallback;
import net.minecraft.class_117;
import net.minecraft.class_141;
import net.minecraft.class_1935;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_221;
import net.minecraft.class_2893;
import net.minecraft.class_2922;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_6796;
import net.minecraft.class_6819;
import net.minecraft.class_77;
import net.minecraft.class_79;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.BiomeMakeoverClient;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.init.BMWorldGen;
import party.lemons.biomemakeover.util.loot.BMLootTableInjection;

public class BMFabric
implements ModInitializer {
    public void onInitialize() {
        BiomeMakeover.init();
        if (Platform.getEnvironment() == Env.CLIENT) {
            BiomeMakeoverClient.init();
        }
        BMEntities.registerModels();
        BMEffects.registerParticleProvider();
        this.doWorldGen();
        this.injectLootTables();
    }

    private void injectLootTables() {
        LootTableLoadingCallback.EVENT.register((resourceManager, manager, id, supplier, setter) -> {
            for (BMLootTableInjection.InjectedItem item : BMLootTableInjection.getInsertedEntries()) {
                if (!id.equals((Object)item.table())) continue;
                supplier.withPool(class_55.method_347().method_352((class_5658)item.rolls()).method_351((class_79.class_80)class_77.method_411((class_1935)item.itemLike()).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)0.0f, (float)2.0f)))).method_356(class_221.method_939()).method_355());
            }
        });
    }

    public void doWorldGen() {
        Predicate MUSHROOM_BIOMES = BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9365});
        Predicate BADLANDS_BIOMES = BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9354});
        Predicate SWAMP_BIOMES = BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9364});
        Predicate DF_BIOMES = BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9475});
        BiomeModification gen = BiomeModifications.create((class_2960)BiomeMakeover.ID("biomemakeover"));
        this.addBiomeFeatures(gen, BADLANDS_BIOMES, BMWorldGen.BADLANDS_GEN);
        this.addBiomeStructures(gen, BADLANDS_BIOMES, BMWorldGen.BADLANDS_STRUCTURES);
        this.addBiomeFeatures(gen, MUSHROOM_BIOMES, BMWorldGen.MUSHROOM_GEN);
        this.addBiomeCarvers(gen, MUSHROOM_BIOMES, BMWorldGen.MUSHROOM_CARVERS);
        this.addBiomeFeatures(gen, SWAMP_BIOMES, BMWorldGen.SWAMP_GEN);
        this.addBiomeStructures(gen, SWAMP_BIOMES, BMWorldGen.SWAMP_STRUCTURES);
        this.addBiomeFeatures(gen, DF_BIOMES, BMWorldGen.DF_GEN);
        this.addBiomeStructures(gen, DF_BIOMES, BMWorldGen.DF_STRUCTURES);
        gen.add(ModificationPhase.REMOVALS, SWAMP_BIOMES, (biomeSelectionContext, ctx) -> ctx.getGenerationSettings().removeBuiltInFeature(class_6819.field_36146));
    }

    private void addBiomeCarvers(BiomeModification gen, Predicate<BiomeSelectionContext> biomes, List<class_2922> carvers) {
        for (class_2922 carer : carvers) {
            gen.add(ModificationPhase.ADDITIONS, biomes, ctx -> {
                Optional k = class_5458.field_25928.method_29113((Object)carer);
                ctx.getGenerationSettings().addCarver(class_2893.class_2894.field_13169, (class_5321)k.get());
            });
        }
    }

    private void addBiomeStructures(BiomeModification gen, Predicate<BiomeSelectionContext> biomes, List<class_5312<?, ?>> structures) {
        for (class_5312<?, ?> structureFeature : structures) {
            gen.add(ModificationPhase.ADDITIONS, biomes, ctx -> {
                Optional k = class_5458.field_25930.method_29113((Object)structureFeature);
                ctx.getGenerationSettings().addStructure((class_5321)k.get());
            });
        }
    }

    private void addBiomeFeatures(BiomeModification gen, Predicate<BiomeSelectionContext> biomes, Map<class_2893.class_2895, List<class_6796>> features) {
        for (class_2893.class_2895 step : features.keySet()) {
            for (class_6796 feature : features.get(step)) {
                gen.add(ModificationPhase.ADDITIONS, biomes, ctx -> ctx.getGenerationSettings().addBuiltInFeature(step, feature));
            }
        }
    }

    public static class_5321<class_2922<?>> rk(class_2922 carver) {
        return (class_5321)class_5458.field_25928.method_29113((Object)carver).get();
    }

    public static class_5321<class_2975<?, ?>> rk(class_2975 carver) {
        return (class_5321)class_5458.field_25929.method_29113((Object)carver).get();
    }

    public static class_5321<class_5312<?, ?>> rk(class_5312 carver) {
        return (class_5321)class_5458.field_25930.method_29113((Object)carver).get();
    }
}

