/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.render;

import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_922;
import net.minecraft.class_927;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.entity.LightningBugEntity;
import party.lemons.biomemakeover.entity.render.LightningBugModel;
import party.lemons.biomemakeover.util.MathUtils;

public class LightningBugRender
extends class_927<LightningBugEntity, LightningBugModel> {
    public static final class_2960 TEXTURE = BiomeMakeover.ID("textures/entity/lightning_bug.png");

    public LightningBugRender(class_5617.class_5618 context) {
        super(context, (class_583)new LightningBugModel(context.method_32167(LightningBugModel.LAYER_LOCATION)), 0.25f);
        this.method_4046(new LightningBugRenderLayer(this, new LightningBugModel.LightningBugInner(context.method_32167(LightningBugModel.LAYER_LOCATION_INNER)), true));
        this.method_4046(new LightningBugRenderLayer(this, new LightningBugModel.LightningBugOuter(context.method_32167(LightningBugModel.LAYER_LOCATION_OUTER)), false));
    }

    @Nullable
    protected class_1921 getRenderType(LightningBugEntity livingEntity, boolean bl, boolean bl2, boolean bl3) {
        return null;
    }

    protected void scale(LightningBugEntity entity, class_4587 poseStack, float amount) {
        super.method_4042((class_1309)entity, poseStack, amount);
        entity.scale += amount / 10.0f;
        if (entity.scale > 99999.0f) {
            entity.scale = 0.0f;
        }
        float sc = 0.9f + (float)Math.sin(entity.scale) / 5.0f;
        this.field_4673 = sc / 10.0f;
        poseStack.method_22905(sc, sc, sc);
    }

    protected int getBlockLightLevel(LightningBugEntity entity, class_2338 blockPos) {
        return 15;
    }

    public class_2960 getTextureLocation(LightningBugEntity entity) {
        return TEXTURE;
    }

    private static class LightningBugRenderLayer
    extends class_3887<LightningBugEntity, LightningBugModel> {
        private final class_583<LightningBugEntity> model;
        private final boolean color;

        public LightningBugRenderLayer(LightningBugRender lightningBugRender, class_583<LightningBugEntity> model, boolean color) {
            super((class_3883)lightningBugRender);
            this.model = model;
            this.color = color;
        }

        public void render(class_4587 poseStack, class_4597 multiBufferSource, int i, LightningBugEntity entity, float f, float g, float delta, float j, float k, float l) {
            if (!entity.method_5767()) {
                class_1160 color = this.color ? this.getColor(entity, delta) : new class_1160(1.0f, 1.0f, 1.0f);
                class_4588 vertexConsumer = multiBufferSource.getBuffer(class_1921.method_23580((class_2960)this.method_23194((class_1297)entity)));
                this.model.method_2828(poseStack, vertexConsumer, i, class_922.method_23622((class_1309)entity, (float)0.0f), color.method_4943(), color.method_4945(), color.method_4947(), 1.0f);
            }
        }

        public class_1160 getColor(LightningBugEntity entity, float delta) {
            class_2338 pos = entity.method_23312();
            int redHash = pos.hashCode();
            int greenHash = (pos.method_10263() + pos.method_10264() * 31) * 31 + pos.method_10260();
            int blueHash = (pos.method_10260() + pos.method_10263() * 31) * 31 + pos.method_10264();
            float drawRed = 1.0f;
            float drawGreen = 1.0f;
            float drawBlue = 1.0f;
            float rTarget = (float)(redHash % 255) / 255.0f;
            float bTarget = (float)(greenHash % 255) / 255.0f;
            float gTarget = (float)(blueHash % 255) / 255.0f;
            if (entity.prevRed == -1.0f) {
                drawRed = rTarget;
                drawGreen = gTarget;
                drawBlue = bTarget;
            } else {
                drawRed = MathUtils.approachValue(entity.prevRed, rTarget, 0.025f * delta);
                drawGreen = MathUtils.approachValue(entity.prevGreen, gTarget, 0.025f * delta);
                drawBlue = MathUtils.approachValue(entity.prevBlue, bTarget, 0.025f * delta);
            }
            entity.prevRed = drawRed;
            entity.prevGreen = drawGreen;
            entity.prevBlue = drawBlue;
            return new class_1160(drawRed, class_3532.method_15379((float)drawGreen), drawBlue);
        }
    }
}

