/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.adjudicator.phase;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorEntity;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorState;
import party.lemons.biomemakeover.entity.adjudicator.phase.AdjudicatorPhase;
import party.lemons.biomemakeover.entity.adjudicator.phase.TimedPhase;
import party.lemons.biomemakeover.entity.event.EntityEvent;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.util.NBTUtil;
import party.lemons.biomemakeover.util.effect.BiomeMakeoverEffect;
import party.lemons.biomemakeover.util.effect.EffectHelper;

public class TeleportingPhase
extends TimedPhase {
    private class_2338 teleportPos;
    private AdjudicatorPhase nextPhase;

    public TeleportingPhase(class_2960 phaseID, AdjudicatorEntity adjudicator) {
        super(phaseID, 30, adjudicator);
        this.teleportPos = adjudicator.method_23312();
    }

    @Override
    protected void initAI() {
    }

    @Override
    public void tick() {
        super.tick();
        this.adjudicator.broadcastEvent((class_1297)this.adjudicator, EntityEvent.ENDER_PARTICLES);
        this.adjudicator.broadcastEvent((class_1297)this.adjudicator, EntityEvent.TELEPORT_PARTICLES);
        EffectHelper.doEffect(this.level, BiomeMakeoverEffect.BLOCK_ENDER_PARTICLES, this.teleportPos);
    }

    @Override
    public void onEnterPhase() {
        super.onEnterPhase();
        this.nextPhase = this.selectNextPhase();
        this.teleportPos = this.nextPhase.getStartPosition();
        this.adjudicator.setState(AdjudicatorState.TELEPORT);
        this.adjudicator.method_5783(BMEffects.ADJUDICATOR_SPELL_3, 1.0f, 1.0f);
    }

    @Override
    public void onExitPhase() {
        super.onExitPhase();
        this.adjudicator.teleportTo(this.teleportPos);
        this.adjudicator.setState(AdjudicatorState.FIGHTING);
    }

    @Override
    public AdjudicatorPhase getNextPhase() {
        return this.nextPhase;
    }

    public AdjudicatorPhase selectNextPhase() {
        AdjudicatorPhase nextPhase;
        List<AdjudicatorPhase> phases = this.adjudicator.PHASES.values().stream().filter(AdjudicatorPhase::isSelectable).toList();
        while ((nextPhase = phases.get(this.level.field_9229.nextInt(phases.size()))) == this) {
        }
        return nextPhase;
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public class_2487 toTag() {
        class_2487 tag = super.toTag();
        NBTUtil.writeBlockPos(this.teleportPos, tag);
        return tag;
    }

    @Override
    public void fromTag(class_2487 tag) {
        super.fromTag(tag);
        this.teleportPos = NBTUtil.readBlockPos(tag);
    }
}

