/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.adjudicator.phase;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1564;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorEntity;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorState;
import party.lemons.biomemakeover.entity.adjudicator.phase.TimedPhase;
import party.lemons.biomemakeover.util.effect.BiomeMakeoverEffect;
import party.lemons.biomemakeover.util.effect.EffectHelper;
import party.lemons.biomemakeover.util.extension.GoalSelectorExtension;
import party.lemons.biomemakeover.util.extension.LootBlocker;

public class SummonPhase
extends TimedPhase {
    private final int mobCount;
    protected final class_1299<? extends class_1309>[] entities;
    protected int toSpawn;
    private class_2338[] spawnPositions;
    int spawnIndex = 0;
    private boolean wasHit;

    public SummonPhase(class_2960 id, AdjudicatorEntity adjudicator, int mobCount, class_1299<? extends class_1309> ... entities) {
        super(id, 120, adjudicator);
        this.mobCount = mobCount;
        this.entities = entities;
    }

    @Override
    protected void initAI() {
    }

    @Override
    public void onEnterPhase() {
        super.onEnterPhase();
        this.toSpawn = this.mobCount;
        this.spawnIndex = 0;
        this.wasHit = false;
        this.adjudicator.setState(AdjudicatorState.SUMMONING);
        this.populateSpawnPositions();
        this.adjudicator.method_5783(class_3417.field_15193, 1.0f, 1.0f);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.time % (this.maxTime / this.mobCount) == 0) {
            this.spawnEntity();
            ++this.spawnIndex;
        }
        for (int i = this.spawnIndex; i < this.mobCount; ++i) {
            EffectHelper.doEffect(this.level, BiomeMakeoverEffect.BLOCK_ENDER_PARTICLES, this.spawnPositions[i]);
        }
    }

    @Override
    public void onHurt(class_1282 source, float amount) {
        super.onHurt(source, amount);
        if (source.method_5529() instanceof class_1657) {
            this.wasHit = true;
        }
    }

    @Override
    public void onExitPhase() {
        super.onExitPhase();
        if (!this.wasHit) {
            for (int i = this.spawnIndex; i < this.mobCount; ++i) {
                this.spawnEntity();
            }
        }
    }

    @Override
    public boolean isPhaseOver() {
        return this.spawnIndex >= this.spawnPositions.length || this.wasHit || super.isPhaseOver();
    }

    protected void spawnEntity() {
        class_1309 entity;
        class_2338 spawnPos = this.spawnPositions[this.spawnIndex];
        if (this.level.method_8320(spawnPos.method_10074()).method_26215()) {
            this.level.method_8652(spawnPos.method_10074(), class_2246.field_10445.method_9564(), 3);
        }
        if ((entity = (class_1309)this.entities[this.random.nextInt(this.entities.length)].method_5883(this.level)) instanceof class_1308) {
            ((class_1308)entity).method_5943((class_5425)this.level, this.level.method_8404(spawnPos), class_3730.field_16467, null, null);
        }
        ((LootBlocker)entity).setLootBlocked(true);
        entity.method_5808((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, 0.0f, 0.0f);
        this.level.method_8649((class_1297)entity);
        this.adjudicator.clearArea((class_1297)entity);
        if (entity instanceof class_1564) {
            GoalSelectorExtension.removeGoal(entity, class_1564.class_1567.class);
        }
        this.level.method_8396(null, spawnPos, class_3417.field_14858, class_3419.field_15251, 10.0f, 1.0f);
    }

    @Override
    public void fromTag(class_2487 tag) {
        this.spawnIndex = tag.method_10550("SpawnIndex");
        this.populateSpawnPositions();
    }

    @Override
    public class_2487 toTag() {
        class_2487 tag = super.toTag();
        tag.method_10569("SpawnIndex", this.spawnIndex);
        return tag;
    }

    private void populateSpawnPositions() {
        this.spawnPositions = new class_2338[this.mobCount];
        for (int i = 0; i < this.mobCount; ++i) {
            this.spawnPositions[i] = this.adjudicator.findSuitableArenaPos();
        }
    }

    @Override
    public boolean isSelectable() {
        return this.level.method_8390(class_1588.class, this.adjudicator.getArenaBounds(), class_1301.field_6157).size() < 4;
    }
}

