/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.adjudicator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1528;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3745;
import net.minecraft.class_4051;
import net.minecraft.class_4135;
import net.minecraft.class_4582;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.entity.PlayerCreatable;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorRoomListener;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorState;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorStateProvider;
import party.lemons.biomemakeover.entity.adjudicator.RavagerChargePhase;
import party.lemons.biomemakeover.entity.adjudicator.phase.AdjudicatorPhase;
import party.lemons.biomemakeover.entity.adjudicator.phase.BowAttackingPhase;
import party.lemons.biomemakeover.entity.adjudicator.phase.FangAttackingPhase;
import party.lemons.biomemakeover.entity.adjudicator.phase.FangBarragePhase;
import party.lemons.biomemakeover.entity.adjudicator.phase.IdleAdjudicatorPhase;
import party.lemons.biomemakeover.entity.adjudicator.phase.MeleeAttackingPhase;
import party.lemons.biomemakeover.entity.adjudicator.phase.MimicPhase;
import party.lemons.biomemakeover.entity.adjudicator.phase.StoneGolemPhase;
import party.lemons.biomemakeover.entity.adjudicator.phase.SummonPhase;
import party.lemons.biomemakeover.entity.adjudicator.phase.TeleportingPhase;
import party.lemons.biomemakeover.entity.event.EntityEventBroadcaster;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.init.BMItems;
import party.lemons.biomemakeover.util.BMUtil;
import party.lemons.biomemakeover.util.NBTUtil;
import party.lemons.biomemakeover.util.extension.GoalSelectorExtension;

public class AdjudicatorEntity
extends class_1588
implements class_4582,
AdjudicatorStateProvider,
class_1603,
class_3745,
EntityEventBroadcaster {
    public static final class_2940<Integer> STATE = class_2945.method_12791(AdjudicatorEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> CHARGING = class_2945.method_12791(AdjudicatorEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> INVULNERABLE = class_2945.method_12791(AdjudicatorEntity.class, (class_2941)class_2943.field_13323);
    public final Map<class_2960, AdjudicatorPhase> PHASES = Maps.newHashMap();
    public final AdjudicatorPhase IDLE = new IdleAdjudicatorPhase(BiomeMakeover.ID("idle"), this);
    public final TeleportingPhase TELEPORT = new TeleportingPhase(BiomeMakeover.ID("teleport"), this);
    public final BowAttackingPhase BOW_ATTACK = new BowAttackingPhase(BiomeMakeover.ID("bow_attack"), this);
    public final MeleeAttackingPhase MELEE_ATTACK = new MeleeAttackingPhase(BiomeMakeover.ID("melee_attack"), this);
    public final FangAttackingPhase FANG_ATTACK = new FangAttackingPhase(BiomeMakeover.ID("fang_attack"), this);
    public final RavagerChargePhase RAVAGER = new RavagerChargePhase(BiomeMakeover.ID("ravager"), this);
    public final SummonPhase SPAWN_EVOKERS = new SummonPhase(BiomeMakeover.ID("spawn_evoker"), this, 2, class_1299.field_6090);
    public final SummonPhase SPAWN_VINDICATORS = new SummonPhase(BiomeMakeover.ID("spawn_vindicator"), this, 6, class_1299.field_6117);
    public final SummonPhase SPAWN_VEX = new SummonPhase(BiomeMakeover.ID("spawn_vex"), this, 2, class_1299.field_6059);
    public final SummonPhase SPAWN_MIX = new SummonPhase(BiomeMakeover.ID("spawn_mix"), this, 3, class_1299.field_6059, class_1299.field_6117, class_1299.field_6090, class_1299.field_6105);
    public final MimicPhase MIMIC = new MimicPhase(BiomeMakeover.ID("mimic"), this);
    public final FangBarragePhase FANG_BARAGE = new FangBarragePhase(BiomeMakeover.ID("fang_barrage"), this);
    public final StoneGolemPhase STONE_GOLEM = new StoneGolemPhase(BiomeMakeover.ID("stone_golem"), this);
    private final class_3213 bossBar;
    private AdjudicatorPhase phase;
    private boolean active = false;
    private class_2338 homePos;
    private boolean firstTick = true;
    private class_238 roomBounds;
    private List<class_2338> arenaPositions;
    public int stateTime = 0;
    private int finishFightTime = 0;
    public float renderRotPrevious = 0.0f;
    private final class_4051 targetPredicate = class_4051.method_36625().method_18418(32.0);

    public AdjudicatorEntity(class_1299<? extends AdjudicatorEntity> entityType, class_1937 level) {
        super(entityType, level);
        this.bossBar = new class_3213(this.method_5476(), class_1259.class_1260.field_5780, class_1259.class_1261.field_5795);
        this.method_6033(this.method_6063());
        this.method_5942().method_6354(true);
        this.field_6194 = 50;
        this.setPhase(this.IDLE);
    }

    protected void method_5959() {
        super.method_5959();
        AdjudicatorRoomListener.enableAdjudicator(this);
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(STATE, (Object)0);
        this.method_5841().method_12784(CHARGING, (Object)false);
        this.method_5841().method_12784(INVULNERABLE, (Object)false);
    }

    public void method_5773() {
        ++this.stateTime;
        if (!this.field_6002.method_8608() && this.firstTick) {
            this.homePos = this.method_23312();
            this.roomBounds = new class_238(this.homePos.method_10087(4)).method_1009(13.0, 0.0, 13.0).method_1012(0.0, 13.0, 0.0);
            this.firstTick = false;
            this.arenaPositions = Lists.newArrayList();
            this.arenaPositions.add(this.homePos);
            class_2338.method_10094((int)((int)this.roomBounds.field_1323), (int)((int)this.roomBounds.field_1322), (int)((int)this.roomBounds.field_1321), (int)((int)this.roomBounds.field_1320), (int)((int)this.roomBounds.field_1325), (int)((int)this.roomBounds.field_1324)).forEach(b -> {
                if (this.field_6002.method_8320(b).method_27852(class_2246.field_9978)) {
                    this.field_6002.method_8652(b, class_2246.field_10124.method_9564(), 3);
                    this.arenaPositions.add(b.method_10062());
                }
            });
        }
        super.method_5773();
        if (!this.field_6002.method_8608() && this.phase != null) {
            this.phase.tick();
            if (this.phase.isPhaseOver()) {
                this.setPhase(this.phase.getNextPhase());
            }
        }
        this.bossBar.method_5408(this.method_6032() / this.method_6063());
        this.tickCastParticles();
        if (!this.field_6002.method_8608() && !this.getArenaBounds().method_1006(this.method_19538())) {
            this.method_5848();
            this.teleportHome();
        }
        this.updatePlayers();
    }

    private void tickCastParticles() {
        if (this.field_6002.field_9236 && this.isCasting()) {
            double b;
            double g;
            double r;
            if (this.getState() == AdjudicatorState.TELEPORT) {
                r = 0.6196078658103943;
                g = 0.23529411852359772;
                b = 0.7607843279838562;
            } else {
                r = 0.5686274766921997;
                g = 0.5686274766921997;
                b = 0.5686274766921997;
            }
            float angle = this.field_6283 * ((float)Math.PI / 180) + class_3532.method_15362((float)((float)this.field_6012 * 0.6662f)) * 0.25f;
            float xOffset = class_3532.method_15362((float)angle);
            float zOffset = class_3532.method_15374((float)angle);
            this.field_6002.method_8406((class_2394)class_2398.field_11226, this.method_23317() + (double)xOffset * 0.6, this.method_23318() + 1.8, this.method_23321() + (double)zOffset * 0.6, r, g, b);
            this.field_6002.method_8406((class_2394)class_2398.field_11226, this.method_23317() - (double)xOffset * 0.6, this.method_23318() + 1.8, this.method_23321() - (double)zOffset * 0.6, r, g, b);
        }
    }

    private void updatePlayers() {
        if (!this.active || this.field_6002.method_8608()) {
            return;
        }
        List players = this.field_6002.method_8390(class_1657.class, this.getArenaBounds(), class_1301.field_6155);
        if (players.isEmpty()) {
            ++this.finishFightTime;
            if (this.finishFightTime > 350) {
                this.teleportHome();
                this.finishFightTime = 0;
                this.setState(AdjudicatorState.WAITING);
                this.setPhase(this.IDLE);
                this.active = false;
            }
        } else {
            this.finishFightTime = 0;
        }
        List playersWithSpectator = this.field_6002.method_8390(class_1657.class, this.getArenaBounds(), p -> true);
        ArrayList toRemove = Lists.newArrayList();
        for (class_3222 playerEntity : this.bossBar.method_14092()) {
            if (playersWithSpectator.contains(playerEntity)) continue;
            toRemove.add(playerEntity);
        }
        toRemove.forEach(arg_0 -> ((class_3213)this.bossBar).method_14089(arg_0));
        for (class_3222 playerEntity : playersWithSpectator) {
            if (this.bossBar.method_14092().contains(playerEntity)) continue;
            this.bossBar.method_14088(playerEntity);
        }
    }

    public boolean method_5643(class_1282 damageSource, float amount) {
        if (!this.active) {
            this.active = true;
        }
        if (this.phase != null) {
            this.phase.onHurt(damageSource, amount);
        }
        return super.method_5643(damageSource, amount);
    }

    public boolean method_6061(class_1282 damageSource) {
        if (this.active && this.phase == null) {
            this.setPhase(this.TELEPORT);
            return true;
        }
        if (this.phase == this.IDLE && !(damageSource.method_5529() instanceof class_1657)) {
            return true;
        }
        if (this.phase.isInvulnerable() && !damageSource.method_5538()) {
            return true;
        }
        return super.method_6061(damageSource);
    }

    protected void method_6099(class_1282 damageSource, int i, boolean bl) {
        class_1542 tapestry;
        class_1542 enchantedTotem = this.method_5706((class_1935)BMItems.ENCHANTED_TOTEM);
        if (enchantedTotem != null) {
            enchantedTotem.method_6976();
        }
        if ((tapestry = this.method_5706((class_1935)BMBlocks.ADJUDICATOR_TAPESTRY)) != null) {
            tapestry.method_6976();
        }
    }

    private void setPhase(AdjudicatorPhase phase) {
        if (this.phase != null) {
            this.phase.onExitPhase();
        }
        this.phase = phase;
        if (this.phase != null) {
            this.phase.onEnterPhase();
            this.setUpPhase();
        }
    }

    public void method_5674(class_2940<?> data) {
        if (data == STATE) {
            this.stateTime = 0;
            this.renderRotPrevious = 0.0f;
            this.field_6014 = this.method_23317();
            this.field_6036 = this.method_23318();
            this.field_5969 = this.method_23321();
            this.field_6038 = this.method_23317();
            this.field_5971 = this.method_23318();
            this.field_5989 = this.method_23321();
        }
        super.method_5674(data);
    }

    public void method_6078(class_1282 damageSource) {
        if (this.phase != null) {
            this.phase.onExitPhase();
        }
        this.active = false;
        this.bossBar.method_14094();
        this.bossBar.method_14091(false);
        super.method_6078(damageSource);
    }

    public void method_5742(class_3222 serverPlayer) {
        super.method_5742(serverPlayer);
        this.bossBar.method_14089(serverPlayer);
    }

    private void setUpPhase() {
        this.method_5942().method_6340();
        this.field_6201.method_19048().forEach(class_4135::method_6270);
        GoalSelectorExtension.copy(this.field_6201, this.phase.getGoalSelector());
        GoalSelectorExtension.copy(this.field_6185, this.phase.getTargetSelector());
        this.bossBar.method_14091(this.phase.showBossBar());
        this.method_5841().method_12778(INVULNERABLE, (Object)this.phase.isInvulnerable());
    }

    public boolean method_5810() {
        return false;
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("FirstTick", this.firstTick);
        tag.method_10556("BossActive", this.active);
        if (this.homePos != null) {
            NBTUtil.writeBlockPos(this.homePos, tag);
        }
        if (this.roomBounds != null) {
            NBTUtil.writeBox(this.roomBounds, tag);
        }
        if (this.arenaPositions != null) {
            class_2499 arenaPosTags = new class_2499();
            for (class_2338 pos : this.arenaPositions) {
                arenaPosTags.add((Object)class_2512.method_10692((class_2338)pos));
            }
            tag.method_10566("ArenaPositions", (class_2520)arenaPosTags);
        }
        if (this.phase == null) {
            this.phase = this.IDLE;
        }
        tag.method_10582("Phase", this.phase.getPhaseID().toString());
        tag.method_10566("PhaseData", (class_2520)this.phase.toTag());
        tag.method_10569("State", this.getState().ordinal());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.firstTick = tag.method_10577("FirstTick");
        this.active = tag.method_10577("BossActive");
        this.homePos = NBTUtil.readBlockPos(tag);
        this.roomBounds = NBTUtil.readBox(tag);
        if (tag.method_10545("ArenaPositions")) {
            class_2499 arenaTags = tag.method_10554("ArenaPositions", 10);
            this.arenaPositions = Lists.newArrayList();
            for (int i = 0; i < arenaTags.size(); ++i) {
                this.arenaPositions.add(class_2512.method_10691((class_2487)arenaTags.method_10602(i)));
            }
        }
        class_2960 phaseID = new class_2960(tag.method_10558("Phase"));
        AdjudicatorPhase adjPhase = this.PHASES.get(phaseID);
        adjPhase.fromTag(tag.method_10562("PhaseData"));
        this.phase = adjPhase;
        this.setUpPhase();
        this.setState(AdjudicatorState.values()[tag.method_10550("State")]);
    }

    public void selectTarget(Class<? extends class_1309> targetClass) {
        Object targetEntity = null;
        targetEntity = targetClass != class_1657.class && targetClass != class_3222.class ? this.field_6002.method_21726(targetClass, this.targetPredicate, (class_1309)this, this.method_23317(), this.method_23320(), this.method_23321(), this.getArenaBounds()) : this.field_6002.method_18463(this.targetPredicate, (class_1309)this, this.method_23317(), this.method_23320(), this.method_23321());
        if (targetEntity != null) {
            this.method_5980((class_1309)targetEntity);
        }
    }

    public void setActive() {
        this.active = true;
    }

    public class_2338 getHomePosition() {
        return this.homePos;
    }

    protected class_3414 method_5994() {
        return this.isActive() ? BMEffects.ADJUDICATOR_LAUGH : BMEffects.ADJUDICATOR_IDLE;
    }

    protected class_3414 method_6011(class_1282 source) {
        return BMEffects.ADJUDICATOR_HURT;
    }

    protected class_3414 method_6002() {
        return BMEffects.ADJUDICATOR_DEATH;
    }

    public void method_5665(@Nullable class_2561 component) {
        super.method_5665(component);
        this.bossBar.method_5413(this.method_5476());
    }

    public void method_5844(class_2680 blockState, class_243 vec3) {
    }

    public void method_5982() {
        this.field_6278 = 0;
    }

    public boolean method_5822() {
        return false;
    }

    public boolean method_5747(float f, float g, class_1282 damageSource) {
        return false;
    }

    public boolean isActive() {
        return this.active;
    }

    public class_1310 method_6046() {
        return class_1310.field_6291;
    }

    public class_2338 findSuitableArenaPos() {
        if (this.arenaPositions != null) {
            class_2338 arenaPos;
            while ((arenaPos = this.arenaPositions.get(this.field_5974.nextInt(this.arenaPositions.size()))).method_19771((class_2382)this.method_23312(), 1.0)) {
            }
            return arenaPos;
        }
        return null;
    }

    @Override
    public AdjudicatorState getState() {
        return AdjudicatorState.values()[(Integer)this.method_5841().method_12789(STATE) % AdjudicatorState.values().length];
    }

    public void setState(AdjudicatorState state) {
        this.method_5841().method_12778(STATE, (Object)state.ordinal());
        this.stateTime = 0;
    }

    public void teleportToRandomArenaPos() {
        this.teleportTo(this.findSuitableArenaPos());
    }

    public void teleportHome() {
        this.teleportTo(this.homePos);
    }

    public void teleportTo(class_2338 pos) {
        if (this.field_6002.method_8320(pos.method_10074()).method_26215()) {
            this.field_6002.method_8652(pos.method_10074(), class_2246.field_10445.method_9564(), 3);
        }
        this.method_24203((float)pos.method_10263() + 0.5f, (float)pos.method_10264() + 1.0f, (float)pos.method_10260() + 0.5f);
        this.clearArea((class_1297)this);
    }

    public void clearArea(class_1297 e) {
        if (this.field_6002.method_8450().method_8355(class_1928.field_19388)) {
            class_238 hitBox = e.method_5829();
            this.destroyArea(hitBox);
            if (e.method_5757()) {
                hitBox = hitBox.method_1014(1.0);
                this.destroyArea(hitBox);
            }
        }
    }

    private void destroyArea(class_238 hitBox) {
        class_2338.method_10097((class_2338)new class_2338((int)hitBox.field_1323, (int)hitBox.field_1322, (int)hitBox.field_1321), (class_2338)new class_2338((int)hitBox.field_1320, (int)hitBox.field_1325, (int)hitBox.field_1324)).forEach(b -> {
            if (class_1528.method_6883((class_2680)this.field_6002.method_8320(b))) {
                this.field_6002.method_8651(b, true, (class_1297)this);
                this.field_6002.method_8444(null, 1022, b, 0);
            }
        });
    }

    public boolean isCasting() {
        AdjudicatorState state = this.getState();
        return state == AdjudicatorState.SUMMONING || state == AdjudicatorState.TELEPORT;
    }

    public class_238 getArenaBounds() {
        return this.roomBounds;
    }

    public boolean method_6872() {
        return (Boolean)this.method_5841().method_12789(INVULNERABLE);
    }

    public void method_7110(boolean bl) {
        this.method_5841().method_12778(CHARGING, (Object)bl);
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.method_5841().method_12789(CHARGING);
    }

    public void method_18811(class_1309 target, class_1799 itemStack, class_1676 projectile, float multiShotSpray) {
        this.method_24652((class_1309)this, target, projectile, multiShotSpray, 1.6f);
    }

    public void method_24651() {
    }

    public void method_5650(class_1297.class_5529 removalReason) {
        super.method_5650(removalReason);
        AdjudicatorRoomListener.disableAdjudicator(this);
    }

    public boolean method_18395(class_1309 target) {
        if (this.method_5854() == target) {
            return false;
        }
        if (target instanceof PlayerCreatable && !((PlayerCreatable)target).isPlayerCreated()) {
            return false;
        }
        return super.method_18395(target);
    }

    public void method_7105(class_1309 target, float pullProgress) {
        if (this.method_6047().method_7909() instanceof class_1764) {
            this.method_24654((class_1309)this, 2.0f);
        } else {
            class_1799 arrowTypeStack = this.method_18808(this.method_5998(BMUtil.getHandPossiblyHolding((class_1309)this, i -> i.method_7909() instanceof class_1753)));
            class_1665 arrow = class_1675.method_18813((class_1309)this, (class_1799)arrowTypeStack, (float)pullProgress);
            double distanceX = target.method_23317() - this.method_23317();
            double distanceY = target.method_23323((double)0.333f) - arrow.method_23318();
            double distanceZ = target.method_23321() - this.method_23321();
            double arc = Math.sqrt(distanceX * distanceX + distanceZ * distanceZ);
            arrow.method_7485(distanceX, distanceY + arc * (double)0.2f, distanceZ, 1.6f, (float)(14 - this.field_6002.method_8407().method_5461() * 4));
            this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_6051().nextFloat() * 0.4f + 0.8f));
            this.field_6002.method_8649((class_1297)arrow);
        }
    }

    public static class_5132.class_5133 createAttributes() {
        return AdjudicatorEntity.method_26918().method_26868(class_5134.field_23716, 255.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23721, 3.0);
    }
}

