/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity;

import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1367;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4051;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.entity.TadpoleEntity;
import party.lemons.biomemakeover.entity.ToadTargetEntity;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.init.BMItems;
import party.lemons.biomemakeover.util.MathUtils;
import party.lemons.biomemakeover.util.RandomUtil;

public class ToadEntity
extends class_1429 {
    private static final UUID JUMP_SPEED_BOOST = UUID.fromString("0fa7caca-4f09-11eb-ae93-0242ac130002");
    private static final class_1322 JUMP_SPEED_BOOST_MOD = new class_1322(JUMP_SPEED_BOOST, "Jump Speed Boost", (double)0.6f, class_1322.class_1323.field_6328);
    private static final class_2940<Integer> TONGUE_ENTITY = class_2945.method_12791(ToadEntity.class, (class_2941)class_2943.field_13327);
    private boolean onGroundPrev;
    private int ticksUntilJump;
    public float tongueDistance;
    public float targetTongueDistance;
    public float mouthDistance = 0.0f;
    public int eatCooldown = 0;
    public boolean hasBaby;
    private final class_4051 predicate = class_4051.method_36626().method_18420(e -> e.method_5739((class_1297)e) < 10.0f);

    public ToadEntity(class_1299<? extends class_1429> entityType, class_1937 level) {
        super(entityType, level);
        this.method_5941(class_7.field_18, 0.0f);
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(TONGUE_ENTITY, (Object)-1);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new LookAtTongueTarget(this));
        this.field_6201.method_6277(0, (class_1352)new MakeTadpoleGoal(this, 1.0, 10));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 0.8));
        this.field_6201.method_6277(3, (class_1352)new class_1374((class_1314)this, 1.25));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 0.6));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.0, class_1856.method_8091((class_1935[])new class_1935[]{BMItems.DRAGONFLY_WINGS, class_1802.field_8680}), false));
        this.field_6201.method_6277(11, (class_1352)new class_1361((class_1308)this, class_1657.class, 10.0f));
        this.field_6201.method_6277(12, (class_1352)new class_1376((class_1308)this));
    }

    public void setTongueEntity(ToadTargetEntity e) {
        this.method_5841().method_12778(TONGUE_ENTITY, (Object)e.method_5628());
        e.setEatenBy(this);
        if (!this.field_6002.method_8608()) {
            this.method_5783(BMEffects.TOAD_MOUTH, 1.0f, 1.0f + (float)this.field_5974.nextGaussian() / 5.0f);
        }
    }

    public boolean hasTongueEntity() {
        return (Integer)this.method_5841().method_12789(TONGUE_ENTITY) != -1;
    }

    public int getTongueEntityID() {
        return (Integer)this.method_5841().method_12789(TONGUE_ENTITY);
    }

    public void clearTongueEntity() {
        if (this.field_6002.method_8469(this.getTongueEntityID()) != null) {
            ((ToadTargetEntity)this.field_6002.method_8469(this.getTongueEntityID())).setEatenBy(null);
        }
        this.method_5841().method_12778(TONGUE_ENTITY, (Object)-1);
    }

    public float method_6144(class_2338 blockPos, class_4538 levelReader) {
        if (levelReader.method_8320(blockPos).method_26164(BMBlocks.LILY_PADS)) {
            return 100.0f;
        }
        return super.method_6144(blockPos, levelReader);
    }

    public void method_5773() {
        super.method_5773();
        if (this.hasBaby && this.method_5618() == 0) {
            this.hasBaby = false;
        }
        if (this.hasTongueEntity()) {
            class_1297 e = this.field_6002.method_8469(this.getTongueEntityID());
            if (e != null && !e.method_5765()) {
                this.method_5988().method_6230(e.method_23317(), e.method_5829().field_1322 + 0.25, e.method_23321(), 100.0f, 100.0f);
                this.field_6283 = this.getTargetYaw();
                this.field_6241 = this.getTargetYaw();
                this.method_36457(this.getTargetPitch());
                float speed = 10.0f;
                this.targetTongueDistance = this.method_5739(e) * 16.0f - (float)(e.method_5829().field_1320 - e.method_5829().field_1323) * 16.0f;
                if (this.tongueDistance > this.targetTongueDistance) {
                    speed *= 2.0f;
                }
                this.tongueDistance = MathUtils.approachValue(this.tongueDistance, this.targetTongueDistance, speed);
            } else {
                this.targetTongueDistance = 0.0f;
                this.tongueDistance = MathUtils.approachValue(this.tongueDistance, 0.0f, 20.0f);
            }
        } else {
            this.targetTongueDistance = 0.0f;
            this.tongueDistance = MathUtils.approachValue(this.tongueDistance, 0.0f, 20.0f);
        }
    }

    public boolean isTongueReady() {
        float yaw = Math.abs((this.field_6283 + 1.0f) % 360.0f - this.getTargetYaw());
        boolean dis = Math.abs(this.tongueDistance - this.targetTongueDistance) < 5.0f;
        return dis && (yaw < 4.0f || yaw >= 360.0f);
    }

    public float getTargetYaw() {
        double xx = this.field_6206.method_6225() - this.method_23317();
        double zz = this.field_6206.method_6228() - this.method_23321();
        return (float)(class_3532.method_15349((double)zz, (double)xx) * 57.2957763671875) - 90.0f;
    }

    public float getTargetPitch() {
        double xx = this.field_6206.method_6225() - this.method_23317();
        double yy = this.field_6206.method_6227() - this.method_23320();
        double zz = this.field_6206.method_6228() - this.method_23321();
        double sqrt = class_3532.method_15355((float)((float)(xx * xx + zz * zz)));
        return (float)(-(class_3532.method_15349((double)yy, (double)sqrt) * 57.2957763671875));
    }

    public boolean canUseTongue() {
        return !this.method_5765();
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_7909() == BMItems.DRAGONFLY_WINGS || stack.method_7909() == class_1802.field_8680;
    }

    protected void method_5958() {
        super.method_5958();
        --this.eatCooldown;
        if (this.eatCooldown <= 0 && !this.hasTongueEntity()) {
            List targets = this.field_6002.method_8390(ToadTargetEntity.class, this.method_5829().method_1009(3.0, 3.0, 3.0), e -> this.method_6057((class_1297)e) && !e.isBeingEaten());
            ToadTargetEntity closest = (ToadTargetEntity)this.field_6002.method_18468(targets, this.predicate, (class_1309)this, this.method_23317(), this.method_23318(), this.method_23321());
            if (!this.canUseTongue() || closest == null || closest.method_5765() || targets.isEmpty()) {
                this.clearTongueEntity();
            } else {
                this.eatCooldown = 350;
                this.setTongueEntity(closest);
            }
        } else {
            class_1297 e2 = this.field_6002.method_8469(this.getTongueEntityID());
            if (!this.canUseTongue() || e2 == null || !e2.method_5805()) {
                this.clearTongueEntity();
            }
        }
        if (this.ticksUntilJump > 0) {
            --this.ticksUntilJump;
        }
        if (this.ticksUntilJump <= 0 && this.field_6207.method_6241()) {
            this.ticksUntilJump = RandomUtil.randomRange(20, 100);
            this.method_6043();
            class_1324 entityAttributeInstance = this.method_5996(class_5134.field_23719);
            entityAttributeInstance.method_6200(JUMP_SPEED_BOOST);
            entityAttributeInstance.method_26835(JUMP_SPEED_BOOST_MOD);
            this.method_5783(this.getJumpSound(), this.method_6107(), ((this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 1.0f) * 0.8f);
        }
        if (this.field_5952 && !this.onGroundPrev) {
            this.method_5996(class_5134.field_23719).method_6202(JUMP_SPEED_BOOST_MOD);
        }
        this.onGroundPrev = this.field_5952;
    }

    protected class_3414 getJumpSound() {
        return BMEffects.TOAD_JUMP;
    }

    public static class_5132.class_5133 createAttributes() {
        return ToadEntity.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, 0.25);
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10556("HasBaby", this.hasBaby);
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.hasBaby = compoundTag.method_10577("HasBaby");
    }

    public void setHasBaby(boolean hasBaby) {
        this.hasBaby = hasBaby;
    }

    public void method_24650(class_3218 serverLevel, class_1429 other) {
        class_3222 player = this.method_6478();
        if (player == null && other.method_6478() != null) {
            player = other.method_6478();
        }
        if (player != null) {
            player.method_7281(class_3468.field_15410);
            class_174.field_1190.method_855(player, (class_1429)this, other, null);
        }
        this.setHasBaby(true);
        this.method_5614(6000);
        other.method_5614(6000);
        this.method_6477();
        other.method_6477();
        serverLevel.method_8421((class_1297)this, (byte)18);
        if (serverLevel.method_8450().method_8355(class_1928.field_19391)) {
            serverLevel.method_8649((class_1297)new class_1303((class_1937)serverLevel, this.method_23317(), this.method_23318(), this.method_23321(), this.method_6051().nextInt(7) + 1));
        }
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverLevel, class_1296 ageableMob) {
        return null;
    }

    @Nullable
    protected class_3414 method_5994() {
        return BMEffects.TOAD_CROAK;
    }

    @Nullable
    protected class_3414 method_6002() {
        return BMEffects.TOAD_DEATH;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return BMEffects.TOAD_HURT;
    }

    private static class LookAtTongueTarget
    extends class_1352 {
        private final ToadEntity toad;

        public LookAtTongueTarget(ToadEntity entity) {
            this.toad = entity;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return this.toad.hasTongueEntity();
        }

        public boolean method_6266() {
            return this.toad.hasTongueEntity();
        }
    }

    public class MakeTadpoleGoal
    extends class_1367 {
        private final ToadEntity toad;

        public MakeTadpoleGoal(ToadEntity toad, double speed, int range) {
            super((class_1314)toad, speed, range, 5);
            this.toad = toad;
        }

        public boolean method_6264() {
            return this.toad.hasBaby && super.method_6264();
        }

        public boolean method_6266() {
            return super.method_6266() && this.toad.hasBaby;
        }

        public void method_6268() {
            super.method_6268();
            class_2338 blockPos = this.field_6516.method_23312();
            if (this.method_30953().method_19771((class_2382)this.toad.method_23312(), 2.0)) {
                ToadEntity.this.method_5942().method_6337((double)((float)this.method_30953().method_10263() + 0.5f), (double)this.method_30953().method_10264(), (double)((float)this.method_30953().method_10260() + 0.5f), 1.0);
            }
            if (this.toad.method_5799()) {
                class_3218 world = (class_3218)this.toad.field_6002;
                this.toad.setHasBaby(false);
                TadpoleEntity tadpole = (TadpoleEntity)BMEntities.TADPOLE.method_5883((class_1937)world);
                if (tadpole != null) {
                    world.method_8396(null, blockPos, BMEffects.TOAD_HAVE_BABY, class_3419.field_15245, 0.3f, 0.9f + world.field_9229.nextFloat() * 0.2f);
                    tadpole.method_7217(true);
                    tadpole.method_5808(this.toad.method_23317(), this.toad.method_23318(), this.toad.method_23321(), 0.0f, 0.0f);
                    world.method_30771((class_1297)tadpole);
                }
            }
        }

        public double method_6291() {
            return 0.0;
        }

        protected boolean method_6296(class_4538 levelReader, class_2338 blockPos) {
            class_3610 state = levelReader.method_8316(blockPos);
            return state.method_15771() && state.method_15767((class_3494)class_3486.field_15517) && levelReader.method_8320(blockPos.method_10084()).method_26215();
        }
    }
}

