/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1330;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1427;
import net.minecraft.class_1439;
import net.minecraft.class_1543;
import net.minecraft.class_1548;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3745;
import net.minecraft.class_3988;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import net.minecraft.class_6019;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.entity.PlayerCreatable;
import party.lemons.biomemakeover.entity.ai.BetterCrossbowAttackGoal;
import party.lemons.biomemakeover.entity.ai.EmptyMobNavigation;
import party.lemons.biomemakeover.entity.mutipart.EntityPart;
import party.lemons.biomemakeover.entity.mutipart.MultiPartEntity;
import party.lemons.biomemakeover.init.BMAdvancements;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.util.sound.StoneGolemTurnSoundInstance;

public class StoneGolemEntity
extends class_1427
implements class_3745,
class_5354,
MultiPartEntity<EntityPart<StoneGolemEntity>>,
PlayerCreatable {
    private static final class_2940<Boolean> CHARGING = class_2945.method_12791(StoneGolemEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> PLAYER_CREATED = class_2945.method_12791(StoneGolemEntity.class, (class_2941)class_2943.field_13323);
    private static final class_6019 ANGER_TIME_RANGE = class_4802.method_24505((int)20, (int)39);
    private int angerTime;
    private int holdCooldown = 0;
    private UUID angryAt;
    private EntityPart<StoneGolemEntity> BODY = new EntityPart<StoneGolemEntity>(this, 1.6f, 2.0f, 0.0, 0.5, 0.0);
    private EntityPart<StoneGolemEntity> BASE = new EntityPart<StoneGolemEntity>(this, 0.875f, 0.5f, 0.0, 0.0, 0.0).collides();
    private List<EntityPart<StoneGolemEntity>> parts = Lists.newArrayList((Object[])new EntityPart[]{this.BODY, this.BASE});
    private Object turnSound = null;
    private class_238 cullBox = class_4048.method_18385((float)1.6f, (float)2.5f).method_30231(0.0, 0.0, 0.0);

    public StoneGolemEntity(class_1299<? extends class_1427> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, new BetterCrossbowAttackGoal<StoneGolemEntity>(this, 1.0, 24.0f));
        this.field_6201.method_6277(2, (class_1352)new class_1361((class_1308)this, class_1657.class, 5.0f, 1.0f));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1308.class, 5.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, StoneGolemEntity.class, 10.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1427.class, 5.0f));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_3988.class, false));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, StoneGolemEntity.class, false));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1439.class, false));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, this::method_29515));
        this.field_6185.method_6277(6, (class_1352)new class_1400((class_1308)this, class_1308.class, 5, false, false, livingEntity -> livingEntity instanceof class_1588 && !(livingEntity instanceof class_1548)));
        this.field_6185.method_6277(4, (class_1352)new class_5398((class_1308)this, false));
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(CHARGING, (Object)false);
        this.method_5841().method_12784(PLAYER_CREATED, (Object)false);
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (this.isPlayerCreated()) {
            class_1799 playerStack = player.method_5998(hand);
            if (!playerStack.method_7960() && playerStack.method_7909() == BMBlocks.CLADDED_STONE.method_8389()) {
                float currentHealth = this.method_6032();
                this.method_6025(15.0f);
                if (this.method_6032() == currentHealth) {
                    return class_1269.method_29236((boolean)this.field_6002.method_8608());
                }
                float g = 1.0f + (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f;
                this.method_5783(class_3417.field_21077, 1.0f, g);
                if (!player.method_7337()) {
                    playerStack.method_7934(1);
                }
                return class_1269.method_29236((boolean)this.field_6002.method_8608());
            }
            if (this.isHolding() && this.holdCooldown <= 0) {
                if (!this.field_6002.method_8608()) {
                    player.method_31548().method_7398(this.method_6118(class_1304.field_6173).method_7972());
                    this.method_5673(class_1304.field_6173, class_1799.field_8037);
                }
                return class_1269.field_5812;
            }
            if (!playerStack.method_7960() && playerStack.method_7909() == class_1802.field_8399) {
                if (!this.field_6002.method_8608()) {
                    class_1799 newStack = playerStack.method_7972();
                    newStack.method_7939(1);
                    this.method_5673(class_1304.field_6173, newStack);
                    playerStack.method_7934(1);
                    ++this.holdCooldown;
                    BMAdvancements.ARM_GOLEM.trigger((class_3222)player);
                }
                return class_1269.field_5812;
            }
        }
        return super.method_5992(player, hand);
    }

    public void method_5773() {
        super.method_5773();
        this.holdCooldown = 0;
        if (this.field_6283 != this.field_6220 && this.field_6002.method_8608()) {
            this.playRotateSound();
        }
    }

    private boolean isHolding() {
        return !this.method_6118(class_1304.field_6173).method_7960();
    }

    protected void method_5964(class_1266 difficultyInstance) {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8399));
    }

    @Nullable
    public class_1315 method_5943(class_5425 serverLevelAccessor, class_1266 difficultyInstance, class_3730 mobSpawnType, @Nullable class_1315 spawnGroupData, @Nullable class_2487 compoundTag) {
        this.method_5964(difficultyInstance);
        this.method_5984(difficultyInstance);
        return super.method_5943(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public boolean method_29515(class_1309 livingEntity) {
        if (class_1301.field_6156.test(livingEntity) && !this.isPlayerCreated()) {
            return true;
        }
        return super.method_29515(livingEntity);
    }

    public boolean method_18395(class_1309 target) {
        if (this.isPlayerCreated()) {
            if (target instanceof class_1657 || target instanceof class_3988) {
                return false;
            }
            if (target instanceof class_1439) {
                return !((class_1439)target).method_6496();
            }
        } else {
            if (target instanceof class_1588) {
                return false;
            }
            if (target instanceof class_1439) {
                return ((class_1439)target).method_6496();
            }
        }
        if (target instanceof StoneGolemEntity) {
            return ((StoneGolemEntity)target).isPlayerCreated() != this.isPlayerCreated();
        }
        return super.method_18395(target);
    }

    @Override
    public boolean isPlayerCreated() {
        return (Boolean)this.method_5841().method_12789(PLAYER_CREATED);
    }

    @Override
    public void setPlayerCreated(boolean playerCreated) {
        this.method_5841().method_12778(PLAYER_CREATED, (Object)playerCreated);
    }

    protected int method_6130(int i) {
        return i;
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("PlayerCreated", this.isPlayerCreated());
        this.method_29517(tag);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setPlayerCreated(tag.method_10577("PlayerCreated"));
        this.method_29512(this.field_6002, tag);
    }

    protected class_3414 method_6002() {
        return BMEffects.STONE_GOLEM_DEATH;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return BMEffects.STONE_GOLEM_HURT;
    }

    protected class_1408 method_5965(class_1937 level) {
        return new EmptyMobNavigation((class_1308)this, level);
    }

    protected class_1330 method_5963() {
        return new StoneGolemBodyControl((class_1308)this);
    }

    public int method_29507() {
        return this.angerTime;
    }

    public void method_29514(int i) {
        this.angerTime = i;
    }

    public boolean method_30949(class_1297 entity) {
        return false;
    }

    public void method_5762(double d, double e, double f) {
    }

    @Nullable
    public UUID method_29508() {
        return this.angryAt;
    }

    public void method_29513(@Nullable UUID uUID) {
        this.angryAt = uUID;
    }

    public void method_29509() {
        this.method_29514(ANGER_TIME_RANGE.method_35008(this.field_5974));
    }

    public void method_7110(boolean bl) {
        this.method_5841().method_12778(CHARGING, (Object)bl);
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.method_5841().method_12789(CHARGING);
    }

    public void method_18811(class_1309 livingEntity, class_1799 itemStack, class_1676 projectile, float f) {
        this.method_24652((class_1309)this, livingEntity, projectile, f, 1.6f);
    }

    public void method_6007() {
        super.method_6007();
        this.updateParts();
    }

    public void method_6005(double d, double e, double f) {
    }

    public int method_5986() {
        return 20;
    }

    public int method_5978() {
        return 2;
    }

    public boolean method_25938(class_1811 projectileWeaponItem) {
        return projectileWeaponItem == class_1802.field_8399;
    }

    public void method_24651() {
    }

    public void method_7105(class_1309 livingEntity, float f) {
        this.method_24654((class_1309)this, f);
    }

    public class_1799 method_18808(class_1799 stack) {
        if (stack.method_7909() instanceof class_1811) {
            Predicate predicate = ((class_1811)stack.method_7909()).method_20310();
            class_1799 itemStack = class_1811.method_18815((class_1309)this, (Predicate)predicate);
            return itemStack.method_7960() ? new class_1799((class_1935)class_1802.field_8107) : itemStack;
        }
        return class_1799.field_8037;
    }

    protected float method_18394(class_4050 pose, class_4048 entityDimensions) {
        return 2.0f;
    }

    @Override
    public boolean damagePart(EntityPart<StoneGolemEntity> part, class_1282 source, float amount) {
        return this.method_5643(source, amount);
    }

    @Environment(value=EnvType.CLIENT)
    public class_1543.class_1544 getState() {
        if (this.isChargingCrossbow()) {
            return class_1543.class_1544.field_7210;
        }
        if (this.method_24518(class_1802.field_8399)) {
            return class_1543.class_1544.field_7213;
        }
        return this.method_6510() ? class_1543.class_1544.field_7211 : class_1543.class_1544.field_21512;
    }

    @Environment(value=EnvType.CLIENT)
    private void playRotateSound() {
        boolean nulled;
        boolean bl = nulled = this.turnSound == null;
        if (nulled || ((StoneGolemTurnSoundInstance)((Object)this.turnSound)).method_4793()) {
            if (!nulled) {
                class_310.method_1551().method_1483().method_4870((class_1113)((StoneGolemTurnSoundInstance)((Object)this.turnSound)));
            }
            this.turnSound = new StoneGolemTurnSoundInstance(this);
            class_310.method_1551().method_1483().method_4873((class_1113)((StoneGolemTurnSoundInstance)((Object)this.turnSound)));
        } else if (!nulled) {
            ((StoneGolemTurnSoundInstance)((Object)this.turnSound)).method_16896();
        }
    }

    public class_1439.class_4621 getCrack() {
        return class_1439.class_4621.method_23693((float)(this.method_6032() / this.method_6063()));
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1439.class_4621 crack = this.getCrack();
        boolean bl = super.method_5643(source, amount);
        if (bl && this.getCrack() != crack) {
            this.method_5783(class_3417.field_21076, 1.0f, 1.0f);
        }
        return bl;
    }

    public double method_5621() {
        return 2.0;
    }

    public boolean method_5956() {
        return false;
    }

    @Override
    public List<EntityPart<StoneGolemEntity>> getParts() {
        return this.parts;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 60.0);
    }

    public class_238 method_5830() {
        return this.cullBox.method_997(this.method_19538());
    }

    private static class StoneGolemBodyControl
    extends class_1330 {
        private final class_1308 entity;
        private int activeTicks;

        public StoneGolemBodyControl(class_1308 mob) {
            super(mob);
            this.entity = mob;
        }

        public void method_6224() {
            ++this.activeTicks;
            this.rotateBody();
            this.rotateLook();
        }

        private void rotateLook() {
            this.entity.method_5636(class_3532.method_20306((float)this.entity.method_36454(), (float)this.entity.method_5791(), (float)this.entity.method_5986()));
        }

        private void rotateBody() {
            int i = this.activeTicks - 10;
            float f = class_3532.method_15363((float)((float)i / 10.0f), (float)0.0f, (float)1.0f);
            float g = (float)this.entity.method_5986() * (1.0f - f);
            this.entity.method_5636(class_3532.method_20306((float)this.entity.method_36454(), (float)this.entity.method_5791(), (float)g));
        }
    }
}

