/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1338;
import net.minecraft.class_1341;
import net.minecraft.class_1344;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.init.BMItems;

public class ScuttlerEntity
extends class_1429 {
    private static final class_2940<Boolean> RATTLING = class_2945.method_12791(ScuttlerEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> EATING = class_2945.method_12791(ScuttlerEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> PASSIVE = class_2945.method_12791(ScuttlerEntity.class, (class_2941)class_2943.field_13323);
    public class_1856 TEMPT_ITEM = class_1856.method_8091((class_1935[])new class_1935[]{BMItems.PINK_PETALS});
    public float rattleTime = 0.0f;
    private int eatCooldown = 100;
    public int eatTime = 0;

    public ScuttlerEntity(class_1299<? extends class_1429> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5959() {
        this.TEMPT_ITEM = class_1856.method_8091((class_1935[])new class_1935[]{BMItems.PINK_PETALS});
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1391((class_1314)this, 0.7, this.TEMPT_ITEM, false));
        this.field_6201.method_6277(2, new RattleGoal<class_1657>(this, 20.0f, class_1657.class));
        this.field_6201.method_6277(3, (class_1352)new class_1374((class_1314)this, 1.25));
        this.field_6201.method_6277(4, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new class_1338((class_1314)this, class_1657.class, 16.0f, 1.6, 1.4, livingEntity -> !this.isPassive()));
        this.field_6201.method_6277(6, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(7, (class_1352)new EatFlowerGoal());
        this.field_6201.method_6277(8, (class_1352)new AvoidDaylightGoal(1.0));
        this.field_6201.method_6277(9, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(11, (class_1352)new class_1376((class_1308)this));
    }

    public static class_5132.class_5133 createAttributes() {
        return ScuttlerEntity.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, 0.25);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(RATTLING, (Object)false);
        this.field_6011.method_12784(EATING, (Object)false);
        this.field_6011.method_12784(PASSIVE, (Object)false);
    }

    public void method_5773() {
        super.method_5773();
        --this.eatCooldown;
        if (((Boolean)this.field_6011.method_12789(EATING)).booleanValue()) {
            --this.eatTime;
        }
        if (((Boolean)this.field_6011.method_12789(RATTLING)).booleanValue()) {
            double dir = Math.signum(Math.sin(this.rattleTime));
            this.rattleTime += 1.0f;
            if (dir != Math.signum(Math.sin(this.rattleTime))) {
                this.method_5783(BMEffects.SCUTTLER_RATTLE, 0.25f, 0.75f + this.field_5974.nextFloat());
            }
        } else {
            this.rattleTime = 0.0f;
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        class_1792 item = itemStack.method_7909();
        if (this.field_6002.method_8608()) {
            if (this.method_6481(itemStack)) {
                return class_1269.field_5812;
            }
        } else if (((Boolean)this.field_6011.method_12789(PASSIVE)).booleanValue()) {
            if (item.method_19264() != null && this.method_6481(itemStack) && this.method_6032() < this.method_6063()) {
                this.method_18866(this.field_6002, itemStack);
                this.method_6025(item.method_19264().method_19230());
                return class_1269.field_21466;
            }
        } else if (this.method_6481(itemStack)) {
            this.method_18866(this.field_6002, itemStack);
            if (this.field_5974.nextInt(3) == 0) {
                this.field_6011.method_12778(PASSIVE, (Object)true);
                this.field_6002.method_8421((class_1297)this, (byte)7);
            } else {
                this.field_6002.method_8421((class_1297)this, (byte)6);
            }
            this.method_5971();
            return class_1269.field_21466;
        }
        return super.method_5992(player, hand);
    }

    public boolean method_5679(class_1282 damageSource) {
        if (damageSource == class_1282.field_5848) {
            return true;
        }
        return super.method_5679(damageSource);
    }

    public boolean method_6481(class_1799 itemStack) {
        return this.TEMPT_ITEM.method_8093(itemStack);
    }

    public boolean method_5931(class_1657 player) {
        return super.method_5931(player) && this.isPassive();
    }

    public void method_5674(class_2940<?> entityDataAccessor) {
        super.method_5674(entityDataAccessor);
        if (entityDataAccessor == RATTLING) {
            this.rattleTime = 0.0f;
        }
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverLevel, class_1296 ageableMob) {
        ScuttlerEntity baby = (ScuttlerEntity)BMEntities.SCUTTLER.method_5883((class_1937)serverLevel);
        baby.setPassive(true);
        return baby;
    }

    public boolean isPassive() {
        return (Boolean)this.field_6011.method_12789(PASSIVE);
    }

    public void setPassive(boolean passive) {
        this.field_6011.method_12778(PASSIVE, (Object)passive);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("Passive", this.isPassive());
        tag.method_10569("EatCooldown", this.eatCooldown);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setPassive(tag.method_10577("Passive"));
        this.eatCooldown = tag.method_10550("EatCooldown");
    }

    protected void method_5712(class_2338 blockPos, class_2680 state) {
        if (!state.method_26207().method_15797()) {
            this.method_5783(BMEffects.SCUTTLER_STEP, 0.1f, 1.25f + this.field_5974.nextFloat());
            this.method_5839();
        }
    }

    @Nullable
    protected class_3414 method_6002() {
        return BMEffects.SCUTTLER_DEATH;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return BMEffects.SCUTTLER_RATTLE;
    }

    public int method_5970() {
        return super.method_5970() * 3;
    }

    protected float method_18394(class_4050 pose, class_4048 entityDimensions) {
        return 0.2f;
    }

    public boolean method_5979(class_1936 level, class_3730 mobSpawnType) {
        return level.method_8409().nextBoolean() && level.method_8390(ScuttlerEntity.class, new class_238(new class_2338(this.method_23317(), this.method_23318(), this.method_23321())).method_1014(50.0), e -> true).isEmpty() && super.method_5979(level, mobSpawnType);
    }

    public int method_5945() {
        return 1;
    }

    public static boolean checkSpawnRules(class_1299<ScuttlerEntity> type, class_5425 level, class_3730 mobSpawnType, class_2338 blockPos, Random random) {
        return level.method_8320(blockPos.method_10074()).method_26225();
    }

    private static class RattleGoal<T extends class_1309>
    extends class_1352 {
        private final ScuttlerEntity scuttler;
        private final float distance;
        private final Class<T> targetClass;
        T targetEntity;
        private final class_4051 withinRangePredicate;

        public RattleGoal(ScuttlerEntity scuttlerEntity, float distance, Class<T> target) {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405));
            this.scuttler = scuttlerEntity;
            this.distance = distance;
            this.targetClass = target;
            Predicate<class_1309> s = l -> true;
            this.withinRangePredicate = class_4051.method_36626().method_18418((double)distance).method_18420(s.and(class_1301.field_6156));
        }

        public boolean method_6264() {
            if (this.scuttler.method_5799() || this.scuttler.isPassive()) {
                return false;
            }
            this.targetEntity = this.scuttler.field_6002.method_21726(this.targetClass, this.withinRangePredicate, (class_1309)this.scuttler, this.scuttler.method_23317(), this.scuttler.method_23318(), this.scuttler.method_23321(), this.scuttler.method_5829().method_1009((double)this.distance, 3.0, (double)this.distance));
            if (this.targetEntity == null || !this.scuttler.method_6057((class_1297)this.targetEntity) || !this.targetEntity.method_6057((class_1297)this.scuttler)) {
                return false;
            }
            return !this.targetEntity.method_24518(BMItems.PINK_PETALS) && this.scuttler.method_5739((class_1297)this.targetEntity) >= this.distance / 2.0f;
        }

        public boolean method_6266() {
            if (this.targetEntity.method_24518(BMItems.PINK_PETALS)) {
                return false;
            }
            double d = this.scuttler.method_5739((class_1297)this.targetEntity);
            return d > (double)(this.distance / 2.0f) && d < (double)this.distance && this.scuttler.method_6057((class_1297)this.targetEntity) && this.targetEntity.method_6057((class_1297)this.scuttler);
        }

        public void method_6270() {
            this.scuttler.method_5841().method_12778(RATTLING, (Object)false);
            super.method_6270();
        }

        public void method_6269() {
            this.scuttler.method_5841().method_12778(RATTLING, (Object)true);
            this.scuttler.method_5942().method_6340();
            super.method_6269();
        }

        public void method_6268() {
            this.scuttler.field_6206.method_6226(this.targetEntity, 30.0f, 30.0f);
        }
    }

    public class EatFlowerGoal
    extends class_1352 {
        private class_2338 targetPos;

        public EatFlowerGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (ScuttlerEntity.this.eatCooldown > 0) {
                return false;
            }
            class_2338 eatPos = this.findCactus();
            if (eatPos != null) {
                this.targetPos = eatPos;
                return true;
            }
            return false;
        }

        public void method_6268() {
            class_2680 st;
            if (ScuttlerEntity.this.method_5649((float)this.targetPos.method_10263() + 0.5f, (float)this.targetPos.method_10264() + 0.5f, (float)this.targetPos.method_10260() + 0.5f) > 2.0) {
                ScuttlerEntity.this.method_5962().method_6239((double)((float)this.targetPos.method_10263() + 0.5f), (double)((float)this.targetPos.method_10264() + 0.5f), (double)((float)this.targetPos.method_10260() + 0.5f), (double)0.6f);
            }
            ScuttlerEntity.this.method_5988().method_20248((double)((float)this.targetPos.method_10263() + 0.5f), (double)((float)this.targetPos.method_10264() + 0.5f), (double)((float)this.targetPos.method_10260() + 0.5f));
            if (ScuttlerEntity.this.eatTime <= 1 && (st = ScuttlerEntity.this.field_6002.method_8320(this.targetPos)).method_27852((class_2248)BMBlocks.BARREL_CACTUS_FLOWERED)) {
                ScuttlerEntity.this.field_6002.method_8652(this.targetPos, BMBlocks.BARREL_CACTUS.method_9564(), 2);
                class_1264.method_5449((class_1937)ScuttlerEntity.this.field_6002, (double)this.targetPos.method_10263(), (double)this.targetPos.method_10264(), (double)this.targetPos.method_10260(), (class_1799)new class_1799((class_1935)BMItems.PINK_PETALS));
                ScuttlerEntity.this.eatCooldown = 100 + ScuttlerEntity.this.field_5974.nextInt(200);
            }
        }

        public boolean method_6266() {
            if (ScuttlerEntity.this.eatTime <= 0 || ScuttlerEntity.this.eatCooldown > 0) {
                return false;
            }
            class_2680 st = ScuttlerEntity.this.field_6002.method_8320(this.targetPos);
            if (!st.method_27852((class_2248)BMBlocks.BARREL_CACTUS_FLOWERED)) {
                return false;
            }
            return ScuttlerEntity.this.method_5649((float)this.targetPos.method_10263() + 0.5f, (float)this.targetPos.method_10264() + 0.5f, (float)this.targetPos.method_10260() + 0.5f) <= 2.0;
        }

        public void method_6269() {
            ScuttlerEntity.this.method_5841().method_12778(EATING, (Object)true);
            ScuttlerEntity.this.eatTime = 20 + ScuttlerEntity.this.field_5974.nextInt(40);
        }

        public void method_6270() {
            ScuttlerEntity.this.method_5841().method_12778(EATING, (Object)false);
        }

        private class_2338 findCactus() {
            class_2338 startPos = ScuttlerEntity.this.method_23312();
            ArrayList spots = Lists.newArrayList();
            class_2338.class_2339 m = new class_2338.class_2339(startPos.method_10263(), startPos.method_10264(), startPos.method_10260());
            for (int x = startPos.method_10263() - 2; x < startPos.method_10263() + 2; ++x) {
                for (int z = startPos.method_10260() - 2; z < startPos.method_10260() + 2; ++z) {
                    m.method_10103(x, startPos.method_10264(), z);
                    class_2680 checkState = ScuttlerEntity.this.field_6002.method_8320((class_2338)m);
                    if (!checkState.method_27852((class_2248)BMBlocks.BARREL_CACTUS_FLOWERED)) continue;
                    spots.add(new class_2338(m.method_10263(), m.method_10264(), m.method_10260()));
                }
            }
            if (spots.isEmpty()) {
                return null;
            }
            return (class_2338)spots.get(ScuttlerEntity.this.field_6002.field_9229.nextInt(spots.size()));
        }
    }

    class AvoidDaylightGoal
    extends class_1344 {
        private int timer;

        AvoidDaylightGoal(double speed) {
            super((class_1314)ScuttlerEntity.this, speed);
            this.timer = 100;
        }

        public boolean method_6264() {
            if (this.field_6419.method_5968() == null) {
                if (this.timer > 0) {
                    --this.timer;
                    return false;
                }
                this.timer = 100;
                class_2338 pos = this.field_6419.method_23312();
                return ScuttlerEntity.this.field_6002.method_8530() && ScuttlerEntity.this.field_6002.method_8311(pos) && this.method_18250();
            }
            return false;
        }
    }
}

