/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5147;
import net.minecraft.class_5425;
import net.minecraft.class_5532;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.entity.event.EntityEvent;
import party.lemons.biomemakeover.entity.event.EntityEventBroadcaster;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.init.BMItems;
import party.lemons.biomemakeover.util.EntityUtil;
import party.lemons.biomemakeover.util.RandomUtil;

public class RootlingEntity
extends class_1429
implements class_5147,
EntityEventBroadcaster {
    public static final class_2940<Boolean> HAS_FLOWER = class_2945.method_12791(RootlingEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Integer> FLOWER_TYPE = class_2945.method_12791(RootlingEntity.class, (class_2941)class_2943.field_13327);
    public static final class_1792[] PETAL_ITEMS = new class_1792[]{BMItems.BLUE_PETALS, BMItems.BROWN_PETALS, BMItems.CYAN_PETALS, BMItems.GRAY_PETALS, BMItems.LIGHT_BLUE_PETALS, BMItems.PURPLE_PETALS};
    private boolean hasAction = false;
    public RootlingEntity forcedDancePartner = null;
    private int actionCooldown = RandomUtil.randomRange(0, 500);
    private int growTime = 0;
    private static final class_4051 VALID_ROOTLING_PARTNER = class_4051.method_36626().method_18418(8.0);
    public static int MAX_DANCE_TIME = 60;
    public static int MAX_FOLLOW_TIME = 120;
    public static int MAX_INSPECT_TIME = 200;
    public static int MAX_ACTION_COOLDOWN = 500;

    public RootlingEntity(class_1299<? extends class_1429> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.25));
        this.field_6201.method_6277(2, (class_1352)new GetInRainGoal());
        this.field_6201.method_6277(4, (class_1352)new RootlingFleeGoal((class_1314)this, class_1309.class, 8.0f, 1.6, 1.4, e -> e.method_6118(class_1304.field_6173).method_7909() == class_1802.field_8868 || e.method_6118(class_1304.field_6171).method_7909() == class_1802.field_8868));
        this.field_6201.method_6277(5, (class_1352)new class_1391((class_1314)this, 1.0, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8324}), false));
        this.field_6201.method_6277(6, (class_1352)new DanceGoal());
        this.field_6201.method_6277(7, (class_1352)new FollowEntityGoal());
        this.field_6201.method_6277(8, (class_1352)new InspectFlowerGoal());
        this.field_6201.method_6277(9, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(11, (class_1352)new class_1376((class_1308)this));
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(HAS_FLOWER, (Object)true);
        this.method_5841().method_12784(FLOWER_TYPE, (Object)0);
    }

    protected void method_5958() {
        super.method_5958();
        if (!this.field_6002.method_8608()) {
            if (!this.hasAction()) {
                --this.actionCooldown;
            }
            if (this.growTime > 0) {
                --this.growTime;
                if (this.method_5799() && this.field_5974.nextInt(5) == 0) {
                    --this.growTime;
                }
                if (this.growTime <= 0 && !this.hasFlower()) {
                    this.setFlowered(true);
                }
            }
        }
    }

    public static class_5132.class_5133 createAttributes() {
        return RootlingEntity.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, 0.25);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_7909() == class_1802.field_8868) {
            if (!this.field_6002.method_8608() && this.method_27072()) {
                this.method_6636(class_3419.field_15248);
                itemStack.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        if (itemStack.method_7909() == class_1802.field_8324 && !this.hasFlower()) {
            if (this.field_6002.method_8608()) {
                return class_1269.field_21466;
            }
            this.broadcastEvent((class_1297)this, EntityEvent.BONEMEAL_PARTICLE);
            if (this.field_5974.nextInt(3) == 0) {
                this.setFlowered(true);
            }
            if (!player.method_7337()) {
                itemStack.method_7934(1);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public int getActionCooldown() {
        return this.actionCooldown;
    }

    public void setActionCoolDown(int cooldown) {
        this.actionCooldown = cooldown;
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("ActionCooldown", this.actionCooldown);
        tag.method_10569("GrowTime", this.growTime);
        tag.method_10556("HasFlower", ((Boolean)this.method_5841().method_12789(HAS_FLOWER)).booleanValue());
        tag.method_10569("FlowerType", this.getFlowerIndex());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.actionCooldown = tag.method_10550("ActionCooldown");
        this.growTime = tag.method_10550("GrowTime");
        this.method_5841().method_12778(HAS_FLOWER, (Object)tag.method_10577("HasFlower"));
        this.method_5841().method_12778(FLOWER_TYPE, (Object)tag.method_10550("FlowerType"));
    }

    protected float method_18394(class_4050 pose, class_4048 entityDimensions) {
        return this.method_18377((class_4050)this.method_18376()).field_18068 * 0.6f;
    }

    public boolean hasFlower() {
        return (Boolean)this.method_5841().method_12789(HAS_FLOWER);
    }

    public void setFlowered(boolean hasFlower) {
        boolean current = (Boolean)this.method_5841().method_12789(HAS_FLOWER);
        if (current != hasFlower) {
            this.method_5841().method_12778(HAS_FLOWER, (Object)hasFlower);
            if (hasFlower) {
                this.randomizeFlower();
            } else {
                EntityUtil.scatterItemStack((class_1297)this, new class_1799((class_1935)PETAL_ITEMS[(Integer)this.method_5841().method_12789(FLOWER_TYPE)], RandomUtil.randomRange(1, 4)));
            }
        }
    }

    public boolean hasAction() {
        return this.hasAction;
    }

    public void setHasAction(boolean dancing) {
        this.hasAction = dancing;
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverLevel, class_1296 ageableMob) {
        return null;
    }

    public void method_6636(class_3419 soundSource) {
        this.field_6002.method_8449(null, (class_1297)this, class_3417.field_14975, soundSource, 1.0f, 1.0f);
        this.setFlowered(false);
        this.growTime = RandomUtil.randomRange(600, 1200);
    }

    public boolean method_27072() {
        return this.hasFlower();
    }

    public int getFlowerIndex() {
        return (Integer)this.method_5841().method_12789(FLOWER_TYPE);
    }

    public class_1315 method_5943(class_5425 serverLevelAccessor, class_1266 difficultyInstance, class_3730 mobSpawnType, @Nullable class_1315 spawnGroupData, @Nullable class_2487 compoundTag) {
        class_1315 data = super.method_5943(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
        this.randomizeFlower();
        return data;
    }

    public void randomizeFlower() {
        this.method_5841().method_12778(FLOWER_TYPE, (Object)this.field_5974.nextInt(PETAL_ITEMS.length));
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return BMEffects.ROOTLING_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return BMEffects.ROOTLING_DEATH;
    }

    @Nullable
    protected class_3414 method_5994() {
        return BMEffects.ROOTLING_IDLE;
    }

    public class GetInRainGoal
    extends class_1352 {
        private double targetX;
        private double targetY;
        private double targetZ;

        public GetInRainGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (RootlingEntity.this.field_6002.method_8419() && !RootlingEntity.this.field_6002.method_8311(RootlingEntity.this.method_23312())) {
                return true;
            }
            return this.targetSkyPos();
        }

        protected boolean targetSkyPos() {
            class_243 vec3d = this.locateSkyPos();
            if (vec3d == null) {
                return false;
            }
            this.targetX = vec3d.field_1352;
            this.targetY = vec3d.field_1351;
            this.targetZ = vec3d.field_1350;
            return true;
        }

        public boolean method_6266() {
            return !RootlingEntity.this.method_5942().method_6357();
        }

        public void method_6269() {
            RootlingEntity.this.method_5942().method_6337(this.targetX, this.targetY, this.targetZ, 1.0);
        }

        protected class_243 locateSkyPos() {
            Random random = RootlingEntity.this.method_6051();
            class_2338 blockPos = RootlingEntity.this.method_23312();
            for (int i = 0; i < 10; ++i) {
                class_2338 blockPos2 = blockPos.method_10069(random.nextInt(20) - 10, random.nextInt(6) - 3, random.nextInt(20) - 10);
                if (!RootlingEntity.this.field_6002.method_8311(blockPos2) || !(RootlingEntity.this.method_6149(blockPos2) < 0.0f)) continue;
                return class_243.method_24955((class_2382)blockPos2);
            }
            return null;
        }
    }

    private class RootlingFleeGoal
    extends class_1338<class_1309> {
        private int soundTime;
        private final class_4051 withinRangePredicate;

        public RootlingFleeGoal(class_1314 fleeingEntity, Class<class_1309> classToFleeFrom, float fleeDistance, double fleeSlowSpeed, double fleeFastSpeed, Predicate<class_1309> inclusionSelector) {
            super(fleeingEntity, classToFleeFrom, fleeDistance, fleeSlowSpeed, fleeFastSpeed, inclusionSelector);
            this.soundTime = 0;
            this.withinRangePredicate = class_4051.method_36626().method_18418((double)fleeDistance).method_18420(inclusionSelector.and(inclusionSelector));
        }

        public boolean method_6264() {
            this.field_6390 = this.field_6391.field_6002.method_21726(this.field_6392, this.withinRangePredicate, (class_1309)this.field_6391, this.field_6391.method_23317(), this.field_6391.method_23318(), this.field_6391.method_23321(), this.field_6391.method_5829().method_1009((double)this.field_6386, 3.0, (double)this.field_6386));
            if (this.field_6390 == null) {
                return false;
            }
            class_243 vec3 = class_5532.method_31511((class_1314)this.field_6391, (int)16, (int)7, (class_243)this.field_6390.method_19538());
            if (vec3 == null) {
                return false;
            }
            if (this.field_6390.method_5649(vec3.field_1352, vec3.field_1351, vec3.field_1350) < this.field_6390.method_5858((class_1297)this.field_6391)) {
                return false;
            }
            this.field_6387 = this.field_6394.method_6352(vec3.field_1352, vec3.field_1351, vec3.field_1350, 0);
            return this.field_6387 != null;
        }

        public void method_6269() {
            super.method_6269();
            if (this.soundTime == 0) {
                this.field_6391.method_5783(BMEffects.ROOTLING_AFRAID, 1.0f, 1.0f + RootlingEntity.this.field_5974.nextFloat() / 10.0f);
            }
        }

        public void method_6268() {
            super.method_6268();
            ++this.soundTime;
            if (this.soundTime > 100) {
                this.field_6391.method_5783(BMEffects.ROOTLING_AFRAID, 1.0f, 1.0f + RootlingEntity.this.field_5974.nextFloat() / 10.0f);
                this.soundTime = 0;
            }
        }
    }

    public class DanceGoal
    extends class_1352 {
        private RootlingEntity partner = null;
        private int timer;

        public DanceGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
        }

        public boolean method_6264() {
            if (RootlingEntity.this.forcedDancePartner != null) {
                this.partner = RootlingEntity.this.forcedDancePartner;
                RootlingEntity.this.forcedDancePartner = null;
                return true;
            }
            if (RootlingEntity.this.hasAction() || RootlingEntity.this.getActionCooldown() >= 0) {
                return false;
            }
            this.partner = this.findPartner();
            return this.partner != null;
        }

        public boolean method_6266() {
            return this.partner.method_5805() && this.partner.hasAction() && this.timer < MAX_DANCE_TIME;
        }

        public void method_6270() {
            this.partner = null;
            this.timer = 0;
            RootlingEntity.this.setHasAction(false);
            if (this.partner != null) {
                this.partner.setHasAction(false);
            }
        }

        public void method_6269() {
            RootlingEntity.this.setHasAction(true);
            this.partner.setHasAction(true);
            RootlingEntity.this.setActionCoolDown(MAX_ACTION_COOLDOWN);
        }

        private RootlingEntity findPartner() {
            List list = RootlingEntity.this.field_6002.method_18466(RootlingEntity.class, VALID_ROOTLING_PARTNER, (class_1309)RootlingEntity.this, RootlingEntity.this.method_5829().method_1014(8.0));
            double minDistance = Double.MAX_VALUE;
            RootlingEntity closestPossible = null;
            for (RootlingEntity rootlingEntity : list) {
                if (rootlingEntity.hasAction() || rootlingEntity.getActionCooldown() > 0 || !(RootlingEntity.this.method_5858((class_1297)rootlingEntity) < minDistance)) continue;
                closestPossible = rootlingEntity;
                minDistance = RootlingEntity.this.method_5858((class_1297)rootlingEntity);
            }
            if (closestPossible != null) {
                closestPossible.forcedDancePartner = RootlingEntity.this;
            }
            return closestPossible;
        }

        public void method_6268() {
            RootlingEntity.this.method_5988().method_6226((class_1297)this.partner, 10.0f, (float)RootlingEntity.this.method_5978());
            RootlingEntity.this.method_5942().method_6335((class_1297)this.partner, 1.0);
            ++this.timer;
            if (this.timer < MAX_DANCE_TIME && RootlingEntity.this.method_5858((class_1297)this.partner) < 9.0) {
                RootlingEntity.this.method_5993().method_6233();
            }
        }
    }

    public class FollowEntityGoal
    extends class_1352 {
        public class_1309 followPartner;
        private int timer = 0;

        public FollowEntityGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (RootlingEntity.this.hasAction() || RootlingEntity.this.getActionCooldown() >= 0 || RootlingEntity.this.field_5974.nextInt(10) != 0) {
                return false;
            }
            this.followPartner = this.findFollowPartner();
            return this.followPartner != null;
        }

        public boolean method_6266() {
            return this.followPartner.method_5805() && this.timer < MAX_FOLLOW_TIME;
        }

        public void method_6270() {
            this.followPartner = null;
            this.timer = 0;
            RootlingEntity.this.setHasAction(false);
        }

        public void method_6269() {
            RootlingEntity.this.setHasAction(true);
            RootlingEntity.this.setActionCoolDown(MAX_ACTION_COOLDOWN);
        }

        public void method_6268() {
            RootlingEntity.this.method_5988().method_6226((class_1297)this.followPartner, 10.0f, (float)RootlingEntity.this.method_5978());
            RootlingEntity.this.method_5942().method_6335((class_1297)this.followPartner, 1.0);
            if (RootlingEntity.this.method_5858((class_1297)this.followPartner) <= 4.0) {
                RootlingEntity.this.method_5942().method_6340();
            }
            ++this.timer;
        }

        private class_1309 findFollowPartner() {
            List list = RootlingEntity.this.field_6002.method_18466(class_1429.class, VALID_ROOTLING_PARTNER, (class_1309)RootlingEntity.this, RootlingEntity.this.method_5829().method_1014(8.0));
            double minDistance = Double.MAX_VALUE;
            class_1429 closestPossible = null;
            for (class_1429 e : list) {
                if (!(RootlingEntity.this.method_5858((class_1297)e) < minDistance) || e instanceof RootlingEntity) continue;
                closestPossible = e;
                minDistance = RootlingEntity.this.method_5858((class_1297)e);
            }
            return closestPossible;
        }
    }

    public class InspectFlowerGoal
    extends class_1352 {
        private class_2338 targetPos;
        private class_2680 targetState;
        private int timer;

        public InspectFlowerGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (RootlingEntity.this.field_5974.nextInt(10) == 0 || RootlingEntity.this.actionCooldown > 0 || RootlingEntity.this.hasAction()) {
                return false;
            }
            this.targetPos = this.findFlower();
            return this.targetPos != null;
        }

        public void method_6268() {
            ++this.timer;
            if (RootlingEntity.this.method_5649((float)this.targetPos.method_10263() + 0.5f, (float)this.targetPos.method_10264() + 0.5f, (float)this.targetPos.method_10260() + 0.5f) > 2.0) {
                RootlingEntity.this.method_5962().method_6239((double)((float)this.targetPos.method_10263() + 0.5f), (double)((float)this.targetPos.method_10264() + 0.5f), (double)((float)this.targetPos.method_10260() + 0.5f), (double)0.6f);
            }
            float targetY = this.targetPos.method_10264();
            if (this.targetState.method_26164((class_3494)class_3481.field_20338)) {
                targetY += 1.0f;
            }
            RootlingEntity.this.method_5988().method_20248((double)((float)this.targetPos.method_10263() + 0.5f), (double)targetY, (double)((float)this.targetPos.method_10260() + 0.5f));
        }

        public boolean method_6266() {
            class_2680 st = RootlingEntity.this.field_6002.method_8320(this.targetPos);
            if (st != this.targetState) {
                return false;
            }
            return this.timer <= MAX_INSPECT_TIME;
        }

        public void method_6270() {
            this.timer = 0;
            RootlingEntity.this.setHasAction(false);
        }

        public void method_6269() {
            RootlingEntity.this.setHasAction(true);
            RootlingEntity.this.setActionCoolDown(MAX_ACTION_COOLDOWN);
        }

        private class_2338 findFlower() {
            class_2338 startPos = RootlingEntity.this.method_23312();
            ArrayList spots = Lists.newArrayList();
            class_2338.class_2339 m = new class_2338.class_2339(startPos.method_10263(), startPos.method_10264(), startPos.method_10260());
            for (int x = startPos.method_10263() - 2; x < startPos.method_10263() + 2; ++x) {
                for (int z = startPos.method_10260() - 2; z < startPos.method_10260() + 2; ++z) {
                    m.method_10103(x, startPos.method_10264(), z);
                    class_2680 checkState = RootlingEntity.this.field_6002.method_8320((class_2338)m);
                    if (!checkState.method_26164((class_3494)class_3481.field_20339)) continue;
                    spots.add(new class_2338(m.method_10263(), m.method_10264(), m.method_10260()));
                }
            }
            if (spots.isEmpty()) {
                return null;
            }
            class_2338 pos = (class_2338)spots.get(RootlingEntity.this.field_6002.field_9229.nextInt(spots.size()));
            if (pos != null) {
                this.targetState = RootlingEntity.this.field_6002.method_8320(pos);
            }
            return pos;
        }
    }
}

