/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity;

import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1331;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1366;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5531;
import net.minecraft.class_7;
import party.lemons.biomemakeover.entity.OwlEntity;
import party.lemons.biomemakeover.entity.ai.FlyWanderGoal;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEffects;

public class MothEntity
extends class_1588 {
    private static final class_2940<Boolean> TARGETING = class_2945.method_12791(MothEntity.class, (class_2941)class_2943.field_13323);
    public boolean hasPlayedLoop = false;
    private float currentPitch;
    private float lastPitch;
    private AttractLightGoal attractLightGoal;
    private MoveToLightGoal moveToLightGoal;
    private class_2338 attactPos;

    public MothEntity(class_1299<? extends class_1588> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6207 = new class_1331((class_1308)this, 20, true);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
        this.method_5941(class_7.field_21516, -1.0f);
        this.method_5941(class_7.field_10, -1.0f);
    }

    protected void method_5959() {
        this.attractLightGoal = new AttractLightGoal();
        this.moveToLightGoal = new MoveToLightGoal();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1366((class_1314)this, 1.0, false));
        this.field_6201.method_6277(2, (class_1352)new class_1338((class_1314)this, OwlEntity.class, 6.0f, 1.0, 1.2));
        this.field_6201.method_6277(3, (class_1352)this.attractLightGoal);
        this.field_6201.method_6277(4, (class_1352)this.moveToLightGoal);
        this.field_6201.method_6277(5, (class_1352)new FlyWanderGoal((class_1314)this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(TARGETING, (Object)false);
    }

    public static class_5132.class_5133 createAttributes() {
        return MothEntity.method_26918().method_26868(class_5134.field_23720, 0.6).method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, 0.25);
    }

    public float method_6144(class_2338 blockPos, class_4538 levelReader) {
        if (levelReader.method_8320(blockPos).method_26215()) {
            return 10.0f + (float)levelReader.method_8317(blockPos);
        }
        return super.method_6144(blockPos, levelReader);
    }

    public float method_6024(float delta) {
        return class_3532.method_16439((float)delta, (float)this.lastPitch, (float)this.currentPitch);
    }

    private void updateBodyPitch() {
        this.lastPitch = this.currentPitch;
        this.currentPitch = this.isNearTarget() ? Math.min(1.0f, this.currentPitch + 0.2f) : Math.max((float)Math.sin((float)this.field_6012 / 10.0f) / 10.0f, this.currentPitch - 0.24f);
    }

    public static boolean checkSpawnRules(class_1299<? extends MothEntity> entityType, class_5425 levelAccessor, class_3730 mobSpawnType, class_2338 pos, Random random) {
        return levelAccessor.method_8407() != class_1267.field_5801 && class_1588.method_20679((class_5425)levelAccessor, (class_2338)pos, (Random)random) && (mobSpawnType == class_3730.field_16469 || levelAccessor.method_8320(pos.method_10074()).method_26164((class_3494)class_3481.field_15503));
    }

    protected class_1408 method_5965(class_1937 level) {
        class_1407 birdNavigation = new class_1407((class_1308)this, level){

            public boolean method_6333(class_2338 blockPos) {
                return !this.field_6677.method_8320(blockPos.method_10074()).method_26215();
            }

            public void method_6360() {
                if (!MothEntity.this.attractLightGoal.isRunning()) {
                    super.method_6360();
                }
            }
        };
        birdNavigation.method_6331(false);
        birdNavigation.method_6354(false);
        birdNavigation.method_6332(false);
        return birdNavigation;
    }

    private boolean isAttractive(class_2338 pos) {
        return this.field_6002.method_8477(pos) && this.field_6002.method_8320(pos).method_26213() > 10 || this.field_6002.method_8320(pos).method_26164(BMBlocks.MOTH_ATTRACTIVE);
    }

    protected float method_23326() {
        class_2680 state = this.method_25936();
        class_2248 block = state.method_26204();
        float mult = state.method_26164(BMBlocks.ITCHING_IVY_TAG) ? 1.0f : block.method_23349();
        if (block != class_2246.field_10382 && block != class_2246.field_10422) {
            if (mult == 1.0f) {
                class_2680 velBlock = this.field_6002.method_8320(this.method_23314());
                if (!velBlock.method_26164(BMBlocks.ITCHING_IVY_TAG)) {
                    return velBlock.method_26204().method_23349();
                }
                return mult;
            }
            return mult;
        }
        return mult;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
    }

    protected class_3414 method_5994() {
        return BMEffects.MOTH_IDLE;
    }

    public boolean method_5747(float f, float g, class_1282 damageSource) {
        return false;
    }

    protected void method_5623(double d, boolean bl, class_2680 blockState, class_2338 blockPos) {
    }

    protected boolean method_5776() {
        return true;
    }

    public class_1310 method_6046() {
        return class_1310.field_6293;
    }

    public void method_5773() {
        super.method_5773();
        this.updateBodyPitch();
    }

    private boolean isNearTarget() {
        return false;
    }

    public boolean isTargeting() {
        return (Boolean)this.method_5841().method_12789(TARGETING);
    }

    private boolean closerThan(class_2338 pos, int distance) {
        return pos.method_19771((class_2382)this.method_23312(), (double)distance);
    }

    private boolean isTooFar(class_2338 pos) {
        return !this.closerThan(pos, 32);
    }

    private void startMovingTo(class_2338 pos) {
        class_243 vec32;
        class_243 vec3 = class_243.method_24955((class_2382)this.method_23312());
        int i = 0;
        class_2338 blockPos2 = this.method_24515();
        int j = (int)vec3.field_1351 - blockPos2.method_10264();
        if (j > 2) {
            i = 4;
        } else if (j < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int m = blockPos2.method_19455((class_2382)this.method_23312());
        if (m < 15) {
            k = m / 2;
            l = m / 2;
        }
        if ((vec32 = class_5531.method_31508((class_1314)this, (int)k, (int)l, (int)i, (class_243)vec3, (double)0.3141592741012573)) == null) {
            return;
        }
        this.field_6189.method_23964(0.5f);
        this.field_6189.method_6337(vec32.field_1352, vec32.field_1351, vec32.field_1350, 1.0);
    }

    protected class_3414 method_6002() {
        return BMEffects.MOTH_DEATH;
    }

    protected class_3414 method_6011(class_1282 source) {
        return BMEffects.MOTH_HURT;
    }

    public boolean method_6121(class_1297 entity) {
        boolean attacked = super.method_6121((class_1297)this.method_5968());
        if (attacked) {
            this.method_5783(BMEffects.MOTH_BITE, 1.0f, 1.0f);
        }
        return attacked;
    }

    private class AttractLightGoal
    extends NotAttackingGoal {
        private int attractTicks;
        private int lastAttractTick;
        private boolean running;
        private class_243 nextTarget;
        private int ticks;

        AttractLightGoal() {
            this.attractTicks = 0;
            this.lastAttractTick = 0;
            this.ticks = 0;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        @Override
        public boolean canMothStart() {
            if (MothEntity.this.field_6002.method_8419()) {
                return false;
            }
            if (MothEntity.this.field_5974.nextFloat() < 0.7f) {
                return false;
            }
            Optional<class_2338> optional = this.findLight();
            if (optional.isPresent()) {
                MothEntity.this.attactPos = optional.get();
                MothEntity.this.field_6189.method_6337((double)MothEntity.this.attactPos.method_10263() + 0.5, (double)MothEntity.this.attactPos.method_10264() + 1.25, (double)MothEntity.this.attactPos.method_10260() + 0.5, (double)1.2f);
                return true;
            }
            return false;
        }

        @Override
        public boolean canMothContinue() {
            if (!this.running) {
                return false;
            }
            if (MothEntity.this.attactPos == null) {
                return false;
            }
            if (MothEntity.this.field_6002.method_8419()) {
                return false;
            }
            if (this.completedAttract()) {
                return MothEntity.this.field_5974.nextFloat() < 0.2f;
            }
            if (MothEntity.this.field_6012 % 20 == 0 && !MothEntity.this.isAttractive(MothEntity.this.attactPos)) {
                MothEntity.this.attactPos = null;
                return false;
            }
            if (MothEntity.this.attactPos != null && (double)MothEntity.this.attactPos.method_10264() < MothEntity.this.method_23318() && !MothEntity.this.closerThan(MothEntity.this.attactPos, 1) && MothEntity.this.field_6002.method_8320(MothEntity.this.method_23312().method_10074()).method_26225()) {
                MothEntity.this.attactPos = null;
                return false;
            }
            return true;
        }

        private boolean completedAttract() {
            return this.attractTicks > 400;
        }

        private boolean isRunning() {
            return this.running;
        }

        private void cancel() {
            this.running = false;
        }

        public void method_6269() {
            this.attractTicks = 0;
            this.ticks = 0;
            this.lastAttractTick = 0;
            this.running = true;
        }

        public void method_6270() {
            this.running = false;
            MothEntity.this.field_6189.method_6340();
        }

        public void method_6268() {
            ++this.ticks;
            if (this.ticks > 600) {
                MothEntity.this.attactPos = null;
            } else {
                class_2338 pos;
                class_243 onVec;
                class_243 centerTarget = class_243.method_24955((class_2382)MothEntity.this.attactPos);
                centerTarget = MothEntity.this.method_23318() < centerTarget.field_1351 ? centerTarget.method_1031(0.0, -1.25, 0.0) : centerTarget.method_1031(0.0, 1.25, 0.0);
                if (centerTarget.method_1022(onVec = new class_243((double)(pos = MothEntity.this.method_23312()).method_10263(), (double)pos.method_10264(), (double)pos.method_10260())) > 1.0) {
                    this.nextTarget = centerTarget;
                    this.moveToNextTarget();
                } else {
                    if (this.nextTarget == null) {
                        this.nextTarget = centerTarget;
                    }
                    boolean isClose = onVec.method_1022(this.nextTarget) <= 0.1;
                    boolean hasFinished = true;
                    if (!isClose && this.ticks > 600) {
                        MothEntity.this.attactPos = null;
                    } else {
                        if (isClose) {
                            boolean getNewTarget;
                            boolean bl = getNewTarget = MothEntity.this.field_5974.nextInt(25) == 0;
                            if (getNewTarget) {
                                this.nextTarget = new class_243(centerTarget.method_10216() + (double)this.getRandomOffset(), centerTarget.method_10214(), centerTarget.method_10215() + (double)this.getRandomOffset());
                                MothEntity.this.field_6189.method_6340();
                            } else {
                                hasFinished = false;
                            }
                            MothEntity.this.method_5988().method_20248(centerTarget.method_10216(), centerTarget.method_10214(), centerTarget.method_10215());
                        }
                        if (hasFinished) {
                            this.moveToNextTarget();
                        }
                        ++this.attractTicks;
                        if (MothEntity.this.field_5974.nextFloat() < 0.05f && this.attractTicks > this.lastAttractTick + 60) {
                            this.lastAttractTick = this.attractTicks;
                        }
                    }
                }
            }
        }

        private void moveToNextTarget() {
            MothEntity.this.method_5962().method_6239(this.nextTarget.method_10216(), this.nextTarget.method_10214(), this.nextTarget.method_10215(), (double)0.35f);
        }

        private float getRandomOffset() {
            return (MothEntity.this.field_5974.nextFloat() * 2.0f - 1.0f) * 0.33333334f;
        }

        private Optional<class_2338> findLight() {
            return this.findLight(5.0);
        }

        private Optional<class_2338> findLight(double searchDistance) {
            class_2338 blockPos = MothEntity.this.method_23312();
            class_2338.class_2339 mutable = new class_2338.class_2339();
            int y = 0;
            while ((double)y <= searchDistance) {
                int j = 0;
                while ((double)j < searchDistance) {
                    int x = 0;
                    while (x <= j) {
                        int z;
                        int n = z = x < j && x > -j ? j : 0;
                        while (z <= j) {
                            mutable.method_25504((class_2382)blockPos, x, y - 1, z);
                            if (blockPos.method_19771((class_2382)mutable, searchDistance) && MothEntity.this.isAttractive((class_2338)mutable)) {
                                return Optional.of(mutable);
                            }
                            z = z > 0 ? -z : 1 - z;
                        }
                        x = x > 0 ? -x : 1 - x;
                    }
                    ++j;
                }
                y = y > 0 ? -y : 1 - y;
            }
            return Optional.empty();
        }
    }

    public class MoveToLightGoal
    extends NotAttackingGoal {
        private int ticks;

        MoveToLightGoal() {
            this.ticks = MothEntity.this.field_6002.field_9229.nextInt(10);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        @Override
        public boolean canMothContinue() {
            return MothEntity.this.attactPos != null && !MothEntity.this.method_18410() && MothEntity.this.isAttractive(MothEntity.this.attactPos) && !MothEntity.this.closerThan(MothEntity.this.attactPos, 2);
        }

        @Override
        public boolean canMothStart() {
            return this.canMothContinue();
        }

        public void method_6269() {
            this.ticks = 0;
            super.method_6269();
        }

        public void method_6270() {
            this.ticks = 0;
            MothEntity.this.field_6189.method_6340();
            MothEntity.this.field_6189.method_23965();
        }

        public void method_6268() {
            if (MothEntity.this.attactPos != null) {
                ++this.ticks;
                if (this.ticks > 600) {
                    MothEntity.this.attactPos = null;
                } else if (!MothEntity.this.field_6189.method_23966()) {
                    if (MothEntity.this.isTooFar(MothEntity.this.attactPos)) {
                        MothEntity.this.attactPos = null;
                    } else {
                        MothEntity.this.startMovingTo(MothEntity.this.attactPos);
                    }
                }
            }
        }
    }

    private abstract class NotAttackingGoal
    extends class_1352 {
        private NotAttackingGoal() {
        }

        public abstract boolean canMothContinue();

        public abstract boolean canMothStart();

        public boolean method_6264() {
            return this.canMothStart() && !MothEntity.this.isTargeting();
        }

        public boolean method_6266() {
            return this.canMothContinue() && !MothEntity.this.isTargeting();
        }
    }
}

