/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1331;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1432;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5328;
import net.minecraft.class_5425;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.entity.ToadTargetEntity;
import party.lemons.biomemakeover.entity.ai.FlyWanderGoal;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.init.BMItems;
import party.lemons.biomemakeover.util.NetworkUtil;

public class LightningBugEntity
extends ToadTargetEntity
implements class_1432 {
    private LightningBugEntity leader;
    private int groupSize = 1;
    public float scale = this.field_5974.nextFloat();
    public float prevRed = -1.0f;
    public float prevGreen = -1.0f;
    public float prevBlue = -1.0f;
    private boolean isAlternate = false;

    public LightningBugEntity(class_1299<? extends LightningBugEntity> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6207 = new class_1331((class_1308)this, 20, true);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
        this.method_5941(class_7.field_21516, -1.0f);
        this.method_5941(class_7.field_10, -1.0f);
        this.field_6012 += level.field_9229.nextInt(10000);
    }

    public LightningBugEntity(class_1937 level, boolean isAlternate) {
        this((class_1299<? extends LightningBugEntity>)BMEntities.LIGHTNING_BUG_ALTERNATE, level);
        this.isAlternate = true;
    }

    public static class_5132.class_5133 createAttributes() {
        return LightningBugEntity.method_26828().method_26868(class_5134.field_23720, 0.6).method_26868(class_5134.field_23716, 3.0).method_26868(class_5134.field_23719, 0.25);
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 heldStack = player.method_5998(hand);
        if (!(heldStack.method_7960() || heldStack.method_7909() != class_1802.field_8469 && heldStack.method_7909() != class_1802.field_8287)) {
            if (!this.field_6002.method_8608()) {
                class_1799 result = class_5328.method_30012((class_1799)heldStack, (class_1657)player, (class_1799)new class_1799((class_1935)(heldStack.method_7909() == class_1802.field_8469 ? BMBlocks.LIGHTNING_BUG_BOTTLE : BMItems.LIGHTNING_BOTTLE)));
                player.method_6122(hand, result);
                this.method_5650(class_1297.class_5529.field_26999);
                player.method_5783(class_3417.field_14779, 1.0f, 1.0f);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public void method_5670() {
        if (this.field_5953 && !this.isAlternate) {
            for (int i = 0; i < this.field_5974.nextInt(5); ++i) {
                LightningBugEntity alternate = (LightningBugEntity)BMEntities.LIGHTNING_BUG_ALTERNATE.method_5883(this.field_6002);
                alternate.isAlternate = true;
                alternate.method_24203(this.method_23317(), this.method_23318(), this.method_23321());
                this.field_6002.method_8649((class_1297)alternate);
            }
        }
        super.method_5670();
    }

    public float method_6144(class_2338 blockPos, class_4538 levelReader) {
        return levelReader.method_8320(blockPos).method_26215() ? 10.0f : 0.0f;
    }

    protected void method_5959() {
        this.field_6201.method_6277(8, (class_1352)new FlyWanderGoal(this));
        this.field_6201.method_6277(9, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(5, (class_1352)new FollowGroupLeaderGoal(this));
    }

    public boolean method_5747(float f, float g, class_1282 damageSource) {
        return false;
    }

    protected void method_5623(double d, boolean bl, class_2680 blockState, class_2338 blockPos) {
    }

    protected class_1408 method_5965(class_1937 level) {
        class_1407 birdNavigation = new class_1407((class_1308)this, level){

            public boolean method_6333(class_2338 blockPos) {
                return !this.field_6677.method_8320(blockPos.method_10074()).method_26215();
            }
        };
        birdNavigation.method_6331(true);
        birdNavigation.method_6354(false);
        birdNavigation.method_6332(false);
        return birdNavigation;
    }

    public boolean hasLeader() {
        return this.leader != null && this.leader.method_5805();
    }

    protected void method_5712(class_2338 blockPos, class_2680 blockState) {
    }

    public LightningBugEntity joinGroupOf(LightningBugEntity groupLeader) {
        this.leader = groupLeader;
        groupLeader.increaseGroupSize();
        return groupLeader;
    }

    public void leaveGroup() {
        this.leader.decreaseGroupSize();
        this.leader = null;
    }

    private void increaseGroupSize() {
        ++this.groupSize;
    }

    private void decreaseGroupSize() {
        --this.groupSize;
    }

    public boolean canHaveMoreInGroup() {
        return this.hasOthersInGroup() && this.groupSize < this.getMaxGroupSize();
    }

    public boolean hasOthersInGroup() {
        return this.groupSize > 1;
    }

    public boolean isCloseEnoughToLeader() {
        return this.method_5858((class_1297)this.leader) <= 121.0;
    }

    public void method_5773() {
        List list;
        super.method_5773();
        if (this.hasOthersInGroup() && this.field_6002.field_9229.nextInt(200) == 1 && (list = this.field_6002.method_18467(LightningBugEntity.class, this.method_5829().method_1009(8.0, 8.0, 8.0))).size() <= 1) {
            this.groupSize = 1;
        }
    }

    public int getMaxGroupSize() {
        return super.method_5945();
    }

    public int method_5945() {
        return this.getMaxGroupSize();
    }

    public void method_6007() {
        super.method_6007();
        if (this.field_5974.nextInt(200) == 0) {
            NetworkUtil.doLightningEntity(this.field_6002, (class_1309)this, 2);
        }
    }

    public void moveTowardLeader() {
        if (this.hasLeader()) {
            this.method_5942().method_6335((class_1297)this.leader, 1.0);
        }
    }

    public void pullInOthers(Stream<LightningBugEntity> fish) {
        fish.limit(this.getMaxGroupSize() - this.groupSize).filter(e -> e != this).forEach(e -> e.joinGroupOf(this));
    }

    @Nullable
    public class_1315 method_5943(class_5425 serverLevelAccessor, class_1266 difficultyInstance, class_3730 mobSpawnType, @Nullable class_1315 spawnGroupData, @Nullable class_2487 compoundTag) {
        if ((spawnGroupData = super.method_5943(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag)) == null) {
            spawnGroupData = new GroupInfo(this);
        } else {
            this.joinGroupOf(((GroupInfo)spawnGroupData).leader);
        }
        return spawnGroupData;
    }

    public boolean method_6581() {
        return true;
    }

    public static boolean checkSpawnRules(class_1299<? extends LightningBugEntity> entityType, class_1936 levelAccessor, class_3730 mobSpawnType, class_2338 blockPos, Random random) {
        return levelAccessor.method_8320(blockPos.method_10074()).method_26164((class_3494)class_3481.field_35567) && levelAccessor.method_22335(blockPos, 0) > 8;
    }

    private static class FollowGroupLeaderGoal
    extends class_1352 {
        private final LightningBugEntity entity;
        private int moveDelay;
        private int checkSurroundingDelay;

        public FollowGroupLeaderGoal(LightningBugEntity entity) {
            this.entity = entity;
            this.checkSurroundingDelay = this.getSurroundingSearchDelay(entity);
        }

        protected int getSurroundingSearchDelay(LightningBugEntity entity) {
            return 200 + entity.method_6051().nextInt(200) % 20;
        }

        public boolean method_6264() {
            if (this.entity.hasOthersInGroup()) {
                return false;
            }
            if (this.entity.hasLeader()) {
                return true;
            }
            if (this.checkSurroundingDelay > 0) {
                --this.checkSurroundingDelay;
                return false;
            }
            this.checkSurroundingDelay = this.getSurroundingSearchDelay(this.entity);
            Predicate<LightningBugEntity> predicate = e -> e.canHaveMoreInGroup() || !e.hasLeader();
            List list = this.entity.field_6002.method_8390(LightningBugEntity.class, this.entity.method_5829().method_1009(8.0, 8.0, 8.0), predicate);
            LightningBugEntity e2 = list.stream().filter(LightningBugEntity::canHaveMoreInGroup).findAny().orElse(this.entity);
            e2.pullInOthers(list.stream().filter(lnb -> !lnb.hasLeader()));
            return this.entity.hasLeader();
        }

        public boolean method_6266() {
            return this.entity.hasLeader() && this.entity.isCloseEnoughToLeader();
        }

        public void method_6269() {
            this.moveDelay = 0;
        }

        public void method_6270() {
            this.entity.leaveGroup();
        }

        public void method_6268() {
            if (--this.moveDelay <= 0) {
                this.moveDelay = 10;
                this.entity.moveTowardLeader();
            }
        }
    }

    public record GroupInfo(LightningBugEntity leader) implements class_1315
    {
    }
}

