/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity;

import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1335;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4802;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_6019;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.level.PoltergeistHandler;

public class GhostEntity
extends class_1588
implements class_5354 {
    private static final class_2940<Boolean> IsCharging = class_2945.method_12791(GhostEntity.class, (class_2941)class_2943.field_13323);
    private static final class_6019 WANDER_RANGE_HORIZONTAL = class_6019.method_35017((int)-7, (int)7);
    private static final class_6019 WANDER_RANGE_VERTICAL = class_6019.method_35017((int)-5, (int)5);
    private static final double CHARGE_MIN_DISTANCE = 2.0;
    private static final double CHARGE_MAX_DISTANCE = 10.0;
    private static final int POLTERGEIST_RANGE = 10;
    private static final class_6019 ANGER_TIME_RANGE = class_4802.method_24505((int)20, (int)39);
    private int angerTime;
    private UUID targetUuid;
    private static final class_6019 REINFORCE_TIME_RANGE = class_4802.method_24505((int)4, (int)6);
    private int reinforceTime;
    private static final class_6019 ANGER_SOUND_TIME_RANGE = class_4802.method_24505((int)0, (int)1);
    private int angrySoundDelay;
    private class_2338 homePosition;

    public GhostEntity(class_1299<? extends class_1588> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6207 = new GhostMoveControl(this);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new PoltergeistGoal());
        this.field_6201.method_6277(4, (class_1352)new ChargeTargetGoal());
        this.field_6201.method_6277(8, (class_1352)new FlyAroundGoal());
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 3.0f, 1.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1308.class, 8.0f));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, arg_0 -> ((GhostEntity)this).method_29515(arg_0)));
        this.field_6185.method_6277(3, (class_1352)new class_5398((class_1308)this, true));
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(IsCharging, (Object)false);
    }

    public void method_5784(class_1313 moverType, class_243 vec3) {
        super.method_5784(moverType, vec3);
        this.method_5852();
    }

    public class_1310 method_6046() {
        return class_1310.field_6289;
    }

    public void method_5773() {
        this.field_5960 = true;
        super.method_5773();
        this.field_5960 = false;
        this.method_5875(true);
        if (this.getHomePosition() == null) {
            this.homePosition = this.method_23312();
        }
    }

    private class_2338 getHomePosition() {
        return this.homePosition;
    }

    protected void method_5958() {
        if (this.method_29511()) {
            this.maybePlayFirstAngerSound();
        }
        this.method_29510((class_3218)this.field_6002, true);
        if (this.method_5968() != null) {
            this.checkAlertTime();
        }
        super.method_5958();
    }

    private void checkAlertTime() {
        if (this.reinforceTime > 0) {
            --this.reinforceTime;
        } else {
            if (this.method_5985().method_6369((class_1297)this.method_5968())) {
                this.alertNearby();
            }
            this.reinforceTime = REINFORCE_TIME_RANGE.method_35008(this.field_5974);
        }
    }

    private void maybePlayFirstAngerSound() {
        if (this.angrySoundDelay > 0) {
            --this.angrySoundDelay;
            if (this.angrySoundDelay == 0) {
                this.playAngerSound();
            }
        }
    }

    private void alertNearby() {
        double alertRange = this.method_26825(class_5134.field_23717);
        class_2338 pos = this.method_23312();
        class_238 alertBounds = class_238.method_29968((class_243)new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260())).method_1009(alertRange, 10.0, alertRange);
        this.field_6002.method_18467(GhostEntity.class, alertBounds).stream().filter(e -> e != this).filter(e -> e.method_5968() == null).filter(e -> this.method_5968() != null && !e.method_5722((class_1297)this.method_5968())).forEach(e -> e.method_5980(this.method_5968()));
    }

    public void method_5980(@Nullable class_1309 target) {
        if (this.method_5968() == null && target != null) {
            this.angrySoundDelay = ANGER_SOUND_TIME_RANGE.method_35008(this.field_5974);
            this.reinforceTime = REINFORCE_TIME_RANGE.method_35008(this.field_5974);
        }
        if (target instanceof class_1657) {
            class_1657 player = (class_1657)target;
            this.method_29505(player);
        }
        super.method_5980(target);
    }

    private void playAngerSound() {
        this.method_5783(BMEffects.GHOST_ANGRY, this.method_6107() * 2.0f, this.method_6017());
    }

    public void chooseRandomAngerTime() {
        this.method_29514(ANGER_TIME_RANGE.method_35008(this.field_5974));
    }

    public int method_29507() {
        return this.angerTime;
    }

    public void method_29514(int i) {
        this.angerTime = i;
    }

    @Nullable
    public UUID method_29508() {
        return this.targetUuid;
    }

    public void method_29513(@Nullable UUID uUID) {
        this.targetUuid = uUID;
    }

    public void method_29509() {
        this.chooseRandomAngerTime();
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        this.method_29517(compoundTag);
        if (this.getHomePosition() != null) {
            compoundTag.method_10569("HomeX", this.homePosition.method_10263());
            compoundTag.method_10569("HomeY", this.homePosition.method_10264());
            compoundTag.method_10569("HomeZ", this.homePosition.method_10260());
        }
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.method_29512(this.field_6002, tag);
        if (tag.method_10545("HomeX")) {
            this.homePosition = new class_2338(tag.method_10550("HomeX"), tag.method_10550("HomeY"), tag.method_10550("HomeZ"));
        }
    }

    public boolean method_5679(class_1282 damageSource) {
        if (damageSource == class_1282.field_5863 || damageSource == class_1282.field_5855 || damageSource == class_1282.field_5848 || damageSource == class_1282.field_5859 || damageSource == class_1282.field_16992 || damageSource == class_1282.field_5858 || damageSource == class_1282.field_5843 || damageSource == class_1282.field_5847 || damageSource == class_1282.field_5868 || damageSource == class_1282.field_5865) {
            return true;
        }
        return super.method_5679(damageSource);
    }

    public int method_5945() {
        return 1;
    }

    @Nullable
    protected class_3414 method_5994() {
        return this.method_29511() ? BMEffects.GHOST_ANGRY : BMEffects.GHOST_IDLE;
    }

    protected class_3414 method_6002() {
        return BMEffects.GHOST_DEATH;
    }

    private void setCharging(boolean charging) {
        this.method_5841().method_12778(IsCharging, (Object)charging);
    }

    public boolean isCharging() {
        return (Boolean)this.method_5841().method_12789(IsCharging);
    }

    class GhostMoveControl
    extends class_1335 {
        private GhostMoveControl(GhostEntity owner) {
            super((class_1308)owner);
        }

        public void method_6240() {
            if (this.field_6374 == class_1335.class_1336.field_6378) {
                class_243 targetPosition = new class_243(this.field_6370 - GhostEntity.this.method_23317(), this.field_6369 - GhostEntity.this.method_23318(), this.field_6367 - GhostEntity.this.method_23321());
                double length = targetPosition.method_1033();
                if (length < GhostEntity.this.method_5829().method_995()) {
                    this.field_6374 = class_1335.class_1336.field_6377;
                    GhostEntity.this.method_18799(GhostEntity.this.method_18798().method_1021(0.5));
                } else {
                    GhostEntity.this.method_18799(GhostEntity.this.method_18798().method_1019(targetPosition.method_1021(this.field_6372 * 0.05 / length)));
                    if (GhostEntity.this.method_5968() == null) {
                        if (class_1301.field_6156.test(GhostEntity.this.method_5968())) {
                            GhostEntity.this.method_5980(null);
                        }
                        class_243 vec3d2 = GhostEntity.this.method_18798();
                        GhostEntity.this.method_36456(-((float)class_3532.method_15349((double)vec3d2.field_1352, (double)vec3d2.field_1350)) * 57.295776f);
                        GhostEntity.this.field_6283 = GhostEntity.this.method_36454();
                    } else {
                        double e = GhostEntity.this.method_5968().method_23317() - GhostEntity.this.method_23317();
                        double f = GhostEntity.this.method_5968().method_23321() - GhostEntity.this.method_23321();
                        GhostEntity.this.method_36456(-((float)class_3532.method_15349((double)e, (double)f)) * 57.295776f);
                        GhostEntity.this.field_6283 = GhostEntity.this.method_36454();
                    }
                }
            }
        }
    }

    private class PoltergeistGoal
    extends class_1352 {
        private PoltergeistGoal() {
        }

        public void method_6268() {
            for (int i = 0; i < 4; ++i) {
                PoltergeistHandler.doPoltergeist(GhostEntity.this.field_6002, GhostEntity.this.method_23312(), 10);
            }
            super.method_6268();
        }

        public boolean method_6264() {
            return true;
        }

        public boolean method_6266() {
            return false;
        }
    }

    class ChargeTargetGoal
    extends class_1352 {
        private ChargeTargetGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (GhostEntity.this.method_5968() != null && !GhostEntity.this.method_5962().method_6241() && GhostEntity.this.field_5974.nextInt(2) == 0) {
                return GhostEntity.this.method_5858((class_1297)GhostEntity.this.method_5968()) > 2.0;
            }
            return false;
        }

        public boolean method_6266() {
            return GhostEntity.this.method_5962().method_6241() && GhostEntity.this.isCharging() && GhostEntity.this.method_5968() != null && GhostEntity.this.method_5968().method_5805();
        }

        public void method_6269() {
            class_1309 target = GhostEntity.this.method_5968();
            class_243 targetPosition = target.method_5836(1.0f);
            GhostEntity.this.field_6207.method_6239(targetPosition.field_1352, targetPosition.field_1351, targetPosition.field_1350, 1.25);
            GhostEntity.this.setCharging(true);
            GhostEntity.this.method_5783(BMEffects.GHOST_CHARGE, 1.0f, 1.0f);
        }

        public void method_6270() {
            GhostEntity.this.setCharging(false);
        }

        public void method_6268() {
            class_1309 target = GhostEntity.this.method_5968();
            if (class_1301.field_6156.test(target)) {
                GhostEntity.this.method_5980(null);
            }
            if (GhostEntity.this.method_5829().method_1014(2.0).method_994(target.method_5829())) {
                GhostEntity.this.method_6121((class_1297)target);
                GhostEntity.this.setCharging(false);
            } else {
                double distance = GhostEntity.this.method_5858((class_1297)target);
                if (distance < 10.0) {
                    class_243 vec3d = target.method_5836(1.0f);
                    GhostEntity.this.field_6207.method_6239(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, 1.0);
                }
            }
        }
    }

    class FlyAroundGoal
    extends class_1352 {
        private FlyAroundGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return !GhostEntity.this.method_5962().method_6241() && GhostEntity.this.field_5974.nextInt(2) == 0;
        }

        public boolean method_6266() {
            return false;
        }

        public void method_6268() {
            if (GhostEntity.this.getHomePosition() == null) {
                GhostEntity.this.homePosition = GhostEntity.this.method_23312();
            }
            for (int i = 0; i < 3; ++i) {
                class_2338 randomTarget = GhostEntity.this.homePosition.method_10069(WANDER_RANGE_HORIZONTAL.method_35008(GhostEntity.this.field_5974), WANDER_RANGE_VERTICAL.method_35008(GhostEntity.this.field_5974), WANDER_RANGE_HORIZONTAL.method_35008(GhostEntity.this.field_5974));
                if (!GhostEntity.this.field_6002.method_22347(randomTarget)) continue;
                GhostEntity.this.field_6207.method_6239((double)randomTarget.method_10263() + 0.5, (double)randomTarget.method_10264() + 0.5, (double)randomTarget.method_10260() + 0.5, 0.25);
                if (GhostEntity.this.method_5968() != null) break;
                GhostEntity.this.method_5988().method_6230((double)randomTarget.method_10263() + 0.5, (double)randomTarget.method_10264() + 0.5, (double)randomTarget.method_10260() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }
}

