/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.crafting.witch;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_3222;
import net.minecraft.class_6032;
import party.lemons.biomemakeover.crafting.witch.QuestCategory;
import party.lemons.biomemakeover.crafting.witch.QuestItem;
import party.lemons.biomemakeover.crafting.witch.QuestRarity;
import party.lemons.biomemakeover.crafting.witch.WitchQuest;
import party.lemons.biomemakeover.crafting.witch.WitchQuestList;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMItems;
import party.lemons.biomemakeover.network.S2C_HandleWitchQuests;

public class WitchQuestHandler {
    private static final Map<QuestCategory, List<QuestItem>> QUEST_ITEMS = Maps.newHashMap();
    private static final class_6032<Integer> ITEM_COUNT_SELECTOR = new class_6032();

    public static void init() {
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((class_1935)BMItems.GLOWFISH, 10.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((class_1935)BMBlocks.GLOWSHROOM_STEM, 10.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((class_1935)BMBlocks.GREEN_GLOWSHROOM_BLOCK, 10.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((class_1935)BMBlocks.ORANGE_GLOWSHROOM_BLOCK, 13.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((class_1935)BMBlocks.PURPLE_GLOWSHROOM_BLOCK, 10.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((class_1935)BMBlocks.GREEN_GLOWSHROOM, 5.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((class_1935)BMBlocks.ORANGE_GLOWSHROOM, 8.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((class_1935)BMBlocks.PURPLE_GLOWSHROOM, 5.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((class_1935)BMBlocks.MYCELIUM_ROOTS, 3.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((class_1935)BMBlocks.MYCELIUM_SPROUTS, 3.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((class_1935)BMBlocks.TALL_BROWN_MUSHROOM, 5.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((class_1935)BMBlocks.TALL_RED_MUSHROOM, 5.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((class_1935)class_2246.field_10402, 10.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.MUSHROOM, QuestItem.of((class_1935)BMItems.BLIGHTBAT_WING, 5.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.MESA, QuestItem.of((class_1935)BMItems.SCUTTLER_TAIL, 5.0f, 5));
        WitchQuestHandler.addQuestItem(QuestCategory.MESA, QuestItem.of((class_1935)BMItems.ECTOPLASM, 8.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.MESA, QuestItem.of((class_1935)BMItems.PINK_PETALS, 12.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.MESA, QuestItem.of((class_1935)BMBlocks.SAGUARO_CACTUS, 1.0f, 10));
        WitchQuestHandler.addQuestItem(QuestCategory.DARK_FOREST, QuestItem.of((class_1935)BMItems.MOTH_SCALES, 5.0f, 6));
        WitchQuestHandler.addQuestItem(QuestCategory.DARK_FOREST, QuestItem.of((class_1935)BMItems.BULBUS_ROOT, 5.0f, 5));
        WitchQuestHandler.addQuestItem(QuestCategory.DARK_FOREST, QuestItem.of((class_1935)BMItems.ILLUNITE_SHARD, 10.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.DARK_FOREST, QuestItem.of((class_1935)BMBlocks.IVY, 3.0f, 10));
        WitchQuestHandler.addQuestItem(QuestCategory.DARK_FOREST, QuestItem.of((class_1935)BMBlocks.MOTH_BLOSSOM, 10.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((class_1935)class_2246.field_10182, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((class_1935)class_2246.field_10449, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((class_1935)class_2246.field_10086, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((class_1935)class_2246.field_10226, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((class_1935)class_2246.field_10573, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((class_1935)class_2246.field_10048, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((class_1935)class_2246.field_10270, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((class_1935)class_2246.field_10315, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((class_1935)class_2246.field_10156, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((class_1935)class_2246.field_10554, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((class_1935)class_2246.field_9995, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((class_1935)class_2246.field_10548, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((class_1935)class_2246.field_10583, 2.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((class_1935)class_2246.field_10378, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((class_1935)class_2246.field_10430, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.FLOWER, QuestItem.of((class_1935)class_2246.field_10003, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.SWAMP, QuestItem.of((class_1935)BMBlocks.SMALL_LILY_PAD, 1.25f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.SWAMP, QuestItem.of((class_1935)BMBlocks.CATTAIL, 1.25f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.SWAMP, QuestItem.of((class_1935)BMBlocks.REED, 0.75f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.SWAMP, QuestItem.of((class_1935)BMBlocks.WILLOWING_BRANCHES, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.SWAMP, QuestItem.of((class_1935)class_2246.field_10588, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.SWAMP, QuestItem.of((class_1935)class_1802.field_8777, 2.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.SWAMP, QuestItem.of((class_1935)BMItems.MAGENTA_PETALS, 3.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.SWAMP, QuestItem.of((class_1935)BMItems.WART, 5.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.OCEAN, QuestItem.of((class_1935)class_2246.field_9993, 0.8f, 5));
        WitchQuestHandler.addQuestItem(QuestCategory.OCEAN, QuestItem.of((class_1935)class_2246.field_10376, 0.8f, 5));
        WitchQuestHandler.addQuestItem(QuestCategory.OCEAN, QuestItem.of((class_1935)class_1802.field_8209, 1.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.OCEAN, QuestItem.of((class_1935)class_1802.field_8429, 1.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.OCEAN, QuestItem.of((class_1935)class_1802.field_8794, 2.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.OCEAN, QuestItem.of((class_1935)class_1802.field_17498, 4.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.OCEAN, QuestItem.of((class_1935)class_1802.field_8846, 5.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.OCEAN, QuestItem.of((class_1935)class_1802.field_8323, 5.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.JUNGLE, QuestItem.of((class_1935)class_1802.field_8116, 1.25f, 10));
        WitchQuestHandler.addQuestItem(QuestCategory.JUNGLE, QuestItem.of((class_1935)class_2246.field_10597, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.JUNGLE, QuestItem.of((class_1935)class_2246.field_10545, 4.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.JUNGLE, QuestItem.of((class_1935)class_1802.field_8597, 6.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.JUNGLE, QuestItem.of((class_1935)class_1802.field_8497, 1.25f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.JUNGLE, QuestItem.of((class_1935)class_2246.field_10211, 0.5f, 10));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((class_1935)class_2246.field_22114, 5.0f, 5));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((class_1935)class_2246.field_22121, 5.0f, 5));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((class_1935)class_1802.field_8790, 2.25f, 10));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((class_1935)class_2246.field_23078, 1.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((class_1935)class_2246.field_22123, 1.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((class_1935)class_2246.field_22116, 3.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((class_1935)class_2246.field_22125, 3.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((class_1935)class_2246.field_22115, 6.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((class_1935)class_2246.field_10541, 5.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((class_1935)class_2246.field_22117, 2.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((class_1935)class_2246.field_22120, 4.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((class_1935)class_2246.field_22113, 4.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((class_1935)class_2246.field_10171, 5.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((class_1935)class_1802.field_8894, 10.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((class_1935)class_1802.field_8183, 6.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((class_1935)class_1802.field_8135, 7.0f, 3));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((class_1935)class_1802.field_8070, 14.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.NETHER, QuestItem.of((class_1935)class_2246.field_22122, 8.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_8279, 5.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_8861, 1.0f, 10));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_8618, 10.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_8256, 2.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_16998, 1.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_17531, 0.5f, 8));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_8479, 0.8f, 8));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_8407, 0.8f, 8));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_8725, 2.0f, 8));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_8801, 4.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_8680, 2.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_8711, 8.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_8634, 5.0f, 5));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_8161, 8.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_8054, 3.5f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_8073, 5.0f, 2));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_8614, 7.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_8071, 6.0f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_20417, 7.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_21087, 7.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_8803, 1.25f, 5));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_8635, 3.0f, 5));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_8606, 0.4f, 10));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_1802.field_8759, 0.5f, 10));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_2246.field_10261, 3.5f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_2246.field_10313, 0.75f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_2246.field_10479, 0.5f, 4));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)class_2246.field_10593, 4.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.COMMON, QuestItem.of((class_1935)BMItems.BAT_WING, 3.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.RARE, QuestItem.of((class_1935)class_2246.field_10606, 10.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.RARE, QuestItem.of((class_1935)class_1802.field_8288, 15.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.RARE, QuestItem.of((class_1935)class_2246.field_10177, 50.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.RARE, QuestItem.of((class_1935)class_1802.field_8137, 175.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.RARE, QuestItem.of((class_1935)class_1802.field_8287, 10.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.RARE, QuestItem.of((class_1935)class_1802.field_8367, 40.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.RARE, QuestItem.of((class_1935)class_1802.field_8463, 5.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.RARE, QuestItem.of((class_1935)class_1802.field_8681, 30.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.RARE, QuestItem.of((class_1935)class_1802.field_8398, 30.0f, 1));
        WitchQuestHandler.addQuestItem(QuestCategory.RARE, QuestItem.of((class_1935)class_1802.field_8470, 30.0f, 1));
    }

    public static class_1799 getRewardFor(WitchQuest quest, Random random) {
        QuestRarity rarity = QuestRarity.getRarityFromQuest(quest);
        return rarity.rewards.sample().pickRandom(random);
    }

    public static WitchQuest createQuest(Random random) {
        List counts = ITEM_COUNT_SELECTOR.method_35088().method_35094().toList();
        int count = (Integer)counts.get(random.nextInt(counts.size()));
        ArrayList questItems = Lists.newArrayList();
        while (questItems.size() < count) {
            QuestCategory category = QuestCategory.choose(random);
            List<QuestItem> itemPool = QUEST_ITEMS.get((Object)category);
            QuestItem item = itemPool.get(random.nextInt(itemPool.size()));
            if (questItems.contains(item)) continue;
            questItems.add(item);
        }
        WitchQuest quest = new WitchQuest(random, questItems);
        return quest;
    }

    public static void addQuestItem(QuestCategory category, QuestItem questItem) {
        if (!QUEST_ITEMS.containsKey((Object)category)) {
            QUEST_ITEMS.put(category, Lists.newArrayList());
        }
        QUEST_ITEMS.get((Object)category).add(questItem);
    }

    public static void sendQuests(class_1657 player, int index, WitchQuestList quests) {
        if (player.field_6002.method_8608()) {
            return;
        }
        new S2C_HandleWitchQuests(index, quests).sendTo((class_3222)player);
    }

    static {
        ITEM_COUNT_SELECTOR.method_35093((Object)1, 5);
        ITEM_COUNT_SELECTOR.method_35093((Object)2, 8);
        ITEM_COUNT_SELECTOR.method_35093((Object)3, 4);
        ITEM_COUNT_SELECTOR.method_35093((Object)4, 3);
        ITEM_COUNT_SELECTOR.method_35093((Object)5, 1);
    }
}

