/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.crafting.witch;

import java.util.List;
import java.util.Random;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import party.lemons.biomemakeover.crafting.witch.QuestItem;
import party.lemons.biomemakeover.crafting.witch.QuestRarity;

public class WitchQuest {
    private final class_1799[] requiredItems;
    private float rarityPoints;

    public WitchQuest(Random random, List<QuestItem> items) {
        this.requiredItems = new class_1799[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            QuestItem qi = items.get(i);
            this.rarityPoints += qi.getPoints();
            this.requiredItems[i] = qi.createStack(random);
        }
    }

    public WitchQuest(class_2487 tag) {
        this.rarityPoints = tag.method_10583("Points");
        class_2499 items = tag.method_10554("Items", 10);
        this.requiredItems = new class_1799[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            this.requiredItems[i] = class_1799.method_7915((class_2487)items.method_10602(i));
        }
    }

    public WitchQuest(class_2540 buffer) {
        this.rarityPoints = buffer.readFloat();
        int length = buffer.readByte() & 0xFF;
        this.requiredItems = new class_1799[length];
        for (int i = 0; i < length; ++i) {
            this.requiredItems[i] = buffer.method_10819();
        }
    }

    public class_1799[] getRequiredItems() {
        return this.requiredItems;
    }

    public boolean hasItems(class_1263 inventory) {
        int size = this.getRequiredItems().length;
        for (int i = 0; i < size; ++i) {
            class_1799 st = this.getRequiredItems()[i];
            int count = inventory.method_18861(st.method_7909());
            if (count >= st.method_7947()) continue;
            return false;
        }
        return true;
    }

    public void consumeItems(class_1661 inventory) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 invStack = inventory.method_5438(i);
            if (invStack.method_7960()) continue;
            for (class_1799 stack : this.getRequiredItems()) {
                if (stack.method_7960() || stack.method_7909() != invStack.method_7909()) continue;
                if (stack.method_7947() <= invStack.method_7947()) {
                    invStack.method_7934(stack.method_7947());
                    stack.method_7939(0);
                    continue;
                }
                stack.method_7934(invStack.method_7947());
                invStack.method_7939(0);
            }
        }
    }

    public float getPoints() {
        return this.rarityPoints;
    }

    public String toString() {
        Object s = "WQ | ";
        for (class_1799 st : this.requiredItems) {
            s = (String)s + st.toString();
        }
        s = (String)s + " | " + QuestRarity.getRarityFromPoints(this.rarityPoints);
        return s;
    }

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10548("Points", this.rarityPoints);
        class_2499 items = new class_2499();
        for (int i = 0; i < this.requiredItems.length; ++i) {
            items.add((Object)this.requiredItems[i].method_7953(new class_2487()));
        }
        tag.method_10566("Items", (class_2520)items);
        return tag;
    }

    public void toPacket(class_2540 buffer) {
        buffer.writeFloat(this.rarityPoints);
        int length = this.requiredItems.length;
        buffer.writeByte((int)((byte)(length & 0xFF)));
        for (int i = 0; i < length; ++i) {
            buffer.method_10793(this.requiredItems[i]);
        }
    }
}

