/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.crafting.witch;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_3528;
import party.lemons.biomemakeover.init.BMItems;
import party.lemons.biomemakeover.init.BMPotions;
import party.lemons.biomemakeover.util.RandomUtil;

public enum QuestRewardTable {
    ITEMS((class_3528<List<RewardItem>>)new class_3528(QuestRewardTable::createItemTable)),
    POTION_INGREDIENTS((class_3528<List<RewardItem>>)new class_3528(QuestRewardTable::createPotionIngredientTable)),
    POTION((class_3528<List<RewardItem>>)new class_3528(QuestRewardTable::createPotionTable)),
    COMBO_POTION((class_3528<List<RewardItem>>)new class_3528(QuestRewardTable::createMultiPotionTable));

    private final class_3528<List<RewardItem>> itemTable;

    private QuestRewardTable(class_3528<List<RewardItem>> itemTable) {
        this.itemTable = itemTable;
    }

    public class_1799 pickRandom(Random random) {
        List rewards = (List)this.itemTable.method_15332();
        return ((RewardItem)rewards.get(random.nextInt(rewards.size()))).getRewardStack().method_7972();
    }

    private static List<RewardItem> createItemTable() {
        return Lists.newArrayList((Object[])new RewardItem[]{new ItemStackRewardItem(new class_1799((class_1935)class_1802.field_8469), 1, 10), new ItemStackRewardItem(new class_1799((class_1935)class_1802.field_8601), 4, 8), new ItemStackRewardItem(new class_1799((class_1935)class_1802.field_8054), 2, 10), new ItemStackRewardItem(new class_1799((class_1935)class_1802.field_8725), 7, 15), new ItemStackRewardItem(new class_1799((class_1935)class_1802.field_8680), 5, 10), new ItemStackRewardItem(new class_1799((class_1935)class_1802.field_8479), 8, 10), new ItemStackRewardItem(new class_1799((class_1935)class_1802.field_8600), 10, 20), new ItemStackRewardItem(new class_1799((class_1935)class_1802.field_8687), 1, 4), new ItemStackRewardItem(new class_1799((class_1935)class_1802.field_8759), 1, 10), new ItemStackRewardItem(new class_1799((class_1935)class_2246.field_10251), 3, 5), new ItemStackRewardItem(new class_1799((class_1935)class_2246.field_10559), 3, 5), new ItemStackRewardItem(new class_1799((class_1935)class_2246.field_10593), 1, 5), new ItemStackRewardItem(new class_1799((class_1935)BMItems.ILLUNITE_SHARD), 1, 10)});
    }

    private static List<RewardItem> createPotionIngredientTable() {
        return Lists.newArrayList((Object[])new RewardItem[]{new ItemStackRewardItem(new class_1799((class_1935)class_1802.field_8711), 6, 20), new ItemStackRewardItem(new class_1799((class_1935)class_1802.field_8725), 12, 32), new ItemStackRewardItem(new class_1799((class_1935)class_1802.field_8601), 5, 25), new ItemStackRewardItem(new class_1799((class_1935)class_1802.field_8054), 5, 25), new ItemStackRewardItem(new class_1799((class_1935)class_1802.field_8680), 5, 32), new ItemStackRewardItem(new class_1799((class_1935)class_1802.field_8597), 5, 15), new ItemStackRewardItem(new class_1799((class_1935)BMItems.SOUL_EMBERS), 3, 5), new ItemStackRewardItem(new class_1799((class_1935)class_1802.field_8070), 1, 10), new ItemStackRewardItem(new class_1799((class_1935)class_1802.field_8073), 1, 20), new ItemStackRewardItem(new class_1799((class_1935)BMItems.WART), 1, 7)});
    }

    private static List<RewardItem> createPotionTable() {
        return Lists.newArrayList((Object[])new RewardItem[]{new PotionRewardItem(class_1847.field_8968), new PotionRewardItem(class_1847.field_8981), new PotionRewardItem(class_1847.field_8997), new PotionRewardItem(class_1847.field_9000), new PotionRewardItem(class_1847.field_8979), new PotionRewardItem(class_1847.field_8971), new PotionRewardItem(class_1847.field_8998), new PotionRewardItem(class_1847.field_8987), new PotionRewardItem(class_1847.field_8969), new PotionRewardItem(class_1847.field_9005), new PotionRewardItem(class_1847.field_8983), new PotionRewardItem(class_1847.field_8966), new PotionRewardItem(class_1847.field_8996), new PotionRewardItem(class_1847.field_8989), new PotionRewardItem(class_1847.field_8976), new PotionRewardItem(class_1847.field_8990), new PotionRewardItem(class_1847.field_8988), new PotionRewardItem(class_1847.field_8977), new PotionRewardItem(class_1847.field_8994), new PotionRewardItem(class_1847.field_9001), new PotionRewardItem(class_1847.field_8963), new PotionRewardItem(class_1847.field_8980), new PotionRewardItem(class_1847.field_9004), new PotionRewardItem(class_1847.field_8973), new PotionRewardItem(class_1847.field_8982), new PotionRewardItem(class_1847.field_9002), new PotionRewardItem(class_1847.field_8972), new PotionRewardItem(class_1847.field_8986), new PotionRewardItem(class_1847.field_9003), new PotionRewardItem(class_1847.field_8992), new PotionRewardItem(class_1847.field_8978), new PotionRewardItem(class_1847.field_8965), new PotionRewardItem(class_1847.field_8993), new PotionRewardItem(class_1847.field_8975), new PotionRewardItem(class_1847.field_8970), new PotionRewardItem(class_1847.field_8995), new PotionRewardItem(class_1847.field_8974), new PotionRewardItem(class_1847.field_8964), new PotionRewardItem(BMPotions.ANTIDOTE_POT), new ItemStackRewardItem(new class_1799((class_1935)BMItems.SWAMP_JIVES_MUSIC_DISK), 1, 1)});
    }

    private static List<RewardItem> createMultiPotionTable() {
        return Lists.newArrayList((Object[])new RewardItem[]{new PotionRewardItem(BMPotions.ADRENALINE), new PotionRewardItem(BMPotions.ASSASSIN), new PotionRewardItem(BMPotions.DARKNESS), new PotionRewardItem(BMPotions.DOLPHIN_MASTER), new PotionRewardItem(BMPotions.LIQUID_BREAD), new PotionRewardItem(BMPotions.PHANTOM_SPIRIT), new PotionRewardItem(BMPotions.LIGHT_FOOTED), new PotionRewardItem(BMPotions.MINER)});
    }

    private static interface RewardItem {
        public class_1799 getRewardStack();
    }

    private record ItemStackRewardItem(class_1799 stack, int quantityMin, int quantityMax) implements RewardItem
    {
        @Override
        public class_1799 getRewardStack() {
            class_1799 reward = this.stack.method_7972();
            reward.method_7939(RandomUtil.randomRange(this.quantityMin, this.quantityMax));
            return reward;
        }
    }

    private record PotionRewardItem(class_1842 potion) implements RewardItem
    {
        @Override
        public class_1799 getRewardStack() {
            class_1792 it = class_1802.field_8574;
            if (RandomUtil.RANDOM.nextInt(4) == 0) {
                it = RandomUtil.RANDOM.nextInt(3) == 0 ? class_1802.field_8150 : class_1802.field_8436;
            }
            return class_1844.method_8061((class_1799)new class_1799((class_1935)it), (class_1842)this.potion);
        }
    }
}

