/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.crafting.witch;

import java.util.Locale;
import net.minecraft.class_1814;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import party.lemons.biomemakeover.crafting.witch.QuestRewardTable;
import party.lemons.biomemakeover.crafting.witch.WitchQuest;
import party.lemons.biomemakeover.util.WeightedList;

public enum QuestRarity {
    COMMON(class_1814.field_8906, 0, new int[]{110, 150, 10, 1}),
    UNCOMMON(class_1814.field_8907, 8, new int[]{90, 120, 75, 10}),
    RARE(class_1814.field_8903, 15, new int[]{0, 0, 100, 50}),
    EPIC(class_1814.field_8904, 30, new int[]{0, 0, 0, 100});

    private final int requiredPoints;
    private final class_1814 vanillaRarity;
    public final WeightedList<QuestRewardTable> rewards;

    private QuestRarity(class_1814 rarity, int requiredPoints, int[] rewardWeights) {
        this.requiredPoints = requiredPoints;
        this.vanillaRarity = rarity;
        this.rewards = new WeightedList();
        this.rewards.add(QuestRewardTable.ITEMS, rewardWeights[0]);
        this.rewards.add(QuestRewardTable.POTION_INGREDIENTS, rewardWeights[1]);
        this.rewards.add(QuestRewardTable.POTION, rewardWeights[2]);
        this.rewards.add(QuestRewardTable.COMBO_POTION, rewardWeights[3]);
    }

    public class_2561 getTooltipText() {
        return new class_2588("tooltip." + this.name().toLowerCase(Locale.ROOT)).method_27692(this.vanillaRarity.field_8908);
    }

    public static QuestRarity getRarityFromPoints(float points) {
        for (int i = QuestRarity.values().length - 1; i >= 0; --i) {
            if (!(points >= (float)QuestRarity.values()[i].requiredPoints)) continue;
            return QuestRarity.values()[i];
        }
        return COMMON;
    }

    public static QuestRarity getRarityFromQuest(WitchQuest quest) {
        return QuestRarity.getRarityFromPoints(quest.getPoints());
    }
}

