/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.block.blockentity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.block.AltarBlock;
import party.lemons.biomemakeover.crafting.AltarMenu;
import party.lemons.biomemakeover.init.BMBlockEntities;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMItems;
import party.lemons.biomemakeover.util.RandomUtil;
import party.lemons.biomemakeover.util.effect.BiomeMakeoverEffect;
import party.lemons.biomemakeover.util.effect.EffectHelper;

public class AltarBlockEntity
extends class_2621
implements class_1278 {
    public static final int MAX_TIME = 300;
    private static final double PI = Math.PI;
    private static final double PI2 = Math.PI * 2;
    private static final List<class_1887> curses = Lists.newArrayList();
    private class_2371<class_1799> inventory = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    private int progress = 0;
    protected final class_3913 data = new class_3913(){

        public int method_17390(int index) {
            return AltarBlockEntity.this.progress;
        }

        public void method_17391(int index, int value) {
            AltarBlockEntity.this.progress = value;
        }

        public int method_17389() {
            return 1;
        }
    };
    public int ticks;
    public float nextPageAngle;
    public float pageAngle;
    public float nextPageTurn;
    public float angleChange;
    public float nextPageTurningSpeed;
    public float pageTurningSpeed;
    public float currentAngle;
    public float lastAngle;
    public float nextAngle;
    private static final Random RANDOM = new Random();
    private boolean workingPrevious = false;

    public AltarBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(BMBlockEntities.ALTAR, blockPos, blockState);
    }

    private void tick() {
        if (this.field_11863 == null) {
            return;
        }
        class_2338 pos = this.method_11016();
        ++this.ticks;
        this.updateBook();
        boolean working = false;
        if (this.canWork()) {
            if (!this.field_11863.method_8608()) {
                working = true;
                if (!this.workingPrevious) {
                    this.field_11863.method_8652(pos, (class_2680)this.field_11863.method_8320(pos).method_11657((class_2769)AltarBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
                    EffectHelper.doEffect(this.field_11863, BiomeMakeoverEffect.PLAY_CURSE_SOUND, pos);
                }
                ++this.progress;
                if (this.progress >= 300) {
                    if (this.method_5438(0).method_7909() == class_1802.field_8529) {
                        class_1799 newStack = new class_1799((class_1935)class_1802.field_8598);
                        class_1887 curse = AltarBlockEntity.getRandomCurse(this.field_11863.field_9229);
                        newStack.method_7978(curse, 1);
                        this.inventory.set(0, (Object)newStack);
                    } else if (AltarBlockEntity.curseItemStack(this.method_5438(0), this.field_11863.field_9229)) {
                        // empty if block
                    }
                    this.progress = 0;
                    this.method_5438(1).method_7934(1);
                }
            }
        } else if (!this.field_11863.method_8608()) {
            this.progress = 0;
            working = false;
            if (!this.workingPrevious) {
                this.field_11863.method_8652(pos, (class_2680)this.field_11863.method_8320(pos).method_11657((class_2769)AltarBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
        this.workingPrevious = working;
    }

    private void updateBook() {
        if (!this.field_11863.method_8608()) {
            return;
        }
        class_2338 pos = this.method_11016();
        this.pageTurningSpeed = this.nextPageTurningSpeed;
        this.lastAngle = this.currentAngle;
        if (!this.field_11863.method_8320(pos).method_27852((class_2248)BMBlocks.ALTAR)) {
            return;
        }
        if (((Boolean)this.field_11863.method_8320(pos).method_11654((class_2769)AltarBlock.ACTIVE)).booleanValue()) {
            this.nextAngle += 0.5f;
            this.nextPageTurningSpeed += 0.2f;
        } else {
            class_1657 playerEntity = this.field_11863.method_18459((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 3.0, false);
            if (playerEntity != null) {
                double distanceX = playerEntity.method_23317() - ((double)pos.method_10263() + 0.5);
                double distanceZ = playerEntity.method_23321() - ((double)pos.method_10260() + 0.5);
                this.nextAngle = (float)class_3532.method_15349((double)distanceZ, (double)distanceX);
                this.nextPageTurningSpeed += 0.1f;
                if (this.nextPageTurningSpeed < 0.5f || RANDOM.nextInt(40) == 0) {
                    float f = this.nextPageTurn;
                    do {
                        this.nextPageTurn += (float)(RANDOM.nextInt(4) - RANDOM.nextInt(4));
                    } while (f == this.nextPageTurn);
                }
            } else {
                this.nextAngle += 0.02f;
                this.nextPageTurningSpeed -= 0.1f;
            }
        }
        while ((double)this.currentAngle >= Math.PI) {
            this.currentAngle = (float)((double)this.currentAngle - Math.PI * 2);
        }
        while ((double)this.currentAngle < -Math.PI) {
            this.currentAngle = (float)((double)this.currentAngle + Math.PI * 2);
        }
        while ((double)this.nextAngle >= Math.PI) {
            this.nextAngle = (float)((double)this.nextAngle - Math.PI * 2);
        }
        while ((double)this.nextAngle < -Math.PI) {
            this.nextAngle = (float)((double)this.nextAngle + Math.PI * 2);
        }
        float rotation = this.nextAngle - this.currentAngle;
        while ((double)rotation >= Math.PI) {
            rotation = (float)((double)rotation - Math.PI * 2);
        }
        while ((double)rotation < -Math.PI) {
            rotation = (float)((double)rotation + Math.PI * 2);
        }
        this.currentAngle += rotation * 0.4f;
        this.nextPageTurningSpeed = class_3532.method_15363((float)this.nextPageTurningSpeed, (float)0.0f, (float)1.0f);
        ++this.ticks;
        this.pageAngle = this.nextPageAngle;
        float h = (this.nextPageTurn - this.nextPageAngle) * 0.4f;
        h = class_3532.method_15363((float)h, (float)-0.2f, (float)0.2f);
        this.angleChange += (h - this.angleChange) * 0.9f;
        this.nextPageAngle += this.angleChange;
    }

    public boolean canWork() {
        return AltarBlockEntity.isValidForCurse((class_1799)this.inventory.get(0)) && !((class_1799)this.inventory.get(1)).method_7960();
    }

    public static boolean isValidForCurse(class_1799 stack) {
        if (stack.method_7960() || stack.method_7909() instanceof class_1772) {
            return false;
        }
        if (stack.method_7909() == class_1802.field_8529) {
            return true;
        }
        Map enchantments = class_1890.method_8222((class_1799)stack);
        if (enchantments.isEmpty() || stack.method_7985() && stack.method_7969().method_10545("BMCursed")) {
            return false;
        }
        boolean hasNewCompatibleCurse = false;
        for (class_1887 enchantment : enchantments.keySet()) {
            if (enchantment.method_8183() > 1 && !enchantment.method_8195()) {
                return true;
            }
            if (!enchantment.method_8195() || !enchantment.method_8192(stack) || enchantments.containsKey(enchantment)) continue;
            hasNewCompatibleCurse = true;
        }
        return hasNewCompatibleCurse;
    }

    public static class_1887 getRandomCurse(Random random) {
        if (curses.isEmpty()) {
            curses.addAll(class_2378.field_11160.method_10220().filter(class_1887::method_8195).toList());
        }
        return curses.get(random.nextInt(curses.size()));
    }

    public static boolean curseItemStack(class_1799 stack, Random random) {
        if (AltarBlockEntity.isValidForCurse(stack)) {
            Map enchantments = class_1890.method_8222((class_1799)stack);
            List<class_1887> validEnchants = enchantments.keySet().stream().filter(e -> e.method_8183() > 1 && !e.method_8195()).toList();
            class_1887 toUpgrade = validEnchants.get(random.nextInt(validEnchants.size()));
            enchantments.put(toUpgrade, (Integer)enchantments.get(toUpgrade) + 1);
            class_1887 curse = AltarBlockEntity.getRandomCurse(random);
            int attempts = 0;
            while (enchantments.containsKey(curse) || !curse.method_8192(stack) && attempts < 100) {
                curse = AltarBlockEntity.getRandomCurse(random);
                if (++attempts < 100) continue;
                curse = null;
            }
            if (curse == null) {
                for (class_1887 enchantment : class_2378.field_11160.method_10220().sorted((e, e1) -> RandomUtil.randomRange(-1, 1)).collect(Collectors.toList())) {
                    if (!enchantment.method_8195() || !enchantment.method_8192(stack) || enchantments.containsKey(enchantment)) continue;
                    curse = enchantment;
                }
            }
            int curseLevel = curse.method_8183() == 1 ? 1 : RandomUtil.randomRange(curse.method_8187(), curse.method_8183());
            enchantments.put(curse, curseLevel);
            class_2487 tag = stack.method_7948();
            tag.method_10556("BMCursed", true);
            stack.method_7980(tag);
            stack.method_7927(39);
            class_1890.method_8214((Map)enchantments, (class_1799)stack);
            return true;
        }
        return false;
    }

    public int[] method_5494(class_2350 direction) {
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            return new int[]{0};
        }
        return new int[]{1};
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 direction) {
        if (slot == 0 && AltarBlockEntity.isValidForCurse(stack)) {
            return true;
        }
        return slot == 1 && stack.method_31573(BMItems.CURSE_FUEL);
    }

    public boolean method_5493(int i, class_1799 itemStack, class_2350 direction) {
        return true;
    }

    public int method_5439() {
        return 2;
    }

    public boolean method_5442() {
        return false;
    }

    public class_1799 method_5438(int i) {
        if (i < 0 || i >= this.inventory.size()) {
            return class_1799.field_8037;
        }
        return (class_1799)this.inventory.get(i);
    }

    public class_1799 method_5434(int i, int j) {
        class_1799 itemStack = class_1262.method_5430(this.inventory, (int)i, (int)j);
        if (!itemStack.method_7960()) {
            this.method_5431();
        }
        return itemStack;
    }

    public class_1799 method_5441(int i) {
        class_1799 itemStack = (class_1799)this.inventory.get(i);
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        this.inventory.set(i, (Object)class_1799.field_8037);
        return itemStack;
    }

    public void method_5447(int i, class_1799 itemStack) {
        this.inventory.set(i, (Object)itemStack);
        if (!itemStack.method_7960() && itemStack.method_7947() > this.method_5444()) {
            itemStack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        class_2338 pos = this.method_11016();
        if (this.field_11863.method_8321(pos) != this) {
            return false;
        }
        return player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) <= 64.0;
    }

    public void method_5448() {
        this.inventory.clear();
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> nonNullList) {
        this.inventory = nonNullList;
    }

    public static <T extends class_2586> class_5558<T> getTicker(class_1937 level, class_2680 blockState, class_2591<T> blockEntityType) {
        return (lvl, pos, state, type) -> {
            class_2586 be = lvl.method_8321(pos);
            if (be != null && be instanceof AltarBlockEntity) {
                ((AltarBlockEntity)be).tick();
            }
        };
    }

    protected void method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        class_1262.method_5426((class_2487)compoundTag, this.inventory);
        compoundTag.method_10569("Progress", this.progress);
    }

    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        class_1262.method_5429((class_2487)compoundTag, this.inventory);
        this.progress = compoundTag.method_10550("Progress");
    }

    protected class_2561 method_17823() {
        return new class_2588(this.method_11010().method_26204().method_9539());
    }

    protected class_1703 method_5465(int i, class_1661 inventory) {
        return new AltarMenu(i, inventory, (class_1263)this, this.data);
    }
}

