/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_10;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.block.BMBlock;
import party.lemons.biomemakeover.util.RandomUtil;

public class SaguaroCactusBlock
extends BMBlock
implements class_2256 {
    public static final class_2746 HORIZONTAL = class_2746.method_11825((String)"horizontal");
    public static final class_2753 HORIZONTAL_DIRECTION = class_2383.field_11177;
    public static final class_2746 NORTH = class_2746.method_11825((String)"north");
    public static final class_2746 SOUTH = class_2746.method_11825((String)"south");
    public static final class_2746 EAST = class_2746.method_11825((String)"east");
    public static final class_2746 WEST = class_2746.method_11825((String)"west");
    private final HashMap<class_2680, class_265> shapes = (HashMap)class_156.method_654((Object)Maps.newHashMap(), m -> this.method_9595().method_11662().forEach(st -> m.put(st, this.getShapeForState((class_2680)st))));
    public static final Map<class_2350, class_2746> FACING_PROPERTIES = (Map)class_156.method_654((Object)Maps.newEnumMap(class_2350.class), enumMap -> {
        enumMap.put(class_2350.field_11043, NORTH);
        enumMap.put(class_2350.field_11034, EAST);
        enumMap.put(class_2350.field_11035, SOUTH);
        enumMap.put(class_2350.field_11039, WEST);
    });
    private static final class_2350[] NORTH_SOUTH = new class_2350[]{class_2350.field_11043, class_2350.field_11035};
    private static final class_2350[] EAST_WEST = new class_2350[]{class_2350.field_11034, class_2350.field_11039};

    public SaguaroCactusBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)HORIZONTAL, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)HORIZONTAL_DIRECTION, (Comparable)class_2350.field_11043)).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 st = this.method_9564();
        if (ctx.method_8038().method_10161() >= 0) {
            st = (class_2680)((class_2680)((class_2680)st.method_11657((class_2769)HORIZONTAL, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)HORIZONTAL_DIRECTION, (Comparable)ctx.method_8038().method_10153())).method_11657((class_2769)FACING_PROPERTIES.get(ctx.method_8038().method_10153()), (Comparable)Boolean.valueOf(true));
        }
        return st;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 level, class_2338 pos, class_2338 posFrom) {
        if (!this.method_9558(state, (class_4538)level, pos)) {
            level.method_39279(pos, (class_2248)this, 1);
            return super.method_9559(state, direction, newState, level, pos, posFrom);
        }
        if (direction.method_10166().method_10178()) {
            return super.method_9559(state, direction, newState, level, pos, posFrom);
        }
        if (newState.method_26204() == this) {
            if (((Boolean)newState.method_11654((class_2769)HORIZONTAL)).booleanValue() && ((Boolean)newState.method_11654((class_2769)FACING_PROPERTIES.get(direction.method_10153()))).booleanValue()) {
                return (class_2680)state.method_11657((class_2769)FACING_PROPERTIES.get(direction), (Comparable)Boolean.valueOf(true));
            }
        } else {
            return (class_2680)state.method_11657((class_2769)FACING_PROPERTIES.get(direction), (Comparable)Boolean.valueOf(false));
        }
        return super.method_9559(state, direction, newState, level, pos, posFrom);
    }

    public void method_9588(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, Random random) {
        if (!blockState.method_26184((class_4538)serverLevel, blockPos)) {
            serverLevel.method_22352(blockPos, true);
        }
    }

    public boolean method_9558(class_2680 state, class_4538 levelReader, class_2338 blockPos) {
        if (((Boolean)state.method_11654((class_2769)HORIZONTAL)).booleanValue()) {
            class_2350 offset = (class_2350)state.method_11654((class_2769)HORIZONTAL_DIRECTION);
            if (!levelReader.method_8320(blockPos.method_10093(offset)).method_27852((class_2248)this)) {
                return false;
            }
        } else {
            class_2680 checkState = levelReader.method_8320(blockPos.method_10074());
            return (checkState.method_27852((class_2248)this) || checkState.method_27852(class_2246.field_10102) || checkState.method_27852(class_2246.field_10534)) && !levelReader.method_8320(blockPos.method_10084()).method_26207().method_15797();
        }
        return super.method_9558(state, levelReader, blockPos);
    }

    public boolean isGrowBlock(class_2680 state) {
        return state.method_27852(class_2246.field_10102) || state.method_27852(class_2246.field_10534);
    }

    public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        return this.getShape(blockState);
    }

    public class_265 getShape(class_2680 state) {
        return this.shapes.get(state);
    }

    private class_265 getShapeForState(class_2680 state) {
        double size = 4.0;
        class_265 base = (Boolean)state.method_11654((class_2769)HORIZONTAL) != false ? class_2248.method_9541((double)size, (double)(size * 2.0), (double)size, (double)(16.0 - size), (double)15.98, (double)(16.0 - size)) : class_2248.method_9541((double)size, (double)0.0, (double)size, (double)(16.0 - size), (double)15.98, (double)(16.0 - size));
        ArrayList connections = Lists.newArrayList();
        for (class_2350 dir : class_2350.values()) {
            double x;
            if (dir == class_2350.field_11033 || dir == class_2350.field_11036 || !((Boolean)state.method_11654((class_2769)FACING_PROPERTIES.get(dir))).booleanValue()) continue;
            double d = dir == class_2350.field_11039 ? 0.0 : (x = dir == class_2350.field_11034 ? 16.0 : size);
            double z = dir == class_2350.field_11043 ? 0.0 : (dir == class_2350.field_11035 ? 16.0 : size);
            double upper = 16.0 - size;
            double minX = Math.min(x, upper) / 16.0;
            double maxX = Math.max(x, upper) / 16.0;
            double minZ = Math.min(z, upper) / 16.0;
            double maxZ = Math.max(z, upper) / 16.0;
            class_265 sh = class_259.method_1081((double)minX, (double)0.5, (double)minZ, (double)maxX, (double)0.99875, (double)maxZ);
            connections.add(sh);
        }
        return class_259.method_17786((class_265)base, (class_265[])connections.toArray(new class_265[0]));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{EAST, WEST, NORTH, SOUTH, HORIZONTAL, HORIZONTAL_DIRECTION});
    }

    public void method_9514(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, Random random) {
        if (this.method_9651((class_1922)serverLevel, blockPos, blockState, serverLevel.field_9236) && random.nextInt(10) == 0) {
            this.method_9652(serverLevel, random, blockPos, blockState);
        }
    }

    public void method_9548(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1297 entity) {
        entity.method_5643(class_1282.field_5848, 1.0f);
    }

    public boolean method_9516(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_10 pathComputationType) {
        return false;
    }

    public boolean method_9651(class_1922 blockGetter, class_2338 blockPos, class_2680 blockState, boolean isClient) {
        return blockState.equals(this.method_9564()) && this.isGrowBlock(blockGetter.method_8320(blockPos.method_10074())) && blockGetter.method_8320(blockPos.method_10084()).method_26215();
    }

    public boolean method_9650(class_1937 level, Random random, class_2338 blockPos, class_2680 blockState) {
        return (double)level.field_9229.nextFloat() < 0.45;
    }

    public void method_9652(class_3218 serverLevel, Random random, class_2338 blockPos, class_2680 blockState) {
        SaguaroCactusBlock.generateCactus(this, (class_5281)serverLevel, random.nextBoolean(), blockPos, random, false);
    }

    public static boolean generateCactus(class_2248 block, class_5281 world, boolean northSouth, class_2338 pos, Random random, boolean isBig) {
        class_2338 nextPos;
        class_2350[] directions;
        if (!block.method_9564().method_26184((class_4538)world, pos)) {
            return false;
        }
        boolean hasArms = random.nextInt(10) > 1;
        boolean has2Arms = random.nextInt(5) != 0;
        int centerHeight = RandomUtil.randomRange(4, 8);
        class_2338.class_2339 p = new class_2338.class_2339(pos.method_10263(), pos.method_10264(), pos.method_10260());
        for (int yy = 0; yy < centerHeight && (yy <= 0 || world.method_8320((class_2338)p).method_26215()); ++yy) {
            world.method_8652((class_2338)p, block.method_9564(), 2);
            p.method_10098(class_2350.field_11036);
        }
        if (!hasArms) {
            return true;
        }
        int centerEndY = p.method_10264();
        int armStart = RandomUtil.randomRange(1, centerHeight - 2);
        class_2350[] class_2350Array = directions = northSouth ? NORTH_SOUTH : EAST_WEST;
        if (has2Arms) {
            for (class_2350 d : directions) {
                SaguaroCactusBlock.generateArm(block, world, d, p.method_10263(), pos.method_10264() + armStart, p.method_10260(), centerEndY);
                armStart = RandomUtil.randomRange(1, centerHeight - 2);
            }
        } else {
            SaguaroCactusBlock.generateArm(block, world, directions[random.nextInt(directions.length)], p.method_10263(), pos.method_10264() + armStart, p.method_10260(), centerEndY);
        }
        if ((!isBig && random.nextInt(10) == 0 || isBig && random.nextInt(50) == 0) && world.method_8320(nextPos = new class_2338(pos.method_10263(), centerEndY, pos.method_10260())).method_26215()) {
            SaguaroCactusBlock.generateCactus(block, world, random.nextBoolean(), nextPos, random, true);
        }
        return true;
    }

    private static void generateArm(class_2248 block, class_5281 world, class_2350 direction, int centerX, int armY, int centerZ, int centerHeight) {
        class_2338.class_2339 p = new class_2338.class_2339(centerX + direction.method_10148(), armY, centerZ + direction.method_10165());
        if (!world.method_8320((class_2338)p).method_26215()) {
            return;
        }
        class_2338 centerPos = p.method_10093(direction.method_10153());
        class_2680 centerState = world.method_8320(centerPos);
        if (!centerState.method_27852(block)) {
            return;
        }
        world.method_8652(centerPos, (class_2680)centerState.method_11657((class_2769)FACING_PROPERTIES.get(direction), (Comparable)Boolean.valueOf(true)), 2);
        world.method_8652((class_2338)p, (class_2680)((class_2680)((class_2680)block.method_9564().method_11657((class_2769)HORIZONTAL, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)HORIZONTAL_DIRECTION, (Comparable)direction.method_10153())).method_11657((class_2769)FACING_PROPERTIES.get(direction.method_10153()), (Comparable)Boolean.valueOf(true)), 2);
        p.method_10098(class_2350.field_11036);
        int amt = Math.max(1, centerHeight - p.method_10264() + RandomUtil.randomRange(-3, -1));
        for (int i = 0; i < amt; ++i) {
            if (!world.method_8320((class_2338)p).method_26215()) {
                return;
            }
            world.method_8652((class_2338)p, block.method_9564(), 2);
            p.method_10098(class_2350.field_11036);
        }
    }
}

