/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2429;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.block.BMBlock;
import party.lemons.biomemakeover.block.modifier.BlockModifier;
import party.lemons.biomemakeover.block.modifier.BlockWithModifiers;
import party.lemons.biomemakeover.util.BMUtil;

public class IvyShapedBlock
extends BMBlock {
    private static final class_265 UP_SHAPE = class_2248.method_9541((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 DOWN_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final class_265 EAST_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final class_265 WEST_SHAPE = class_2248.method_9541((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 SOUTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final class_265 NORTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<class_2350, class_2746> FACING_PROPERTIES = class_2429.field_11329;
    private static final Map<class_2350, class_265> DIRECTION_TO_SHAPE = (Map)class_156.method_654((Object)Maps.newEnumMap(class_2350.class), enumMap -> {
        enumMap.put(class_2350.field_11043, SOUTH_SHAPE);
        enumMap.put(class_2350.field_11034, WEST_SHAPE);
        enumMap.put(class_2350.field_11035, NORTH_SHAPE);
        enumMap.put(class_2350.field_11039, EAST_SHAPE);
        enumMap.put(class_2350.field_11036, UP_SHAPE);
        enumMap.put(class_2350.field_11033, DOWN_SHAPE);
    });
    protected final ImmutableMap<class_2680, class_265> shapes;

    public IvyShapedBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590(IvyShapedBlock.createDefaultState((class_2689<class_2248, class_2680>)this.method_9595()));
        this.shapes = this.collectVoxelShapes((class_2689<class_2248, class_2680>)this.method_9595());
    }

    public static class_2746 getPropertyForDirection(class_2350 direction) {
        return FACING_PROPERTIES.get(direction);
    }

    protected static class_2680 createDefaultState(class_2689<class_2248, class_2680> stateManager) {
        class_2680 blockState = (class_2680)stateManager.method_11664();
        for (class_2746 property : FACING_PROPERTIES.values()) {
            if (!blockState.method_28498((class_2769)property)) continue;
            blockState = (class_2680)blockState.method_11657((class_2769)property, (Comparable)Boolean.valueOf(false));
        }
        return blockState;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 level, class_2338 pos, class_2338 posFrom) {
        class_2680 returnState;
        if (this.hasDirection(state, direction) && !IvyShapedBlock.isValidPlaceFace((class_4538)level, direction, posFrom, newState)) {
            returnState = this.getStateWithoutDirection(state, IvyShapedBlock.getPropertyForDirection(direction));
            if (!level.method_8608()) {
                level.method_20290(2001, pos, class_2248.method_9507((class_2680)((class_2680)this.method_9564().method_11657((class_2769)IvyShapedBlock.getPropertyForDirection(direction), (Comparable)Boolean.valueOf(true)))));
            }
        } else {
            returnState = state;
        }
        if (!this.hasAnySide(returnState)) {
            level.method_8652(pos, class_2246.field_10124.method_9564(), 3);
            return state;
        }
        return returnState;
    }

    private boolean hasAnySide(class_2680 state) {
        for (class_2350 d : class_2350.values()) {
            if (!this.hasDirection(state, d)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAdjacentSide(class_2350 direction, class_2680 state) {
        for (class_2350 d : class_2350.values()) {
            if (!BMUtil.isAdjacentDirection(d, direction) || !this.hasDirection(state, d)) continue;
            return true;
        }
        return false;
    }

    public class_2680 getStateWithoutDirection(class_2680 state, class_2746 directionProperty) {
        return (class_2680)state.method_11657((class_2769)directionProperty, (Comparable)Boolean.valueOf(false));
    }

    public class_265 method_26159(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        return (class_265)this.shapes.get((Object)blockState);
    }

    public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        return (class_265)this.shapes.get((Object)blockState);
    }

    public static class_265 getDownShape() {
        return DOWN_SHAPE;
    }

    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        boolean canPlace = false;
        for (class_2350 direction : class_2350.values()) {
            if (!this.hasDirection(state, direction)) continue;
            class_2338 blockPos = pos.method_10093(direction);
            if (!IvyShapedBlock.isValidPlaceFace(level, direction, blockPos, level.method_8320(blockPos))) {
                return true;
            }
            canPlace = true;
        }
        return canPlace;
    }

    protected ImmutableMap<class_2680, class_265> collectVoxelShapes(class_2689<class_2248, class_2680> stateDefinition) {
        return (ImmutableMap)stateDefinition.method_11662().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), s -> IvyShapedBlock.calculateShape(s, this)));
    }

    protected class_2350 getRandomStateSide(class_2680 state, Random random) {
        List<class_2350> dirs = Arrays.stream(class_2350.values()).filter(d -> (Boolean)state.method_11654((class_2769)IvyShapedBlock.getPropertyForDirection(d))).toList();
        if (dirs.isEmpty()) {
            return null;
        }
        return dirs.get(random.nextInt(dirs.size()));
    }

    protected static class_265 mergeVoxelShapes(class_2680 blockState) {
        class_265 shape = class_259.method_1073();
        for (class_2350 direction : class_2350.values()) {
            if (!IvyShapedBlock.isValidDirectionForState(blockState, direction)) continue;
            shape = class_259.method_1084((class_265)shape, (class_265)DIRECTION_TO_SHAPE.get(direction));
        }
        return shape;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        for (class_2350 direction : class_2350.values()) {
            builder.method_11667(new class_2769[]{IvyShapedBlock.getPropertyForDirection(direction)});
        }
    }

    @Nullable
    public class_2680 getPlacementState(class_2680 blockState, class_1937 worldAccess, class_2338 blockPos, class_2350 direction) {
        class_2680 placeState;
        if (blockState.method_27852((class_2248)this)) {
            if (this.hasDirection(blockState, direction)) {
                return null;
            }
            placeState = blockState;
        } else {
            placeState = this.method_9564();
        }
        class_2338 placeSide = blockPos.method_10093(direction);
        return IvyShapedBlock.isValidPlaceFace((class_4538)worldAccess, direction, placeSide, worldAccess.method_8320(placeSide)) ? (class_2680)placeState.method_11657((class_2769)IvyShapedBlock.getPropertyForDirection(direction), (Comparable)Boolean.valueOf(true)) : null;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return this.getStateWithDirections(state, arg_0 -> ((class_2470)rotation).method_10503(arg_0));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return this.getStateWithDirections(state, arg_0 -> ((class_2415)mirror).method_10343(arg_0));
    }

    private class_2680 getStateWithDirections(class_2680 blockState, Function<class_2350, class_2350> function) {
        class_2680 state = blockState;
        for (class_2350 direction : class_2350.values()) {
            state = (class_2680)state.method_11657((class_2769)IvyShapedBlock.getPropertyForDirection(function.apply(direction)), (Comparable)((Boolean)blockState.method_11654((class_2769)IvyShapedBlock.getPropertyForDirection(direction))));
        }
        return state;
    }

    public boolean hasDirection(class_2680 blockState, class_2350 direction) {
        class_2746 booleanProperty = IvyShapedBlock.getPropertyForDirection(direction);
        return (Boolean)blockState.method_11654((class_2769)booleanProperty);
    }

    public static boolean isValidPlaceFace(class_4538 blockView, class_2350 direction, class_2338 blockPos, class_2680 blockState) {
        return class_2248.method_9501((class_265)blockState.method_26220((class_1922)blockView, blockPos), (class_2350)direction.method_10153());
    }

    private static boolean isValidDirectionForState(class_2680 blockState, class_2350 direction) {
        class_2746 booleanProperty = IvyShapedBlock.getPropertyForDirection(direction);
        return blockState.method_28498((class_2769)booleanProperty) && (Boolean)blockState.method_11654((class_2769)booleanProperty) != false;
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_1937 world = ctx.method_8045();
        class_2338 blockPos = ctx.method_8037();
        class_2680 blockState = world.method_8320(blockPos);
        return Arrays.stream(ctx.method_7718()).map(direction -> this.getPlacementState(blockState, world, blockPos, (class_2350)direction)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static class_265 calculateShape(class_2680 blockState, IvyShapedBlock block) {
        class_265 voxelShape = class_259.method_1073();
        for (class_2350 direction : class_2350.values()) {
            if (!block.hasDirection(blockState, direction)) continue;
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)DIRECTION_TO_SHAPE.get(direction));
        }
        return voxelShape.method_1110() ? class_259.method_1077() : voxelShape;
    }

    @Override
    public IvyShapedBlock modifiers(BlockModifier ... modifiers) {
        BlockWithModifiers.init(this, modifiers);
        return this;
    }
}

