/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover;

import dev.architectury.platform.Platform;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import dev.architectury.utils.Env;
import net.minecraft.class_1113;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_310;
import party.lemons.biomemakeover.block.blockentity.AltarBlockEntity;
import party.lemons.biomemakeover.block.blockentity.render.AltarRenderer;
import party.lemons.biomemakeover.block.blockentity.render.LightningBugBottleRenderer;
import party.lemons.biomemakeover.block.blockentity.render.TapestryRenderer;
import party.lemons.biomemakeover.crafting.AltarScreen;
import party.lemons.biomemakeover.crafting.DirectionDataScreen;
import party.lemons.biomemakeover.crafting.witch.menu.WitchScreen;
import party.lemons.biomemakeover.init.BMBlockEntities;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.init.BMScreens;
import party.lemons.biomemakeover.util.color.ColorProviderHelper;
import party.lemons.biomemakeover.util.color.FoliageBlockColorProvider;
import party.lemons.biomemakeover.util.color.FoliageShiftBlockColorProvider;
import party.lemons.biomemakeover.util.color.StaticBlockColorProvider;
import party.lemons.biomemakeover.util.sound.AltarCursingSoundInstance;

public class BiomeMakeoverClient {
    public static void init() {
        if (Platform.getEnvironment() == Env.CLIENT) {
            BMEntities.registerModelLayers();
            BMBlocks.initClient();
            BlockEntityRendererRegistry.register(BMBlockEntities.TAPESTRY, TapestryRenderer::new);
            BlockEntityRendererRegistry.register(BMBlockEntities.ALTAR, AltarRenderer::new);
            BlockEntityRendererRegistry.register(BMBlockEntities.LIGHTNING_BUG_BOTTLE, LightningBugBottleRenderer::new);
            BiomeMakeoverClient.initColors();
            MenuRegistry.registerScreenFactory(BMScreens.WITCH, WitchScreen::new);
            MenuRegistry.registerScreenFactory(BMScreens.ALTAR, AltarScreen::new);
            MenuRegistry.registerScreenFactory(BMScreens.DIRECTIONAL_DATA, DirectionDataScreen::new);
        }
    }

    private static void initColors() {
        ColorProviderHelper.registerSimpleBlockWithItem(new FoliageBlockColorProvider(), new class_2248[]{BMBlocks.ANCIENT_OAK_LEAVES, BMBlocks.IVY});
        ColorProviderHelper.registerSimpleBlockWithItem(new StaticBlockColorProvider(8694639), new class_2248[]{BMBlocks.SWAMP_CYPRESS_LEAVES});
        ColorProviderHelper.registerSimpleBlockWithItem(new FoliageShiftBlockColorProvider.Lillies(), new class_2248[]{BMBlocks.SMALL_LILY_PAD, class_2246.field_10588, BMBlocks.WATER_LILY});
        ColorProviderHelper.registerSimpleBlockWithItem(new FoliageShiftBlockColorProvider.Willow(), new class_2248[]{BMBlocks.WILLOW_LEAVES, BMBlocks.WILLOWING_BRANCHES});
        ColorProviderHelper.registerSimpleBlockWithItem(new FoliageShiftBlockColorProvider(35, -10, -5), BMBlocks.MOTH_BLOSSOM, BMBlocks.ITCHING_IVY);
    }

    public static void curseSound(AltarBlockEntity altar) {
        AltarCursingSoundInstance sound = new AltarCursingSoundInstance(altar);
        class_310.method_1551().method_1483().method_4873((class_1113)sound);
    }
}

