/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.registry;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltipRenderer;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.config.BlacklistConfig;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.registry.Register;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;

public enum Registrar implements IRegistrar
{
    INSTANCE;

    public final Register<IBlockComponentProvider> blockOverride = new Register();
    public final Register<IBlockComponentProvider> blockIcon = new Register();
    public final Register<IServerDataProvider<class_2586>> blockData = new Register();
    public final Map<TooltipPosition, Register<IBlockComponentProvider>> blockComponent = (Map)class_156.method_654(new EnumMap(TooltipPosition.class), map -> {
        for (TooltipPosition key : TooltipPosition.values()) {
            map.put(key, new Register());
        }
    });
    public final Register<IEntityComponentProvider> entityOverride = new Register();
    public final Register<IEntityComponentProvider> entityIcon = new Register();
    public final Register<IServerDataProvider<class_1297>> entityData = new Register();
    public final Map<TooltipPosition, Register<IEntityComponentProvider>> entityComponent = (Map)class_156.method_654(new EnumMap(TooltipPosition.class), map -> {
        for (TooltipPosition key : TooltipPosition.values()) {
            map.put(key, new Register());
        }
    });
    public final Register<IEventListener> eventListeners = (Register)class_156.method_654(new Register(), Register::reversed);
    public final BlacklistConfig blacklist = new BlacklistConfig();
    private boolean locked = false;
    @Deprecated
    public final Map<class_2960, ITooltipRenderer> renderer = new Object2ObjectOpenHashMap();

    private <T> void addConfig(class_2960 key, T defaultValue, boolean synced, ConfigEntry.Type<T> type) {
        if (!synced && !Waila.CLIENT_SIDE) {
            return;
        }
        this.assertLock();
        PluginConfig.INSTANCE.addConfig(type.create(key, defaultValue, synced));
    }

    @Override
    public void addConfig(class_2960 key, boolean defaultValue) {
        this.addConfig(key, defaultValue, false, ConfigEntry.BOOLEAN);
    }

    @Override
    public void addConfig(class_2960 key, int defaultValue) {
        this.addConfig(key, defaultValue, false, ConfigEntry.INTEGER);
    }

    @Override
    public void addConfig(class_2960 key, double defaultValue) {
        this.addConfig(key, defaultValue, false, ConfigEntry.DOUBLE);
    }

    @Override
    public void addConfig(class_2960 key, String defaultValue) {
        this.addConfig(key, defaultValue, false, ConfigEntry.STRING);
    }

    @Override
    public <T extends Enum<T>> void addConfig(class_2960 key, T defaultValue) {
        this.addConfig(key, defaultValue, false, ConfigEntry.ENUM);
    }

    @Override
    public void addSyncedConfig(class_2960 key, boolean defaultValue) {
        this.addConfig(key, defaultValue, true, ConfigEntry.BOOLEAN);
    }

    @Override
    public void addSyncedConfig(class_2960 key, int defaultValue) {
        this.addConfig(key, defaultValue, true, ConfigEntry.INTEGER);
    }

    @Override
    public void addSyncedConfig(class_2960 key, double defaultValue) {
        this.addConfig(key, defaultValue, true, ConfigEntry.DOUBLE);
    }

    @Override
    public void addSyncedConfig(class_2960 key, String defaultValue) {
        this.addConfig(key, defaultValue, true, ConfigEntry.STRING);
    }

    @Override
    public <T extends Enum<T>> void addSyncedConfig(class_2960 key, T defaultValue) {
        this.addConfig(key, defaultValue, true, ConfigEntry.ENUM);
    }

    @Override
    public void addEventListener(IEventListener listener, int priority) {
        this.assertLock();
        this.eventListeners.add(Object.class, listener, priority);
    }

    @Override
    public void addBlacklist(class_2248 ... blocks) {
        this.assertLock();
        this.blacklist.blocks.addAll(Arrays.asList(blocks));
    }

    @Override
    public void addBlacklist(class_2591<?> ... blockEntityTypes) {
        this.blacklist.blockEntityTypes.addAll(Arrays.asList(blockEntityTypes));
    }

    @Override
    public <T> void addOverride(IBlockComponentProvider provider, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.blockOverride.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addIcon(IBlockComponentProvider provider, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.blockIcon.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addDisplayItem(IBlockComponentProvider provider, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.blockIcon.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addComponent(IBlockComponentProvider provider, TooltipPosition position, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.blockComponent.get((Object)position).add(clazz, provider, priority);
        }
    }

    @Override
    public <T, BE extends class_2586> void addBlockData(IServerDataProvider<BE> provider, Class<T> clazz) {
        this.assertLock();
        this.blockData.add(clazz, provider, 0);
    }

    @Override
    public void addBlacklist(class_1299<?> ... entityTypes) {
        this.assertLock();
        this.blacklist.entityTypes.addAll(Arrays.asList(entityTypes));
    }

    @Override
    public <T> void addOverride(IEntityComponentProvider provider, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.entityOverride.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addIcon(IEntityComponentProvider provider, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.entityIcon.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addDisplayItem(IEntityComponentProvider provider, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.entityIcon.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addComponent(IEntityComponentProvider provider, TooltipPosition position, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.entityComponent.get((Object)position).add(clazz, provider, priority);
        }
    }

    @Override
    public <T, E extends class_1297> void addEntityData(IServerDataProvider<E> provider, Class<T> clazz) {
        this.assertLock();
        this.entityData.add(clazz, provider, 0);
    }

    @Override
    public void addRenderer(class_2960 id, ITooltipRenderer renderer) {
        if (Waila.CLIENT_SIDE) {
            this.renderer.put(id, renderer);
        }
    }

    public void lock() {
        this.locked = true;
        int[] hash = new int[]{0, 0, 0};
        hash[0] = this.hash((Set)this.blacklist.blocks, (class_2378)class_2378.field_11146);
        hash[1] = this.hash(this.blacklist.blockEntityTypes, class_2378.field_11137);
        hash[2] = this.hash((Set)this.blacklist.entityTypes, (class_2378)class_2378.field_11145);
        if (Waila.BLACKLIST_CONFIG.isFileExists() && !Arrays.equals(Waila.BLACKLIST_CONFIG.get().pluginHash, hash)) {
            Waila.BLACKLIST_CONFIG.backup();
        }
        BlacklistConfig newBlacklist = Waila.BLACKLIST_CONFIG.get();
        newBlacklist.pluginHash = hash;
        newBlacklist.blocks.addAll(this.blacklist.blocks);
        newBlacklist.entityTypes.addAll(this.blacklist.entityTypes);
        Waila.BLACKLIST_CONFIG.save();
    }

    private void assertLock() {
        Preconditions.checkState((!this.locked ? 1 : 0) != 0, (Object)"Tried to register new component after the registrar is locked");
    }

    private void assertPriority(int priority) {
        Preconditions.checkArgument((priority >= 0 ? 1 : 0) != 0, (Object)"Priority must be equals or more than 0");
    }

    private <T> int hash(Set<T> set, class_2378<T> registry) {
        return set.stream().map(arg_0 -> registry.method_10221(arg_0)).collect(Collectors.toSet()).hashCode();
    }
}

