/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin;

import com.google.common.base.Suppliers;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginInfo;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.util.ModInfo;
import net.minecraft.class_2960;

public class PluginInfo
implements IPluginInfo {
    private static final Map<class_2960, IPluginInfo> PLUGIN_ID_TO_PLUGIN_INFO = new LinkedHashMap<class_2960, IPluginInfo>();
    private static final Supplier<Map<String, List<IPluginInfo>>> MOD_ID_TO_PLUGIN_INFOS = Suppliers.memoize(() -> PLUGIN_ID_TO_PLUGIN_INFO.values().stream().collect(Collectors.groupingBy(p -> p.getModInfo().getId())));
    private final ModInfo modInfo;
    private final class_2960 pluginId;
    private final IPluginInfo.Side side;
    private final IWailaPlugin initializer;
    private final List<String> requiredModIds;

    private PluginInfo(ModInfo modInfo, class_2960 pluginId, IPluginInfo.Side side, IWailaPlugin initializer, List<String> requiredModIds) {
        this.modInfo = modInfo;
        this.pluginId = pluginId;
        this.side = side;
        this.initializer = initializer;
        this.requiredModIds = requiredModIds;
        PLUGIN_ID_TO_PLUGIN_INFO.put(pluginId, this);
    }

    public static void register(String modId, String pluginIdStr, IPluginInfo.Side side, String initializerStr, List<String> required) {
        try {
            IWailaPlugin initializer = (IWailaPlugin)Class.forName(initializerStr).getConstructor(new Class[0]).newInstance(new Object[0]);
            class_2960 rl = new class_2960(pluginIdStr);
            PLUGIN_ID_TO_PLUGIN_INFO.put(rl, new PluginInfo(ModInfo.get(modId), rl, side, initializer, required));
        }
        catch (Throwable t) {
            Waila.LOGGER.error("Error creating instance of plugin " + pluginIdStr, t);
        }
    }

    public static IPluginInfo get(class_2960 pluginId) {
        return PLUGIN_ID_TO_PLUGIN_INFO.get(pluginId);
    }

    public static Collection<IPluginInfo> getAllFromMod(String modId) {
        return MOD_ID_TO_PLUGIN_INFOS.get().get(modId);
    }

    public static Collection<IPluginInfo> getAll() {
        return PLUGIN_ID_TO_PLUGIN_INFO.values();
    }

    @Override
    public IModInfo getModInfo() {
        return this.modInfo;
    }

    @Override
    public class_2960 getPluginId() {
        return this.pluginId;
    }

    @Override
    public IPluginInfo.Side getSide() {
        return this.side;
    }

    @Override
    public IWailaPlugin getInitializer() {
        return this.initializer;
    }

    @Override
    public List<String> getRequiredModIds() {
        return this.requiredModIds;
    }
}

