/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila;

import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.gui.screen.HomeScreen;
import mcp.mobius.waila.hud.ClientTickHandler;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.service.IClientService;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;

public abstract class WailaClient {
    public static final class_304 OPEN_CONFIG = IClientService.INSTANCE.createKeyBind("config", 320);
    public static final class_304 SHOW_OVERLAY = IClientService.INSTANCE.createKeyBind("show_overlay", 321);
    public static final class_304 TOGGLE_LIQUID = IClientService.INSTANCE.createKeyBind("toggle_liquid", 322);
    public static final class_304 SHOW_RECIPE_INPUT = IClientService.INSTANCE.createKeyBind("show_recipe_input", 323);
    public static final class_304 SHOW_RECIPE_OUTPUT = IClientService.INSTANCE.createKeyBind("show_recipe_output", 324);
    public static Runnable onShowRecipeInput;
    public static Runnable onShowRecipeOutput;

    protected static void onJoinServer() {
        if (!Waila.PACKET.isServerAvailable()) {
            Waila.LOGGER.warn("WTHIT is not found on the server, all syncable config will reset to their default value.");
            PluginConfig.INSTANCE.getSyncableConfigs().forEach(config -> config.setValue(config.getDefaultValue()));
        }
    }

    protected static void onClientTick() {
        class_310 client = class_310.method_1551();
        WailaConfig config = Waila.CONFIG.get();
        ClientTickHandler.tick();
        while (OPEN_CONFIG.method_1436()) {
            client.method_1507((class_437)new HomeScreen(null));
        }
        while (SHOW_OVERLAY.method_1436()) {
            if (config.getGeneral().getDisplayMode() != IWailaConfig.General.DisplayMode.TOGGLE) continue;
            config.getGeneral().setDisplayTooltip(!config.getGeneral().isDisplayTooltip());
        }
        while (TOGGLE_LIQUID.method_1436()) {
            PluginConfig.INSTANCE.set(WailaConstants.CONFIG_SHOW_FLUID, !PluginConfig.INSTANCE.getBoolean(WailaConstants.CONFIG_SHOW_FLUID));
        }
        while (SHOW_RECIPE_INPUT.method_1436() && onShowRecipeInput != null) {
            onShowRecipeInput.run();
        }
        while (SHOW_RECIPE_OUTPUT.method_1436() && onShowRecipeOutput != null) {
            onShowRecipeOutput.run();
        }
    }

    protected static void onItemTooltip(class_1799 stack, List<class_2561> tooltip) {
        if (PluginConfig.INSTANCE.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
                String name = listener.getHoveredItemModName(stack, PluginConfig.INSTANCE);
                if (name == null) continue;
                tooltip.add((class_2561)IWailaConfig.get().getFormatter().modName(name));
                return;
            }
        }
    }
}

