/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.world.structures;

import com.finallion.graveyard.config.StructureConfigEntry;
import com.finallion.graveyard.init.TGEntities;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3037;
import net.minecraft.class_3195;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_3812;
import net.minecraft.class_4966;
import net.minecraft.class_5312;
import net.minecraft.class_5314;
import net.minecraft.class_5483;
import net.minecraft.class_5539;
import net.minecraft.class_6008;
import net.minecraft.class_6012;
import net.minecraft.class_6621;
import net.minecraft.class_6622;
import net.minecraft.class_6834;

public abstract class AbstractGraveyardStructure
extends class_3195<class_3812> {
    private int seed;
    private final StructureConfigEntry config;
    private String structureName;
    public static final class_6012<class_5483.class_1964> MONSTER_SPAWNS = class_6012.method_34989((class_6008[])new class_5483.class_1964[]{new class_5483.class_1964(TGEntities.SKELETON_CREEPER, 35, 1, 1), new class_5483.class_1964(TGEntities.REVENANT, 45, 1, 3), new class_5483.class_1964(TGEntities.GHOUL, 50, 1, 3)});

    public AbstractGraveyardStructure(Codec<class_3812> codec, StructureConfigEntry config, int size, int seed, class_3785 pool, String name) {
        super(codec, context -> {
            if (!AbstractGraveyardStructure.canGenerate((class_6834.class_6835<class_3812>)context, size)) {
                return Optional.empty();
            }
            return AbstractGraveyardStructure.createPiecesGenerator((class_6834.class_6835<class_3812>)context, pool);
        }, class_6621.field_34938);
        this.config = config;
        this.seed = seed;
        this.structureName = name;
    }

    public StructureConfigEntry getStructureConfigEntry() {
        return this.config;
    }

    public class_5314 getStructureFeatureConfiguration() {
        return new class_5314(this.config.spacing, this.config.separation, this.config.salt);
    }

    public abstract class_5312<?, ?> getStructureFeature();

    public String getStructureName() {
        return this.structureName;
    }

    private static boolean canGenerate(class_6834.class_6835<class_3812> context, int size) {
        class_2338 centerOfChunk = context.comp_309().method_33943(0);
        if (!AbstractGraveyardStructure.isTerrainFlat(context.comp_306(), centerOfChunk.method_10263(), centerOfChunk.method_10260(), context.comp_311(), size)) {
            return false;
        }
        return AbstractGraveyardStructure.isWater(context.comp_306(), centerOfChunk.method_10263(), centerOfChunk.method_10260(), context.comp_311(), size);
    }

    public static Optional<class_6622<class_3812>> createPiecesGenerator(class_6834.class_6835<class_3812> context, class_3785 pool) {
        class_2338 blockpos = context.comp_309().method_33943(0);
        class_3812 newConfig = new class_3812(() -> pool, 3);
        class_6834.class_6835 newContext = new class_6834.class_6835(context.comp_306(), context.comp_307(), context.comp_308(), context.comp_309(), (class_3037)newConfig, context.comp_311(), context.comp_312(), context.comp_313(), context.comp_314());
        Optional structurePiecesGenerator = class_3778.method_30419((class_6834.class_6835)newContext, class_3790::new, (class_2338)blockpos, (boolean)false, (boolean)true);
        return structurePiecesGenerator;
    }

    protected static boolean isTerrainFlat(class_2794 generator, int chunkX, int chunkZ, class_5539 heightLimitView, int size) {
        int i1 = generator.method_18028(chunkX, chunkZ, class_2902.class_2903.field_13194, heightLimitView);
        int j1 = generator.method_18028(chunkX, chunkZ + size, class_2902.class_2903.field_13194, heightLimitView);
        int k1 = generator.method_18028(chunkX + size, chunkZ, class_2902.class_2903.field_13194, heightLimitView);
        int o1 = generator.method_18028(chunkX, chunkZ - size, class_2902.class_2903.field_13194, heightLimitView);
        int p1 = generator.method_18028(chunkX - size, chunkZ, class_2902.class_2903.field_13194, heightLimitView);
        class_4966 sample1 = generator.method_26261(chunkX, chunkZ, heightLimitView);
        class_4966 sample2 = generator.method_26261(chunkX, chunkZ + size, heightLimitView);
        class_4966 sample3 = generator.method_26261(chunkX + size, chunkZ, heightLimitView);
        class_4966 sample4 = generator.method_26261(chunkX, chunkZ - size, heightLimitView);
        class_4966 sample5 = generator.method_26261(chunkX - size, chunkZ, heightLimitView);
        if (sample1.method_32892(i1).method_26227().method_15767((class_3494)class_3486.field_15517) || sample2.method_32892(j1).method_26227().method_15767((class_3494)class_3486.field_15517) || sample3.method_32892(k1).method_26227().method_15767((class_3494)class_3486.field_15517) || sample4.method_32892(o1).method_26227().method_15767((class_3494)class_3486.field_15517) || sample5.method_32892(p1).method_26227().method_15767((class_3494)class_3486.field_15517)) {
            return false;
        }
        int minSides = Math.min(Math.min(j1, p1), Math.min(o1, k1));
        int minHeight = Math.min(minSides, i1);
        int maxSides = Math.max(Math.max(j1, p1), Math.max(o1, k1));
        int maxHeight = Math.max(maxSides, i1);
        return Math.abs(maxHeight - minHeight) <= 3;
    }

    protected static boolean isWater(class_2794 generator, int chunkX, int chunkZ, class_5539 heightLimitView, int size) {
        Set biomesInAreaOne = generator.method_12098().method_8763(chunkX, 0, chunkZ, size, generator.method_38276());
        for (class_1959 biome : biomesInAreaOne) {
            if (biome.method_8688() != class_1959.class_1961.field_9367 && biome.method_8688() != class_1959.class_1961.field_9369 && biome.method_8688() != class_1959.class_1961.field_9363) continue;
            return false;
        }
        return true;
    }
}

