/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.util;

import com.finallion.graveyard.util.GraveyardStructure;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_3195;
import net.minecraft.class_5312;
import net.minecraft.class_5321;

public class BiomeInjection {
    public static void addStructureToBiomes(Map<class_3195<?>, Multimap<class_5312<?, ?>, class_5321<class_1959>>> structureToMultiMap, class_2378<class_1959> biomeRegistry) {
        BiomeInjection.addConfiguredStructureEntries(structureToMultiMap, biomeRegistry, GraveyardStructure::addStructures);
    }

    private static void addConfiguredStructureEntries(Map<class_3195<?>, Multimap<class_5312<?, ?>, class_5321<class_1959>>> structureToMultiMap, class_2378<class_1959> biomeRegistry, Consumer<BiomeInjectionHelper> structureAddition) {
        for (Map.Entry biomeEntry : biomeRegistry.method_29722()) {
            structureAddition.accept(new BiomeInjectionHelper(biomeEntry, biomeRegistry, structureToMultiMap));
        }
    }

    public static class BiomeInjectionHelper {
        public final class_1959 biome;
        public final class_5321<class_1959> biomeKey;
        public final class_2378<class_1959> biomeRegistry;
        public final Map<class_3195<?>, Multimap<class_5312<?, ?>, class_5321<class_1959>>> structureToMultiMap;

        public BiomeInjectionHelper(Map.Entry<class_5321<class_1959>, class_1959> biomeEntry, class_2378<class_1959> biomeRegistry, Map<class_3195<?>, Multimap<class_5312<?, ?>, class_5321<class_1959>>> structureToMultiMap) {
            this.biome = biomeEntry.getValue();
            this.biomeKey = biomeEntry.getKey();
            this.biomeRegistry = biomeRegistry;
            this.structureToMultiMap = structureToMultiMap;
        }

        public class_5321<class_1959> getBiomeKey() {
            return (class_5321)this.biomeRegistry.method_29113((Object)this.biome).get();
        }

        public void addStructure(class_5312<?, ?> configuredStructureFeature) {
            this.structureToMultiMap.computeIfAbsent(configuredStructureFeature.field_24835, f -> HashMultimap.create());
            this.structureToMultiMap.get(configuredStructureFeature.field_24835).put(configuredStructureFeature, this.biomeKey);
        }

        public void removeStructure(class_5312<?, ?> configuredStructureFeature) {
            Multimap<class_5312<?, ?>, class_5321<class_1959>> structureFeatureResourceKeyMultimap = this.structureToMultiMap.get(configuredStructureFeature.field_24835);
            structureFeatureResourceKeyMultimap.remove(configuredStructureFeature, this.biomeKey);
        }
    }
}

