/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.entities;

import com.finallion.graveyard.TheGraveyard;
import java.util.EnumSet;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1405;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3763;
import net.minecraft.class_4051;
import net.minecraft.class_5131;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class ReaperEntity
extends class_1588
implements IAnimatable {
    private class_5131 attributeContainer;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private final AnimationBuilder DEATH_ANIMATION = new AnimationBuilder().addAnimation("death", Boolean.valueOf(false));
    private final AnimationBuilder IDLE_ANIMATION = new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true));
    private final AnimationBuilder WALK_ANIMATION = new AnimationBuilder().addAnimation("walk", Boolean.valueOf(true));
    private final AnimationBuilder SPAWN_ANIMATION = new AnimationBuilder().addAnimation("spawn", Boolean.valueOf(false));
    private final AnimationBuilder ATTACK_ANIMATION = new AnimationBuilder().addAnimation("attack", Boolean.valueOf(true));
    protected final byte ANIMATION_IDLE = 0;
    protected final byte ANIMATION_WALK = 1;
    protected final byte ANIMATION_SPAWN = (byte)2;
    protected final byte ANIMATION_DEATH = (byte)3;
    protected final byte ANIMATION_ATTACK = (byte)4;
    protected static final class_2940<Byte> ANIMATION = class_2945.method_12791(ReaperEntity.class, (class_2941)class_2943.field_13319);
    protected static final class_2940<Byte> VEX_FLAGS = class_2945.method_12791(ReaperEntity.class, (class_2941)class_2943.field_13319);
    private static final int CHARGING_FLAG = 1;
    class_1308 owner;
    @Nullable
    private class_2338 bounds;

    public ReaperEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new ReaperMoveControl(this);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VEX_FLAGS, (Object)0);
        this.field_6011.method_12784(ANIMATION, (Object)0);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("BoundX")) {
            this.bounds = new class_2338(nbt.method_10550("BoundX"), nbt.method_10550("BoundY"), nbt.method_10550("BoundZ"));
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.bounds != null) {
            nbt.method_10569("BoundX", this.bounds.method_10263());
            nbt.method_10569("BoundY", this.bounds.method_10264());
            nbt.method_10569("BoundZ", this.bounds.method_10260());
        }
    }

    protected boolean method_5972() {
        return super.method_5972();
    }

    protected boolean burnsInDaylight() {
        return true;
    }

    public boolean method_6049(class_1293 effect) {
        if (effect.method_5579() == class_1294.field_5920) {
            return TheGraveyard.config.mobConfigEntries.get((Object)"reaper").canBeWithered;
        }
        return super.method_6049(effect);
    }

    public void method_6007() {
        if (this.method_5805()) {
            boolean bl;
            boolean bl2 = bl = this.burnsInDaylight() && this.method_5972() && TheGraveyard.config.mobConfigEntries.get((Object)"reaper").canBurnInSunlight;
            if (bl) {
                class_1799 itemStack = this.method_6118(class_1304.field_6169);
                if (!itemStack.method_7960()) {
                    if (itemStack.method_7963()) {
                        itemStack.method_7974(itemStack.method_7919() + this.field_5974.nextInt(2));
                        if (itemStack.method_7919() >= itemStack.method_7936()) {
                            this.method_20235(class_1304.field_6169);
                            this.method_5673(class_1304.field_6169, class_1799.field_8037);
                        }
                    }
                    bl = false;
                }
                if (bl) {
                    this.method_5639(8);
                }
            }
        }
        super.method_6007();
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(4, (class_1352)new ChargeTargetGoal());
        this.field_6201.method_6277(8, (class_1352)new LookAtTargetGoal());
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 3.0f, 1.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1308.class, 8.0f));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[]{class_3763.class}).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new TrackOwnerTargetGoal((class_1314)this));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public class_1310 method_6046() {
        return class_1310.field_6289;
    }

    public void method_5784(class_1313 movementType, class_243 movement) {
        super.method_5784(movementType, movement);
        this.method_5852();
    }

    public void method_5773() {
        this.field_5960 = true;
        super.method_5773();
        this.field_5960 = false;
        this.method_5875(true);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        this.setAnimation((byte)2);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        AnimationController controller = event.getController();
        float limbSwingAmount = event.getLimbSwingAmount();
        boolean isMoving = !(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.05f);
        boolean isDying = this.method_29504();
        boolean isAttacking = this.method_6510();
        if (isDying) {
            controller.setAnimation(this.DEATH_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (isAttacking || this.isCharging()) {
            controller.setAnimation(this.ATTACK_ANIMATION);
            return PlayState.CONTINUE;
        }
        byte currentAnimation = this.getAnimation();
        switch (currentAnimation) {
            case 4: {
                controller.setAnimation(this.ATTACK_ANIMATION);
                break;
            }
            default: {
                controller.setAnimation(isMoving ? this.WALK_ANIMATION : this.IDLE_ANIMATION);
            }
        }
        return PlayState.CONTINUE;
    }

    @Nullable
    public class_2338 getBounds() {
        return this.bounds;
    }

    private boolean areFlagsSet(int mask) {
        byte i = (Byte)this.field_6011.method_12789(VEX_FLAGS);
        return (i & mask) != 0;
    }

    private void setVexFlag(int mask, boolean value) {
        int i = ((Byte)this.field_6011.method_12789(VEX_FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.field_6011.method_12778(VEX_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.areFlagsSet(1);
    }

    public void setCharging(boolean charging) {
        this.setVexFlag(1, charging);
    }

    public class_5131 method_6127() {
        if (this.attributeContainer == null) {
            this.attributeContainer = new class_5131(class_1588.method_26918().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23721, 4.0).method_26866());
        }
        return this.attributeContainer;
    }

    public byte getAnimation() {
        return (Byte)this.field_6011.method_12789(ANIMATION);
    }

    public void setAnimation(byte animation) {
        this.field_6011.method_12778(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void method_5966() {
        this.method_5783(class_3417.field_14812, 1.0f, -10.0f);
    }

    protected void method_6013(class_1282 source) {
        this.method_5783(class_3417.field_15072, 1.0f, -10.0f);
    }

    public void method_6078(class_1282 source) {
        super.method_6078(source);
        this.method_5783(class_3417.field_14964, 1.0f, -10.0f);
    }

    private class ReaperMoveControl
    extends class_1335 {
        public ReaperMoveControl(ReaperEntity owner) {
            super((class_1308)owner);
        }

        public void method_6240() {
            if (this.field_6374 == class_1335.class_1336.field_6378) {
                class_243 vec3d = new class_243(this.field_6370 - ReaperEntity.this.method_23317(), this.field_6369 - ReaperEntity.this.method_23318(), this.field_6367 - ReaperEntity.this.method_23321());
                double d = vec3d.method_1033();
                if (d < ReaperEntity.this.method_5829().method_995()) {
                    this.field_6374 = class_1335.class_1336.field_6377;
                    ReaperEntity.this.method_18799(ReaperEntity.this.method_18798().method_1021(0.5));
                } else {
                    ReaperEntity.this.method_18799(ReaperEntity.this.method_18798().method_1019(vec3d.method_1021(this.field_6372 * 0.05 / d)));
                    if (ReaperEntity.this.method_5968() == null) {
                        class_243 vec3d2 = ReaperEntity.this.method_18798();
                        ReaperEntity.this.method_36456(-((float)class_3532.method_15349((double)vec3d2.field_1352, (double)vec3d2.field_1350)) * 57.295776f);
                        ReaperEntity.this.field_6283 = ReaperEntity.this.method_36454();
                    } else {
                        double e = ReaperEntity.this.method_5968().method_23317() - ReaperEntity.this.method_23317();
                        double f = ReaperEntity.this.method_5968().method_23321() - ReaperEntity.this.method_23321();
                        ReaperEntity.this.method_36456(-((float)class_3532.method_15349((double)e, (double)f)) * 57.295776f);
                        ReaperEntity.this.field_6283 = ReaperEntity.this.method_36454();
                    }
                }
            }
        }
    }

    class ChargeTargetGoal
    extends class_1352 {
        public ChargeTargetGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (ReaperEntity.this.method_5968() != null && !ReaperEntity.this.method_5962().method_6241() && ReaperEntity.this.field_5974.nextInt(7) == 0) {
                return ReaperEntity.this.method_5858((class_1297)ReaperEntity.this.method_5968()) > 4.0;
            }
            return false;
        }

        public boolean method_6266() {
            return ReaperEntity.this.method_5962().method_6241() && ReaperEntity.this.isCharging() && ReaperEntity.this.method_5968() != null && ReaperEntity.this.method_5968().method_5805();
        }

        public void method_6269() {
            class_1309 livingEntity = ReaperEntity.this.method_5968();
            class_243 vec3d = livingEntity.method_33571();
            ReaperEntity.this.field_6207.method_6239(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, 1.0);
            ReaperEntity.this.setCharging(true);
            ReaperEntity.this.method_5783(class_3417.field_14898, 1.0f, -10.0f);
        }

        public void method_6270() {
            ReaperEntity.this.setCharging(false);
        }

        public void method_6268() {
            class_1309 livingEntity = ReaperEntity.this.method_5968();
            if (ReaperEntity.this.method_5829().method_994(livingEntity.method_5829())) {
                ReaperEntity.this.method_6121((class_1297)livingEntity);
                ReaperEntity.this.setCharging(false);
            } else {
                double d = ReaperEntity.this.method_5858((class_1297)livingEntity);
                if (d < 9.0) {
                    class_243 vec3d = livingEntity.method_33571();
                    ReaperEntity.this.field_6207.method_6239(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, 1.0);
                }
            }
        }
    }

    private class LookAtTargetGoal
    extends class_1352 {
        public LookAtTargetGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return !ReaperEntity.this.method_5962().method_6241() && ReaperEntity.this.field_5974.nextInt(7) == 0;
        }

        public boolean method_6266() {
            return false;
        }

        public void method_6268() {
            class_2338 blockPos = ReaperEntity.this.getBounds();
            if (blockPos == null) {
                blockPos = ReaperEntity.this.method_24515();
            }
            for (int i = 0; i < 3; ++i) {
                class_2338 blockPos2 = blockPos.method_10069(ReaperEntity.this.field_5974.nextInt(15) - 7, ReaperEntity.this.field_5974.nextInt(11) - 5, ReaperEntity.this.field_5974.nextInt(15) - 7);
                if (!ReaperEntity.this.field_6002.method_22347(blockPos2)) continue;
                ReaperEntity.this.field_6207.method_6239((double)blockPos2.method_10263() + 0.5, (double)blockPos2.method_10264() + 0.5, (double)blockPos2.method_10260() + 0.5, 0.25);
                if (ReaperEntity.this.method_5968() != null) break;
                ReaperEntity.this.method_5988().method_6230((double)blockPos2.method_10263() + 0.5, (double)blockPos2.method_10264() + 0.5, (double)blockPos2.method_10260() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class TrackOwnerTargetGoal
    extends class_1405 {
        private final class_4051 TRACK_OWNER_PREDICATE;

        public TrackOwnerTargetGoal(class_1314 mob) {
            super((class_1308)mob, false);
            this.TRACK_OWNER_PREDICATE = class_4051.method_36626().method_36627().method_18424();
        }

        public boolean method_6264() {
            return ReaperEntity.this.owner != null && ReaperEntity.this.owner.method_5968() != null && this.method_6328(ReaperEntity.this.owner.method_5968(), this.TRACK_OWNER_PREDICATE);
        }

        public void method_6269() {
            ReaperEntity.this.method_5980(ReaperEntity.this.owner.method_5968());
            super.method_6269();
        }
    }
}

