/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.entities;

import com.finallion.graveyard.TheGraveyard;
import java.util.EnumSet;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1284;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1560;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_4802;
import net.minecraft.class_5131;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import net.minecraft.class_6019;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class NightmareEntity
extends class_1588
implements IAnimatable,
class_5354 {
    private class_5131 attributeContainer;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private final AnimationBuilder DEATH_ANIMATION = new AnimationBuilder().addAnimation("death", Boolean.valueOf(false));
    private final AnimationBuilder IDLE_ANIMATION = new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true));
    private final AnimationBuilder WALK_ANIMATION = new AnimationBuilder().addAnimation("walk", Boolean.valueOf(true));
    private final AnimationBuilder ATTACK_ANIMATION = new AnimationBuilder().addAnimation("attack", Boolean.valueOf(true));
    protected static final byte ANIMATION_IDLE = 0;
    protected static final byte ANIMATION_WALK = 1;
    protected static final byte ANIMATION_DEATH = 3;
    protected static final byte ANIMATION_ATTACK = 5;
    protected static final class_2940<Byte> ANIMATION = class_2945.method_12791(NightmareEntity.class, (class_2941)class_2943.field_13319);
    private static boolean isInRange = false;
    private static final double ATTACK_RANGE = 5.5;
    private static final class_2940<Boolean> ANGRY = class_2945.method_12791(class_1560.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> PROVOKED = class_2945.method_12791(class_1560.class, (class_2941)class_2943.field_13323);
    private static final class_6019 ANGER_TIME = class_4802.method_24505((int)20, (int)39);
    private UUID target;
    private int angerTime;
    private int ageWhenTargetSet;
    private int lastAngrySoundAge = Integer.MIN_VALUE;

    public NightmareEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6013 = 1.0f;
    }

    public static boolean canSpawn(class_1299<? extends class_1588> type, class_5425 world, class_3730 spawnReason, class_2338 pos, Random random) {
        return NightmareEntity.method_20679((class_5425)world, (class_2338)pos, (Random)random);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ANGRY, (Object)false);
        this.field_6011.method_12784(PROVOKED, (Object)false);
        this.field_6011.method_12784(ANIMATION, (Object)0);
    }

    public int getAnimationState() {
        return ((Byte)this.field_6011.method_12789(ANIMATION)).byteValue();
    }

    public void setState(byte time) {
        this.field_6011.method_12778(ANIMATION, (Object)time);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new ChasePlayerGoal(this));
        this.field_6201.method_6277(2, (class_1352)new NightmareMeleeAttackGoal(this, 1.0, false));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0, 0.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new TeleportTowardsPlayerGoal(this, arg_0 -> ((NightmareEntity)this).method_29515(arg_0)));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(4, (class_1352)new class_5398((class_1308)this, false));
    }

    protected void method_5958() {
        float f;
        if (this.field_6002.method_8530() && this.field_6012 >= this.ageWhenTargetSet + 600 && (f = this.method_5718()) > 0.5f && this.field_6002.method_8311(this.method_24515()) && this.field_5974.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.method_5980(null);
            this.teleportRandomly();
        }
        super.method_5958();
    }

    protected boolean method_5972() {
        return super.method_5972();
    }

    protected boolean burnsInDaylight() {
        return true;
    }

    public boolean method_6049(class_1293 effect) {
        if (effect.method_5579() == class_1294.field_5920) {
            return TheGraveyard.config.mobConfigEntries.get((Object)"nightmare").canBeWithered;
        }
        return super.method_6049(effect);
    }

    public void method_6007() {
        this.isInAttackDistance();
        this.stopAttackAnimation();
        this.field_6282 = false;
        if (!this.field_6002.field_9236) {
            if (this.method_5968() != null && this.method_5968().method_5858((class_1297)this) >= 1024.0) {
                this.method_29922();
            }
            this.method_29510((class_3218)this.field_6002, true);
        }
        if (this.method_5805()) {
            boolean bl;
            boolean bl2 = bl = this.burnsInDaylight() && this.method_5972() && TheGraveyard.config.mobConfigEntries.get((Object)"nightmare").canBurnInSunlight;
            if (bl) {
                class_1799 itemStack = this.method_6118(class_1304.field_6169);
                if (!itemStack.method_7960()) {
                    if (itemStack.method_7963()) {
                        itemStack.method_7974(itemStack.method_7919() + this.field_5974.nextInt(2));
                        if (itemStack.method_7919() >= itemStack.method_7936()) {
                            this.method_20235(class_1304.field_6169);
                            this.method_5673(class_1304.field_6169, class_1799.field_8037);
                        }
                    }
                    bl = false;
                }
                if (bl) {
                    this.method_5639(8);
                }
            }
        }
        super.method_6007();
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        this.method_29517(nbt);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.method_29512(this.field_6002, nbt);
    }

    private void isInAttackDistance() {
        if (this.method_5968() != null && this.method_5968().method_5858((class_1297)this) > 5.5) {
            isInRange = false;
            this.setState((byte)0);
        }
    }

    private void stopAttackAnimation() {
        if (!this.method_29511()) {
            this.setState((byte)0);
        }
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        boolean isMoving;
        float limbSwingAmount = event.getLimbSwingAmount();
        boolean bl = isMoving = !(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.05f);
        if (this.method_29504()) {
            event.getController().setAnimation(this.DEATH_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (this.getAnimationState() == 5 && !this.method_29504() && !((double)this.method_6032() < 0.01)) {
            event.getController().setAnimation(this.ATTACK_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (event.isMoving() || isMoving) {
            event.getController().setAnimation(this.WALK_ANIMATION);
        } else {
            event.getController().setAnimation(this.IDLE_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    public class_5131 method_6127() {
        if (this.attributeContainer == null) {
            this.attributeContainer = new class_5131(class_1588.method_26918().method_26868(class_5134.field_23716, 50.0).method_26868(class_5134.field_23721, 10.0).method_26868(class_5134.field_23719, 0.19).method_26868(class_5134.field_23717, 64.0).method_26866());
        }
        return this.attributeContainer;
    }

    protected void method_6108() {
        ++this.field_6213;
        if (this.field_6213 == 28 && !this.field_6002.method_8608()) {
            this.field_6002.method_8421((class_1297)this, (byte)60);
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (source instanceof class_1284) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    public byte getAnimation() {
        return (Byte)this.field_6011.method_12789(ANIMATION);
    }

    public void setAnimation(byte animation) {
        this.field_6011.method_12778(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void method_5966() {
        this.method_5783(class_3417.field_14696, 1.0f, -10.0f);
    }

    protected void method_6013(class_1282 source) {
        this.method_5783(class_3417.field_14797, 1.0f, -10.0f);
    }

    public void method_6078(class_1282 source) {
        super.method_6078(source);
        this.method_5783(class_3417.field_14608, 1.0f, -10.0f);
    }

    boolean isPlayerStaring(class_1657 player) {
        class_1799 itemStack = (class_1799)player.method_31548().field_7548.get(3);
        if (itemStack.method_31574(class_2246.field_10147.method_8389())) {
            return false;
        }
        class_243 vec3d = player.method_5828(1.0f).method_1029();
        class_243 vec3d2 = new class_243(this.method_23317() - player.method_23317(), this.method_23320() - player.method_23320(), this.method_23321() - player.method_23321());
        double d = vec3d2.method_1033();
        double e = vec3d.method_1026(vec3d2 = vec3d2.method_1029());
        if (e > 1.0 - 0.025 / d) {
            return player.method_6057((class_1297)this);
        }
        return false;
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return 2.55f;
    }

    boolean teleportTo(class_1297 entity) {
        class_243 vec3d = new class_243(this.method_23317() - entity.method_23317(), this.method_23323(0.5) - entity.method_23320(), this.method_23321() - entity.method_23321());
        vec3d = vec3d.method_1029();
        double e = this.method_23317() + (this.field_5974.nextDouble() - 0.5) * 2.0 - vec3d.field_1352 * 16.0;
        double f = this.method_23318() + (double)(this.field_5974.nextInt(4) - 2) - vec3d.field_1351 * 16.0;
        double g = this.method_23321() + (this.field_5974.nextDouble() - 0.5) * 2.0 - vec3d.field_1350 * 16.0;
        return this.teleportTo(e, f, g);
    }

    private boolean teleportTo(double x, double y, double z) {
        class_2338.class_2339 mutable = new class_2338.class_2339(x, y, z);
        while (mutable.method_10264() > this.field_6002.method_31607() && !this.field_6002.method_8320((class_2338)mutable).method_26207().method_15801()) {
            mutable.method_10098(class_2350.field_11033);
        }
        class_2680 blockState = this.field_6002.method_8320((class_2338)mutable);
        boolean bl = blockState.method_26207().method_15801();
        boolean bl2 = blockState.method_26227().method_15767((class_3494)class_3486.field_15517);
        if (bl && !bl2) {
            boolean bl3 = this.method_6082(x, y, z, false);
            if (bl3 && !this.method_5701()) {
                this.method_5783(class_3417.field_14879, 1.0f, -10.0f);
            }
            return bl3;
        }
        return false;
    }

    protected boolean teleportRandomly() {
        if (!this.field_6002.method_8608() && this.method_5805()) {
            double d = this.method_23317() + (this.field_5974.nextDouble() - 0.5) * 64.0;
            double e = this.method_23318() + (double)(this.field_5974.nextInt(64) - 32);
            double f = this.method_23321() + (this.field_5974.nextDouble() - 0.5) * 64.0;
            return this.teleportTo(d, e, f);
        }
        return false;
    }

    public boolean method_29511() {
        return (Boolean)this.field_6011.method_12789(ANGRY);
    }

    public void method_29514(int ticks) {
        this.angerTime = ticks;
    }

    public int method_29507() {
        return this.angerTime;
    }

    public void setProvoked() {
        this.field_6011.method_12778(PROVOKED, (Object)true);
    }

    @Nullable
    public UUID method_29508() {
        return this.target;
    }

    public boolean isProvoked() {
        return (Boolean)this.field_6011.method_12789(PROVOKED);
    }

    public void method_29513(@Nullable UUID uuid) {
        this.target = uuid;
    }

    public void method_29509() {
        this.method_29514(ANGER_TIME.method_35008(this.field_5974));
    }

    public void method_5980(@Nullable class_1309 target) {
        super.method_5980(target);
        if (target == null) {
            this.ageWhenTargetSet = 0;
            this.field_6011.method_12778(ANGRY, (Object)false);
            this.method_29514(0);
            this.field_6011.method_12778(PROVOKED, (Object)false);
        } else {
            this.ageWhenTargetSet = this.field_6012;
            this.field_6011.method_12778(ANGRY, (Object)true);
        }
    }

    public void playAngrySound() {
        if (this.field_6012 >= this.lastAngrySoundAge + 400) {
            this.lastAngrySoundAge = this.field_6012;
            if (!this.method_5701()) {
                this.field_6002.method_8486(this.method_23317(), this.method_23320(), this.method_23321(), class_3417.field_14967, this.method_5634(), 2.0f, -10.0f, false);
            }
        }
    }

    public void method_5674(class_2940<?> data) {
        if (ANGRY.equals(data) && this.isProvoked() && this.field_6002.field_9236) {
            this.playAngrySound();
        }
        super.method_5674(data);
    }

    static class ChasePlayerGoal
    extends class_1352 {
        private final NightmareEntity nightmare;
        @Nullable
        private class_1309 target;

        public ChasePlayerGoal(NightmareEntity nightmare) {
            this.nightmare = nightmare;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18407, class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            this.target = this.nightmare.method_5968();
            if (!(this.target instanceof class_1657)) {
                return false;
            }
            double d = this.target.method_5858((class_1297)this.nightmare);
            return d > 256.0 ? false : this.nightmare.isPlayerStaring((class_1657)this.target);
        }

        public void method_6269() {
            this.nightmare.method_5942().method_6340();
        }

        public void method_6268() {
            this.nightmare.method_5988().method_20248(this.target.method_23317(), this.target.method_23320(), this.target.method_23321());
        }
    }

    static class NightmareMeleeAttackGoal
    extends class_1366 {
        private final NightmareEntity nightmare;
        private static final int ATTACK_DURATION = 20;
        private int attackTimer = 0;

        public NightmareMeleeAttackGoal(NightmareEntity nightmareEntity, double speed, boolean pauseWhenIdle) {
            super((class_1314)nightmareEntity, speed, pauseWhenIdle);
            this.nightmare = nightmareEntity;
        }

        public void method_6268() {
            class_1309 livingEntity = this.field_6503.method_5968();
            isInRange = false;
            if (livingEntity != null) {
                double squaredDistance = this.field_6503.method_5649(livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321());
                isInRange = squaredDistance < 5.5;
            }
            super.method_6268();
        }

        protected void method_6288(class_1309 target, double squaredDistance) {
            double d = 5.5;
            if (squaredDistance <= d && this.attackTimer <= 0) {
                this.nightmare.setState((byte)5);
                this.attackTimer = 20;
                this.field_6503.method_6121((class_1297)target);
                --this.attackTimer;
            }
            if (this.attackTimer > 0) {
                --this.attackTimer;
                if (this.attackTimer == 0) {
                    this.nightmare.setState((byte)1);
                }
            }
        }

        public void method_6270() {
            super.method_6270();
            this.attackTimer = 0;
        }
    }

    static class TeleportTowardsPlayerGoal
    extends class_1400<class_1657> {
        private final NightmareEntity nightmare;
        @Nullable
        private class_1657 targetPlayer;
        private int lookAtPlayerWarmup;
        private int ticksSinceUnseenTeleport;
        private final class_4051 staringPlayerPredicate;
        private final class_4051 validTargetPredicate = class_4051.method_36625().method_36627();

        public TeleportTowardsPlayerGoal(NightmareEntity nightmare, @Nullable Predicate<class_1309> targetPredicate) {
            super((class_1308)nightmare, class_1657.class, 10, false, false, targetPredicate);
            this.nightmare = nightmare;
            this.staringPlayerPredicate = class_4051.method_36625().method_18418(this.method_6326()).method_18420(playerEntity -> nightmare.isPlayerStaring((class_1657)playerEntity));
        }

        public boolean method_6264() {
            this.targetPlayer = this.nightmare.field_6002.method_18462(this.staringPlayerPredicate, (class_1309)this.nightmare);
            return this.targetPlayer != null;
        }

        public void method_6269() {
            this.lookAtPlayerWarmup = this.method_38847(5);
            this.ticksSinceUnseenTeleport = 0;
            this.nightmare.setProvoked();
        }

        public void method_6270() {
            this.targetPlayer = null;
            super.method_6270();
        }

        public boolean method_6266() {
            if (this.targetPlayer != null) {
                if (!this.nightmare.isPlayerStaring(this.targetPlayer)) {
                    return false;
                }
                this.nightmare.method_5951((class_1297)this.targetPlayer, 10.0f, 10.0f);
                return true;
            }
            return this.field_6644 != null && this.validTargetPredicate.method_18419((class_1309)this.nightmare, this.field_6644) ? true : super.method_6266();
        }

        public void method_6268() {
            if (this.nightmare.method_5968() == null) {
                super.method_24632((class_1309)null);
            }
            if (this.targetPlayer != null) {
                if (--this.lookAtPlayerWarmup <= 0) {
                    this.field_6644 = this.targetPlayer;
                    this.targetPlayer = null;
                    super.method_6269();
                }
            } else {
                if (this.field_6644 != null && !this.nightmare.method_5765()) {
                    if (this.nightmare.isPlayerStaring((class_1657)this.field_6644)) {
                        if (this.field_6644.method_5858((class_1297)this.nightmare) <= 384.0 && this.field_6644 != null && this.field_6644.method_5858((class_1297)this.nightmare) > 24.0) {
                            this.field_6644.method_6092(new class_1293(class_1294.field_5919, 100));
                            this.nightmare.teleportTo((class_1297)this.field_6644);
                        }
                        this.ticksSinceUnseenTeleport = 0;
                    } else if (this.field_6644.method_5858((class_1297)this.nightmare) > 256.0 && this.ticksSinceUnseenTeleport++ >= this.method_38847(80) && this.nightmare.teleportTo((class_1297)this.field_6644)) {
                        this.ticksSinceUnseenTeleport = 0;
                    }
                }
                super.method_6268();
            }
        }
    }
}

