/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.config;

import com.finallion.graveyard.config.HordeConfigEntry;
import com.finallion.graveyard.config.MobConfigEntry;
import com.finallion.graveyard.config.ParticleConfigEntry;
import com.finallion.graveyard.config.StructureConfigEntry;
import com.finallion.graveyard.init.TGStructures;
import com.finallion.graveyard.world.structures.AbstractGraveyardStructure;
import draylar.omegaconfig.api.Comment;
import draylar.omegaconfig.api.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_4766;
import net.minecraft.class_5458;

public class GraveyardConfig
implements Config {
    @Comment(value=" Welcome to The Graveyard Config!\n\n Structures:\n Configure separation (Minimum distance between two structures of this type in chunks. Must be less than spacing).\n Configure spacing (Average distance between two structure placement attempts of this type in chunks).\n Configure whitelist: use \"#biomeCategory\" for biome categories and \"minecraft:biome\" for biomes (mod identifier + \":\" + biome name).\n Configure blacklist: use \"#biomeCategory\" for biome categories and \"minecraft:biome\" for biomes (mod identifier + \":\" + biome name).\n Configure mod whitelist: use \"#modid\" to whitelist the biomes of the specified mod for structures to spawn in (examples: #minecraft, #graveyard, #graveyard_biomes, #terralith, #byg, #bop).\n Valid vanilla biome categories are: #taiga, #extreme_hills, #jungle, #mesa, #plains, #savanna, #icy, #beach, #forest, #desert, #swamp, #mushroom, #underground, #mountain.\n A full list of all the biomes can be found here https:minecraft.fandom.com/wiki/Biome#Biome_IDs.\n\n Mobs:\n Configure spawning weight and group size of the spawn.\n Configure if mobs burn in sunlight and/or if mobs are affected by the wither effect.\n Configure whitelist: use \"#biomeCategory\" for biome categories and \"minecraft:biome\" for biomes (mod identifier + \":\" + biome name).\n Configure blacklist: use \"#biomeCategory\" for biome categories and \"minecraft:biome\" for biomes (mod identifier + \":\" + biome name).\n Configure mod whitelist: use \"#modid\" to whitelist the biomes of the specified mod for structures to spawn in (examples: #minecraft, #graveyard, #graveyard_biomes, #terralith, #byg, #bop).\n\n Additional:\n Configure graveyard fog particles rising from moss and set the chance of spawning them (higher numbers = lower chance of spawning).\n Configure if hordes of graveyard mobs can spawn and set their size and frequency.\n Configure if urns have a double chest inventory.\n\n")
    public final Map<String, StructureConfigEntry> structureConfigEntries = new HashMap<String, StructureConfigEntry>();
    public final Map<String, ParticleConfigEntry> particleConfigEntries = new HashMap<String, ParticleConfigEntry>(1);
    public final Map<String, MobConfigEntry> mobConfigEntries = new HashMap<String, MobConfigEntry>();
    public final Map<String, HordeConfigEntry> hordeConfigEntries = new HashMap<String, HordeConfigEntry>();
    public final Map<String, Boolean> booleanEntries = new HashMap<String, Boolean>();

    public String getName() {
        return "the-graveyard-config";
    }

    public String getExtension() {
        return "json5";
    }

    public boolean enabled(class_2960 id) {
        return this.getStructure((class_2960)id).enabled;
    }

    public boolean fogSpawn(class_2960 id) {
        return this.getParticle((class_2960)id).canGenerate;
    }

    public StructureConfigEntry getStructure(class_2960 id) {
        for (Map.Entry<String, StructureConfigEntry> entry : this.structureConfigEntries.entrySet()) {
            if (!entry.getKey().equals(id.method_12832())) continue;
            return entry.getValue();
        }
        throw new NullPointerException("Tried StructureConfigEntry with id: " + id + ", but it was null!");
    }

    public ParticleConfigEntry getParticle(class_2960 id) {
        for (Map.Entry<String, ParticleConfigEntry> entry : this.particleConfigEntries.entrySet()) {
            if (!entry.getKey().equals(id.method_12832())) continue;
            return entry.getValue();
        }
        throw new NullPointerException("Tried ParticleConfigEntry with id: " + id + ", but it was null!");
    }

    public MobConfigEntry getMob(class_2960 id) {
        for (Map.Entry<String, MobConfigEntry> entry : this.mobConfigEntries.entrySet()) {
            if (!entry.getKey().equals(id.method_12832())) continue;
            return entry.getValue();
        }
        throw new NullPointerException("Tried MobConfigEntry with id: " + id + ", but it was null!");
    }

    public HordeConfigEntry getHorde(class_2960 id) {
        for (Map.Entry<String, HordeConfigEntry> entry : this.hordeConfigEntries.entrySet()) {
            if (!entry.getKey().equals(id.method_12832())) continue;
            return entry.getValue();
        }
        throw new NullPointerException("Tried HordeConfigEntry with id: " + id + ", but it was null!");
    }

    public void save() {
        this.booleanEntries.putIfAbsent("urnHasDoubleInventory", true);
        for (class_3195<?> structure : this.getStructures()) {
            AbstractGraveyardStructure abstractStructure = (AbstractGraveyardStructure)structure;
            StructureConfigEntry entry = abstractStructure.getStructureConfigEntry();
            this.structureConfigEntries.putIfAbsent(abstractStructure.getStructureName(), entry);
        }
        this.mobConfigEntries.putIfAbsent("ghoul", MobConfigEntry.of(true, 25, 2, 5, true, false, this.getAllOverworldBiomeCategories(), Arrays.asList("minecraft:flower_forest", "minecraft:lush_caves"), Arrays.asList("#minecraft", "#graveyard_biomes")));
        this.mobConfigEntries.putIfAbsent("revenant", MobConfigEntry.of(true, 25, 5, 8, true, false, this.getAllOverworldBiomeCategories(), Arrays.asList("minecraft:flower_forest", "minecraft:lush_caves"), Arrays.asList("#minecraft", "#graveyard_biomes")));
        this.mobConfigEntries.putIfAbsent("nightmare", MobConfigEntry.of(true, 10, 1, 1, false, false, this.getAllOverworldBiomeCategories(), Arrays.asList("minecraft:flower_forest", "minecraft:lush_caves"), Arrays.asList("#minecraft", "#graveyard_biomes")));
        this.mobConfigEntries.putIfAbsent("skeleton_creeper", MobConfigEntry.of(true, 25, 1, 4, true, false, this.getAllOverworldBiomeCategories(), Arrays.asList("minecraft:flower_forest", "minecraft:lush_caves"), Arrays.asList("#minecraft", "#graveyard_biomes")));
        this.mobConfigEntries.putIfAbsent("acolyte", MobConfigEntry.of(false, 0, 2, 3, false, false, this.getAllOverworldBiomeCategories(), Arrays.asList("minecraft:flower_forest", "minecraft:lush_caves"), Arrays.asList("#minecraft", "#graveyard_biomes")));
        this.mobConfigEntries.putIfAbsent("reaper", MobConfigEntry.of(true, 10, 2, 3, true, false, Arrays.asList("graveyard_biomes:eroded_haunted_forest"), Arrays.asList("minecraft:flower_forest", "minecraft:lush_caves"), Arrays.asList("#minecraft", "#graveyard_biomes")));
        this.particleConfigEntries.putIfAbsent("graveyard_fog_particle", ParticleConfigEntry.of(50));
        this.hordeConfigEntries.putIfAbsent("horde_spawn", HordeConfigEntry.of(40, 24000));
        super.save();
    }

    private List<class_3195<?>> getStructures() {
        ArrayList structures = new ArrayList();
        structures.add(TGStructures.MEDIUM_GRAVEYARD_STRUCTURE);
        structures.add(TGStructures.SMALL_GRAVEYARD_STRUCTURE);
        structures.add(TGStructures.LARGE_GRAVEYARD_STRUCTURE);
        structures.add(TGStructures.MUSHROOM_GRAVE_STRUCTURE);
        structures.add(TGStructures.HAUNTED_HOUSE_STRUCTURE);
        structures.add(TGStructures.MEMORIAL_TREE_STRUCTURE);
        structures.add(TGStructures.SMALL_DESERT_GRAVEYARD_STRUCTURE);
        structures.add(TGStructures.SMALL_GRAVE_STRUCTURE);
        structures.add(TGStructures.SMALL_DESERT_GRAVE_STRUCTURE);
        structures.add(TGStructures.SMALL_SAVANNA_GRAVE_STRUCTURE);
        structures.add(TGStructures.SMALL_MOUNTAIN_GRAVE_STRUCTURE);
        return structures;
    }

    private List<String> getAllOverworldBiomes() {
        Set biomes = class_4766.class_5305.field_34499.method_28469(class_5458.field_25933).method_28443();
        ArrayList<String> biomeNames = new ArrayList<String>();
        for (class_1959 biome : biomes) {
            biomeNames.add(biome.toString());
        }
        return biomeNames;
    }

    private List<String> getAllOverworldBiomeCategories() {
        class_1959.class_1961[] biomeCategory = class_1959.class_1961.values();
        ArrayList<String> biomeNames = new ArrayList<String>();
        for (class_1959.class_1961 biome : biomeCategory) {
            if (biome.method_8749().contains("river") || biome.method_8749().contains("ocean") || biome.method_8749().contains("none") || biome.method_8749().contains("the_end") || biome.method_8749().contains("nether") || biome.method_8749().contains("mushroom")) continue;
            biomeNames.add("#" + biome.method_8749());
        }
        return biomeNames;
    }
}

