/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.blocks;

import com.finallion.graveyard.blockentities.SarcophagusBlockEntity;
import com.finallion.graveyard.blockentities.enums.SarcophagusPart;
import com.finallion.graveyard.blocks.AbstractCoffinBlock;
import com.finallion.graveyard.init.TGBlocks;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiPredicate;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2618;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4732;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class SarcophagusBlock
extends AbstractCoffinBlock<SarcophagusBlockEntity>
implements class_3737,
class_2343 {
    public static final class_2746 WATERLOGGED;
    public static final class_2746 OPEN;
    public static final class_2753 FACING;
    protected static final class_265 DOUBLE_NORTH_SHAPE;
    protected static final class_265 DOUBLE_SOUTH_SHAPE;
    protected static final class_265 DOUBLE_WEST_SHAPE;
    protected static final class_265 DOUBLE_EAST_SHAPE;
    public static final class_2754<SarcophagusPart> PART;
    private boolean isCoffin;

    public SarcophagusBlock(class_4970.class_2251 settings, boolean isCoffin) {
        super(settings, () -> TGBlocks.SARCOPHAGUS_BLOCK_ENTITY);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false))).method_11657(PART, (Comparable)((Object)SarcophagusPart.FOOT)));
        this.isCoffin = isCoffin;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED, OPEN, FACING, PART});
    }

    @Nullable
    public static class_2350 getDirection(class_1922 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        return blockState.method_26204() instanceof SarcophagusBlock ? (class_2350)blockState.method_11654((class_2769)FACING) : null;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction == SarcophagusBlock.getDirectionTowardsOtherPart((SarcophagusPart)((Object)state.method_11654(PART)), (class_2350)state.method_11654((class_2769)FACING))) {
            return neighborState.method_27852((class_2248)this) && neighborState.method_11654(PART) != state.method_11654(PART) ? state : class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    private static class_2350 getDirectionTowardsOtherPart(SarcophagusPart part, class_2350 direction) {
        return part == SarcophagusPart.FOOT ? direction : direction.method_10153();
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        switch ((class_2350)state.method_11654((class_2769)FACING)) {
            default: {
                return DOUBLE_NORTH_SHAPE;
            }
            case field_11035: {
                return DOUBLE_SOUTH_SHAPE;
            }
            case field_11039: {
                return DOUBLE_WEST_SHAPE;
            }
            case field_11034: 
        }
        return DOUBLE_EAST_SHAPE;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 blockEntity;
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        if (state.method_11654(PART) == SarcophagusPart.HEAD) {
            pos = pos.method_10093(((class_2350)state.method_11654((class_2769)FACING)).method_10153());
        }
        if ((blockEntity = world.method_8321(pos)) instanceof SarcophagusBlockEntity) {
            player.method_17355((class_3908)((SarcophagusBlockEntity)blockEntity));
        }
        return class_1269.field_21466;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        if (!world.field_9236) {
            class_2338 blockPos = pos.method_10093((class_2350)state.method_11654((class_2769)FACING));
            world.method_8652(blockPos, (class_2680)state.method_11657(PART, (Comparable)((Object)SarcophagusPart.HEAD)), 3);
            world.method_8408(pos, class_2246.field_10124);
            state.method_30101((class_1936)world, pos, 3);
        }
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public long method_9535(class_2680 state, class_2338 pos) {
        class_2338 blockPos = pos.method_10079((class_2350)state.method_11654((class_2769)FACING), state.method_11654(PART) == SarcophagusPart.HEAD ? 0 : 1);
        return class_3532.method_15371((int)blockPos.method_10263(), (int)pos.method_10264(), (int)blockPos.method_10260());
    }

    public static class_4732.class_4733 getSarcophagusPart(class_2680 state) {
        SarcophagusPart bedPart = (SarcophagusPart)((Object)state.method_11654(PART));
        return bedPart == SarcophagusPart.HEAD ? class_4732.class_4733.field_21784 : class_4732.class_4733.field_21785;
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2338 blockPos;
        class_2680 blockState;
        SarcophagusPart part;
        if (!world.field_9236 && player.method_7337() && (part = (SarcophagusPart)((Object)state.method_11654(PART))) == SarcophagusPart.FOOT && (blockState = world.method_8320(blockPos = pos.method_10093(SarcophagusBlock.getDirectionTowardsOtherPart(part, (class_2350)state.method_11654((class_2769)FACING))))).method_27852((class_2248)this) && blockState.method_11654(PART) == SarcophagusPart.HEAD) {
            world.method_8652(blockPos, class_2246.field_10124.method_9564(), 35);
            world.method_8444(player, 2001, blockPos, class_2248.method_9507((class_2680)blockState));
        }
        super.method_9576(world, pos, state, player);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof class_1263) {
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)((class_1263)blockEntity));
                world.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, Random random) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof SarcophagusBlockEntity) {
            ((SarcophagusBlockEntity)blockEntity).onScheduledTick();
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SarcophagusBlockEntity(pos, state, this.isCoffin);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        class_2350 direction = ctx.method_8042();
        class_2338 blockPos = ctx.method_8037();
        class_2338 blockPos2 = blockPos.method_10093(direction);
        class_1937 world = ctx.method_8045();
        return world.method_8320(blockPos2).method_26166(ctx) && world.method_8621().method_11952(blockPos2) ? (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)direction)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910)) : null;
    }

    public static class_2350 getOppositePartDirection(class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        return state.method_11654(PART) == SarcophagusPart.HEAD ? direction.method_10153() : direction;
    }

    public static class_4732.class_3923<SarcophagusBlockEntity, Float2FloatFunction> getAnimationProgressRetriever(final class_2618 progress) {
        return new class_4732.class_3923<SarcophagusBlockEntity, Float2FloatFunction>(){

            public Float2FloatFunction getFromBoth(SarcophagusBlockEntity chestBlockEntity, SarcophagusBlockEntity chestBlockEntity2) {
                return tickDelta -> Math.max(chestBlockEntity.method_11274(tickDelta), chestBlockEntity2.method_11274(tickDelta));
            }

            public Float2FloatFunction getFrom(SarcophagusBlockEntity chestBlockEntity) {
                Objects.requireNonNull(chestBlockEntity);
                return chestBlockEntity::method_11274;
            }

            public Float2FloatFunction getFallback() {
                class_2618 var10000 = progress;
                Objects.requireNonNull(var10000);
                return arg_0 -> ((class_2618)var10000).method_11274(arg_0);
            }
        };
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.field_9236 ? SarcophagusBlock.method_31618(type, this.getExpectedEntityType(), SarcophagusBlockEntity::clientTick) : null;
    }

    @Override
    public class_4732.class_4734<? extends SarcophagusBlockEntity> getBlockEntitySource(class_2680 state, class_1937 world, class_2338 pos, boolean ignoreBlocked) {
        BiPredicate<Object, Object> biPredicate = (worldx, posx) -> false;
        return class_4732.method_24173((class_2591)((class_2591)this.entityTypeRetriever.get()), SarcophagusBlock::getSarcophagusPart, SarcophagusBlock::getOppositePartDirection, (class_2753)FACING, (class_2680)state, (class_1936)world, (class_2338)pos, biPredicate);
    }

    public class_2591<? extends SarcophagusBlockEntity> getExpectedEntityType() {
        return (class_2591)this.entityTypeRetriever.get();
    }

    static {
        PART = class_2754.method_11850((String)"part", SarcophagusPart.class);
        OPEN = class_2741.field_12537;
        WATERLOGGED = class_2741.field_12508;
        FACING = class_2741.field_12481;
        DOUBLE_NORTH_SHAPE = class_2248.method_9541((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
        DOUBLE_SOUTH_SHAPE = class_2248.method_9541((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
        DOUBLE_WEST_SHAPE = class_2248.method_9541((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
        DOUBLE_EAST_SHAPE = class_2248.method_9541((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    }
}

