/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.blockentities.renders;

import com.finallion.graveyard.blockentities.SarcophagusBlockEntity;
import com.finallion.graveyard.blockentities.enums.SarcophagusPart;
import com.finallion.graveyard.blocks.SarcophagusBlock;
import com.finallion.graveyard.init.TGBlocks;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.BakedModelManagerHelper;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_1160;
import net.minecraft.class_1920;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_4732;
import net.minecraft.class_4737;
import net.minecraft.class_5614;
import net.minecraft.class_778;
import net.minecraft.class_827;

@Environment(value=EnvType.CLIENT)
public class SarcophagusBlockEntityRenderer<T extends class_2586>
implements class_827<SarcophagusBlockEntity> {
    public static final class_2960 SARCOPHAGUS_FOOT = new class_2960("graveyard", "block/sarcophagus_foot");
    public static final class_2960 SARCOPHAGUS_FOOT_LID = new class_2960("graveyard", "block/sarcophagus_foot_lid");
    public static final class_2960 SARCOPHAGUS_HEAD_LID = new class_2960("graveyard", "block/sarcophagus_head_lid");
    public static final class_2960 SARCOPHAGUS_HEAD = new class_2960("graveyard", "block/sarcophagus_head");
    private final class_1087 sarcophagusModelHead;
    private final class_1087 sarcophagusModelFoot;
    private final class_1087 sarcophagusModelFootLid;
    private final class_1087 sarcophagusModelHeadLid;

    public SarcophagusBlockEntityRenderer(class_5614.class_5615 ctx) {
        class_310 client = class_310.method_1551();
        this.sarcophagusModelHead = BakedModelManagerHelper.getModel((class_1092)client.method_1554(), (class_2960)SARCOPHAGUS_HEAD);
        this.sarcophagusModelFoot = BakedModelManagerHelper.getModel((class_1092)client.method_1554(), (class_2960)SARCOPHAGUS_FOOT);
        this.sarcophagusModelFootLid = BakedModelManagerHelper.getModel((class_1092)client.method_1554(), (class_2960)SARCOPHAGUS_FOOT_LID);
        this.sarcophagusModelHeadLid = BakedModelManagerHelper.getModel((class_1092)client.method_1554(), (class_2960)SARCOPHAGUS_HEAD_LID);
    }

    public void render(SarcophagusBlockEntity entity, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumers, int light, int overlay) {
        class_1937 world = entity.method_10997();
        class_2680 blockState = entity.method_11010();
        String name = entity.method_11010().method_26204().method_9539();
        boolean isCoffin = entity.isCoffin();
        class_4732.class_4734 propertySource = class_4732.method_24173(TGBlocks.SARCOPHAGUS_BLOCK_ENTITY, SarcophagusBlock::getSarcophagusPart, SarcophagusBlock::getOppositePartDirection, (class_2753)class_2281.field_10768, (class_2680)blockState, (class_1936)world, (class_2338)entity.method_11016(), (worldx, pos) -> false);
        float g = ((Float2FloatFunction)propertySource.apply(SarcophagusBlock.getAnimationProgressRetriever(entity))).get(tickDelta);
        g = 1.0f - g;
        g = 1.0f - g * g * g;
        int k = ((Int2IntFunction)propertySource.apply((class_4732.class_3923)new class_4737())).get(light);
        class_1087 footLid = this.getModel(name, isCoffin, 0);
        class_1087 headLid = this.getModel(name, isCoffin, 1);
        class_1087 head = this.getModel(name, isCoffin, 2);
        class_1087 foot = this.getModel(name, isCoffin, 3);
        if (world != null) {
            if (isCoffin) {
                this.renderPart(entity, matrixStack, vertexConsumers, blockState.method_11654(SarcophagusBlock.PART) == SarcophagusPart.HEAD ? head : foot, (class_2350)blockState.method_11654((class_2769)SarcophagusBlock.FACING), vertexConsumers.getBuffer(class_4696.method_23679((class_2680)entity.method_11010())), k, overlay, false);
                this.renderLid(entity, matrixStack, vertexConsumers, blockState.method_11654(SarcophagusBlock.PART) == SarcophagusPart.HEAD ? headLid : footLid, class_2350.field_11035, vertexConsumers.getBuffer(class_4696.method_23679((class_2680)entity.method_11010())), k, overlay, false, g);
            } else {
                this.renderPart(entity, matrixStack, vertexConsumers, blockState.method_11654(SarcophagusBlock.PART) == SarcophagusPart.HEAD ? this.sarcophagusModelHead : this.sarcophagusModelFoot, (class_2350)blockState.method_11654((class_2769)SarcophagusBlock.FACING), vertexConsumers.getBuffer(class_4696.method_23679((class_2680)entity.method_11010())), k, overlay, false);
                this.renderLid(entity, matrixStack, vertexConsumers, blockState.method_11654(SarcophagusBlock.PART) == SarcophagusPart.HEAD ? this.sarcophagusModelHeadLid : this.sarcophagusModelFootLid, class_2350.field_11035, vertexConsumers.getBuffer(class_4696.method_23679((class_2680)entity.method_11010())), k, overlay, false, g);
            }
        } else if (isCoffin) {
            this.renderLid(entity, matrixStack, vertexConsumers, footLid, class_2350.field_11035, vertexConsumers.getBuffer(class_4696.method_23679((class_2680)entity.method_11010())), k, overlay, true, g);
            this.renderPart(entity, matrixStack, vertexConsumers, foot, class_2350.field_11035, vertexConsumers.getBuffer(class_4696.method_23679((class_2680)entity.method_11010())), k, overlay, true);
            this.renderLid(entity, matrixStack, vertexConsumers, headLid, class_2350.field_11035, vertexConsumers.getBuffer(class_4696.method_23679((class_2680)entity.method_11010())), k, overlay, false, g);
            this.renderPart(entity, matrixStack, vertexConsumers, head, class_2350.field_11035, vertexConsumers.getBuffer(class_4696.method_23679((class_2680)entity.method_11010())), k, overlay, false);
        } else {
            this.renderLid(entity, matrixStack, vertexConsumers, this.sarcophagusModelFootLid, class_2350.field_11035, vertexConsumers.getBuffer(class_4696.method_23679((class_2680)entity.method_11010())), k, overlay, true, g);
            this.renderPart(entity, matrixStack, vertexConsumers, this.sarcophagusModelFoot, class_2350.field_11035, vertexConsumers.getBuffer(class_4696.method_23679((class_2680)entity.method_11010())), k, overlay, true);
            this.renderLid(entity, matrixStack, vertexConsumers, this.sarcophagusModelHeadLid, class_2350.field_11035, vertexConsumers.getBuffer(class_4696.method_23679((class_2680)entity.method_11010())), k, overlay, false, g);
            this.renderPart(entity, matrixStack, vertexConsumers, this.sarcophagusModelHead, class_2350.field_11035, vertexConsumers.getBuffer(class_4696.method_23679((class_2680)entity.method_11010())), k, overlay, false);
        }
    }

    private void renderPart(SarcophagusBlockEntity entity, class_4587 matrices, class_4597 vertexConsumers, class_1087 model, class_2350 direction, class_4588 vertexConsumer, int light, int overlay, boolean isFoot) {
        class_778 renderer = class_310.method_1551().method_1541().method_3350();
        class_1937 world = entity.method_10997();
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, isFoot ? -1.0 : 0.0);
        float f = ((class_2350)entity.method_11010().method_11654((class_2769)SarcophagusBlock.FACING)).method_10153().method_10144();
        matrices.method_22904(0.5, 0.5, 0.5);
        matrices.method_22907(class_1160.field_20705.method_23214(-f));
        matrices.method_22904(-0.5, -0.5, -0.5);
        renderer.method_3374((class_1920)world, model, entity.method_11010(), entity.method_11016(), matrices, vertexConsumer, false, new Random(), 0L, overlay);
        matrices.method_22909();
    }

    private void renderLid(SarcophagusBlockEntity entity, class_4587 matrices, class_4597 vertexConsumers, class_1087 model, class_2350 direction, class_4588 vertexConsumer, int light, int overlay, boolean isFoot, float openFactor) {
        class_778 renderer = class_310.method_1551().method_1541().method_3350();
        class_1937 world = entity.method_10997();
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, isFoot ? -1.0 : 0.0);
        float f = ((class_2350)entity.method_11010().method_11654((class_2769)SarcophagusBlock.FACING)).method_10153().method_10144();
        matrices.method_22904(0.5, 0.5, 0.5);
        matrices.method_22907(class_1160.field_20705.method_23214(-f));
        matrices.method_22907(class_1160.field_20706.method_23214(openFactor * 70.0f));
        matrices.method_22904(isFoot ? -((double)openFactor * 0.25) : (double)openFactor * 0.25, (double)openFactor * 0.25, 0.0);
        matrices.method_22904(-0.5, -0.5, -0.5);
        renderer.method_3374((class_1920)world, model, entity.method_11010(), entity.method_11016(), matrices, vertexConsumer, false, new Random(), 0L, overlay);
        matrices.method_22909();
    }

    private class_1087 getModel(String name, boolean isCoffin, int part) {
        class_310 client = class_310.method_1551();
        if (isCoffin) {
            String woodType = name.split("\\.")[2];
            switch (part) {
                default: {
                    return BakedModelManagerHelper.getModel((class_1092)client.method_1554(), (class_2960)new class_2960("graveyard", "block/" + woodType + "_head_lid"));
                }
                case 1: {
                    return BakedModelManagerHelper.getModel((class_1092)client.method_1554(), (class_2960)new class_2960("graveyard", "block/" + woodType + "_foot_lid"));
                }
                case 2: {
                    return BakedModelManagerHelper.getModel((class_1092)client.method_1554(), (class_2960)new class_2960("graveyard", "block/" + woodType + "_foot"));
                }
                case 3: 
            }
            return BakedModelManagerHelper.getModel((class_1092)client.method_1554(), (class_2960)new class_2960("graveyard", "block/" + woodType + "_head"));
        }
        return BakedModelManagerHelper.getModel((class_1092)client.method_1554(), (class_2960)new class_2960("graveyard", "block/oak_coffin_head"));
    }
}

