/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard;

import com.finallion.graveyard.config.GraveyardConfig;
import com.finallion.graveyard.init.TGBlocks;
import com.finallion.graveyard.init.TGConfiguredFeatures;
import com.finallion.graveyard.init.TGEntities;
import com.finallion.graveyard.init.TGItems;
import com.finallion.graveyard.init.TGProcessors;
import com.finallion.graveyard.init.TGSpawner;
import com.finallion.graveyard.init.TGStructures;
import com.finallion.graveyard.mixin.StructuresConfigAccessor;
import com.finallion.graveyard.util.BiomeInjection;
import com.finallion.graveyard.util.BiomeModification;
import com.finallion.graveyard.util.MobSpawningRules;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import draylar.omegaconfig.OmegaConfig;
import java.util.HashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2897;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5311;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib3.GeckoLib;

public class TheGraveyard
implements ModInitializer {
    public static final String MOD_ID = "graveyard";
    public static final GraveyardConfig config = (GraveyardConfig)OmegaConfig.register(GraveyardConfig.class);
    public static final Logger LOGGER = LogManager.getLogger();
    public static class_1761 GROUP = FabricItemGroupBuilder.create((class_2960)new class_2960("graveyard", "group")).icon(() -> new class_1799((class_1935)class_1802.field_8398)).build();

    public void onInitialize() {
        GeckoLib.initialize();
        if (TheGraveyard.config.getHorde((class_2960)new class_2960((String)MOD_ID, (String)"horde_spawn")).enabled) {
            ServerWorldEvents.LOAD.register((Object)new TGSpawner.WorldLoad());
            ServerLifecycleEvents.SERVER_STOPPED.register((Object)new TGSpawner.ServerStopped());
            ServerTickEvents.END_WORLD_TICK.register((Object)new TGSpawner.OnWorldTick());
        }
        TGBlocks.registerBlocks();
        TGItems.registerItems();
        TGEntities.registerEntities();
        TGProcessors.registerProcessors();
        TGConfiguredFeatures.registerFeatures();
        TGConfiguredFeatures.registerConfiguredFeatures();
        TGStructures.registerStructures();
        TGStructures.registerConfiguredStructures();
        TheGraveyard.addStructureSpawningToDimensionsAndBiomes();
        MobSpawningRules.addSpawnEntries();
        if (FabricLoader.getInstance().isModLoaded("graveyard_biomes")) {
            BiomeModification.init();
        }
    }

    public static void addStructureSpawningToDimensionsAndBiomes() {
        class_2960 runAfterFabricAPIPhase = new class_2960(MOD_ID, "run_after_fabric_api");
        ServerWorldEvents.LOAD.addPhaseOrdering(Event.DEFAULT_PHASE, runAfterFabricAPIPhase);
        ServerWorldEvents.LOAD.register(runAfterFabricAPIPhase, (minecraftServer, serverWorld) -> {
            class_5311 worldStructureSettings = serverWorld.method_14178().method_12129().method_12109();
            HashMap tempStructureToMultiMap = new HashMap();
            ((StructuresConfigAccessor)worldStructureSettings).getConfiguredStructures().forEach((key, value) -> tempStructureToMultiMap.put((class_3195<?>)key, (Multimap<class_5312<?, ?>, class_5321<class_1959>>)HashMultimap.create((Multimap)value)));
            BiomeInjection.addStructureToBiomes(tempStructureToMultiMap, (class_2378<class_1959>)minecraftServer.method_30611().method_30530(class_2378.field_25114));
            ImmutableMap.Builder immutableOuterMap = ImmutableMap.builder();
            tempStructureToMultiMap.forEach((key, value) -> {
                ImmutableMultimap.Builder immutableInnerMultiMap = ImmutableMultimap.builder();
                immutableInnerMultiMap.putAll(value);
                immutableOuterMap.put(key, (Object)immutableInnerMultiMap.build());
            });
            ((StructuresConfigAccessor)worldStructureSettings).setConfiguredStructures(immutableOuterMap.build());
            HashMap tempMap = new HashMap(worldStructureSettings.method_28598());
            if (serverWorld.method_14178().method_12129() instanceof class_2897 && serverWorld.method_8597().equals(class_1937.field_25179)) {
                tempMap.keySet().removeAll(TGStructures.structures);
            }
            ((StructuresConfigAccessor)worldStructureSettings).setStructures(tempMap);
        });
    }
}

