/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jei.mechanicalsqueezer;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.modcompat.jei.RecipeRegistryJeiRecipeWrapper;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeMechanicalSqueezer;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;

public class MechanicalSqueezerRecipeJEI
extends RecipeRegistryJeiRecipeWrapper<Container, RecipeMechanicalSqueezer, MechanicalSqueezerRecipeJEI> {
    private final List<ItemStack> inputItem;
    private final NonNullList<RecipeSqueezer.IngredientChance> outputItems;
    private final FluidStack outputFluid;
    private final int duration;

    public MechanicalSqueezerRecipeJEI(RecipeMechanicalSqueezer recipe) {
        super(RegistryEntries.RECIPETYPE_MECHANICAL_SQUEEZER, (Recipe)recipe);
        this.inputItem = Arrays.stream(recipe.getInputIngredient().m_43908_()).collect(Collectors.toList());
        this.outputItems = recipe.getOutputItems();
        this.outputFluid = recipe.getOutputFluid();
        this.duration = recipe.getDuration();
    }

    protected MechanicalSqueezerRecipeJEI() {
        super(RegistryEntries.RECIPETYPE_MECHANICAL_SQUEEZER, null);
        this.inputItem = null;
        this.outputItems = null;
        this.outputFluid = null;
        this.duration = 0;
    }

    public List<ItemStack> getInputItem() {
        return this.inputItem;
    }

    public NonNullList<RecipeSqueezer.IngredientChance> getOutputItems() {
        return this.outputItems;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    public int getDuration() {
        return this.duration;
    }

    protected RecipeType<RecipeMechanicalSqueezer> getRecipeType() {
        return RegistryEntries.RECIPETYPE_MECHANICAL_SQUEEZER;
    }

    protected MechanicalSqueezerRecipeJEI newInstance(RecipeMechanicalSqueezer recipe) {
        return new MechanicalSqueezerRecipeJEI(recipe);
    }

    public static List<MechanicalSqueezerRecipeJEI> getAllRecipes() {
        return Lists.newArrayList((Iterable)new MechanicalSqueezerRecipeJEI().createAllRecipes());
    }
}

