/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jei.mechanicaldryingbasin;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.modcompat.jei.RecipeRegistryJeiRecipeWrapper;
import org.cyclops.cyclopscore.recipe.type.IInventoryFluid;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeMechanicalDryingBasin;

public class MechanicalDryingBasinRecipeJEI
extends RecipeRegistryJeiRecipeWrapper<IInventoryFluid, RecipeMechanicalDryingBasin, MechanicalDryingBasinRecipeJEI> {
    private final List<ItemStack> inputItem;
    private final FluidStack inputFluid;
    private final ItemStack outputItem;
    private final FluidStack outputFluid;
    private final int duration;

    public MechanicalDryingBasinRecipeJEI(RecipeMechanicalDryingBasin recipe) {
        super(RegistryEntries.RECIPETYPE_MECHANICAL_DRYING_BASIN, (Recipe)recipe);
        this.inputItem = Arrays.stream(recipe.getInputIngredient().m_43908_()).collect(Collectors.toList());
        this.inputFluid = recipe.getInputFluid();
        this.outputItem = recipe.getOutputItemFirst();
        this.outputFluid = recipe.getOutputFluid();
        this.duration = recipe.getDuration();
    }

    protected MechanicalDryingBasinRecipeJEI() {
        super(RegistryEntries.RECIPETYPE_MECHANICAL_DRYING_BASIN, null);
        this.inputItem = null;
        this.inputFluid = null;
        this.outputItem = null;
        this.outputFluid = null;
        this.duration = 0;
    }

    public List<ItemStack> getInputItem() {
        return this.inputItem;
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    public int getDuration() {
        return this.duration;
    }

    protected RecipeType<RecipeMechanicalDryingBasin> getRecipeType() {
        return RegistryEntries.RECIPETYPE_MECHANICAL_DRYING_BASIN;
    }

    protected MechanicalDryingBasinRecipeJEI newInstance(RecipeMechanicalDryingBasin recipe) {
        return new MechanicalDryingBasinRecipeJEI(recipe);
    }

    public static List<MechanicalDryingBasinRecipeJEI> getAllRecipes() {
        return Lists.newArrayList((Iterable)new MechanicalDryingBasinRecipeJEI().createAllRecipes());
    }
}

