/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jei.logicprogrammer;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.core.ingredient.ItemMatchProperties;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeRecipeLPElement;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamicscompat.GeneralConfig;
import org.cyclops.integrateddynamicscompat.IntegratedDynamicsCompat;
import org.cyclops.integrateddynamicscompat.network.packet.CPacketValueTypeRecipeLPElementSetRecipe;

public class LogicProgrammerTransferHandler<T extends ContainerLogicProgrammerBase>
implements IRecipeTransferHandler<T, Object> {
    private final Class<T> clazz;

    public LogicProgrammerTransferHandler(Class<T> clazz) {
        this.clazz = clazz;
    }

    public Class<T> getContainerClass() {
        return this.clazz;
    }

    public Class<Object> getRecipeClass() {
        return Object.class;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(T container, Object recipe, IRecipeSlotsView recipeLayout, Player player, boolean maxTransfer, boolean doTransfer) {
        ILogicProgrammerElement element = ((ContainerLogicProgrammerBase)((Object)container)).getActiveElement();
        if (element != null && element instanceof ValueTypeRecipeLPElement) {
            return this.handleRecipeElement((ValueTypeRecipeLPElement)element, container, recipeLayout, doTransfer);
        }
        return null;
    }

    @Nullable
    protected ResourceLocation getHeuristicItemsTag(IRecipeSlotView jeiIngredient) {
        if (!GeneralConfig.jeiHeuristicTags) {
            return null;
        }
        List items = jeiIngredient.getAllIngredients().map(typedIngredient -> (ItemStack)typedIngredient.getIngredient()).map(ItemStack::m_41720_).collect(Collectors.toList());
        if (items.size() > 1) {
            return ForgeRegistries.ITEMS.tags().stream().map(tag -> {
                if (tag.stream().collect(Collectors.toList()).equals(items)) {
                    return Optional.of(tag.getKey().f_203868_());
                }
                return Optional.empty();
            }).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(null);
        }
        return null;
    }

    protected IRecipeTransferError handleRecipeElement(ValueTypeRecipeLPElement element, T container, IRecipeSlotsView recipeLayout, boolean doTransfer) {
        ArrayList itemInputs = Lists.newArrayList();
        ArrayList fluidInputs = Lists.newArrayList();
        ArrayList itemOutputs = Lists.newArrayList();
        ArrayList fluidOutputs = Lists.newArrayList();
        for (IRecipeSlotView slotView : recipeLayout.getSlotViews()) {
            if (slotView.isEmpty()) {
                itemInputs.add(new ItemMatchProperties(ItemStack.f_41583_));
                continue;
            }
            ITypedIngredient typedIngredient = (ITypedIngredient)slotView.getAllIngredients().findFirst().get();
            if (typedIngredient.getType() == VanillaTypes.ITEM_STACK) {
                if (slotView.getRole() == RecipeIngredientRole.INPUT) {
                    ResourceLocation heuristicTag = this.getHeuristicItemsTag(slotView);
                    if (heuristicTag != null) {
                        itemInputs.add(new ItemMatchProperties(ItemStack.f_41583_, false, heuristicTag.toString(), 1));
                        continue;
                    }
                    itemInputs.add(new ItemMatchProperties((ItemStack)typedIngredient.getIngredient()));
                    continue;
                }
                if (slotView.getRole() != RecipeIngredientRole.OUTPUT) continue;
                itemOutputs.add((ItemStack)typedIngredient.getIngredient());
                continue;
            }
            if (typedIngredient.getType() != ForgeTypes.FLUID_STACK) continue;
            if (slotView.getRole() == RecipeIngredientRole.INPUT) {
                fluidInputs.add((FluidStack)typedIngredient.getIngredient());
                continue;
            }
            if (slotView.getRole() != RecipeIngredientRole.OUTPUT) continue;
            fluidOutputs.add((FluidStack)typedIngredient.getIngredient());
        }
        if (!element.isValidForRecipeGrid(itemInputs, fluidInputs, itemOutputs, fluidOutputs)) {
            return new IRecipeTransferError(){

                public IRecipeTransferError.Type getType() {
                    return IRecipeTransferError.Type.USER_FACING;
                }

                public void showError(PoseStack matrixStack, int mouseX, int mouseY, IRecipeSlotsView recipeLayout, int recipeX, int recipeY) {
                    Minecraft.m_91087_().f_91080_.m_96597_(matrixStack, Collections.singletonList(new TranslatableComponent("error.jei.integrateddynamics.recipetransfer.recipe.toobig.desc")), mouseX, mouseY);
                }
            };
        }
        if (doTransfer) {
            element.setRecipeGrid((ContainerLogicProgrammerBase)((Object)container), itemInputs, fluidInputs, itemOutputs, fluidOutputs);
            IntegratedDynamicsCompat._instance.getPacketHandler().sendToServer((PacketBase)new CPacketValueTypeRecipeLPElementSetRecipe(((ContainerLogicProgrammerBase)((Object)container)).f_38840_, itemInputs, fluidInputs, itemOutputs, fluidOutputs));
        }
        return null;
    }
}

