/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.part;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.server.ServerStartedEvent;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.path.ISidedPathElement;
import org.cyclops.integrateddynamics.capability.path.PathElementConfig;
import org.cyclops.integrateddynamics.capability.path.SidedPathElement;
import org.cyclops.integrateddynamics.core.block.IgnoredBlock;
import org.cyclops.integrateddynamics.core.block.IgnoredBlockStatus;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.part.PartTypeConnector;

public class PartTypeConnectorOmniDirectional
extends PartTypeConnector<PartTypeConnectorOmniDirectional, State> {
    public static LoadedGroups LOADED_GROUPS = new LoadedGroups();
    private static String NBT_KEY_ID = "omnidir-group-key";

    public PartTypeConnectorOmniDirectional(String name) {
        super(name, new PartRenderPosition(0.25f, 0.3125f, 0.625f, 0.625f));
    }

    @Override
    public int getConsumptionRate(State state) {
        return GeneralConfig.connectorOmniDirectionalBaseConsumption;
    }

    @Override
    public State constructDefaultState() {
        return new State();
    }

    @Override
    public ItemStack getItemStack(State state, boolean saveState) {
        ItemStack itemStack = super.getItemStack(state, saveState);
        if (state.hasConnectorId()) {
            CompoundTag tag = itemStack.m_41784_();
            tag.m_128405_(NBT_KEY_ID, state.getGroupId());
        }
        return itemStack;
    }

    @Override
    public State getState(ItemStack itemStack) {
        State state = (State)super.getState(itemStack);
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null && tag.m_128425_(NBT_KEY_ID, 3)) {
            state.setGroupId(tag.m_128451_(NBT_KEY_ID));
        } else {
            state.setGroupId(PartTypeConnectorOmniDirectional.generateGroupId());
        }
        return state;
    }

    @Override
    public void onNetworkAddition(INetwork network, IPartNetwork partNetwork, PartTarget target, State state) {
        super.onNetworkAddition(network, partNetwork, target, state);
        this.addPosition(network, state, target.getCenter());
    }

    @Override
    public void onPostRemoved(INetwork network, IPartNetwork partNetwork, PartTarget target, State state) {
        super.onPostRemoved(network, partNetwork, target, state);
        this.removePosition(network, state, target.getCenter());
    }

    protected void addPosition(INetwork network, State state, PartPos pos) {
        if (!LOADED_GROUPS.isModifyingPositions() && !state.isAddedToGroup()) {
            state.setAddedToGroup(true);
            LOADED_GROUPS.addPosition(state.getGroupId(), pos, network.isInitialized());
        }
    }

    protected void removePosition(INetwork network, State state, PartPos pos) {
        if (!LOADED_GROUPS.isModifyingPositions() && state.isAddedToGroup() && state.hasConnectorId()) {
            state.setAddedToGroup(false);
            LOADED_GROUPS.removePosition(state.getGroupId(), pos, network.isInitialized());
        }
    }

    public static int generateGroupId() {
        return IntegratedDynamics.globalCounters.getNext("omnidir-connectors");
    }

    @Override
    public void loadTooltip(State state, List<Component> lines) {
        super.loadTooltip(state, lines);
        lines.add((Component)new TranslatableComponent("parttype.integrateddynamics.tooltip.monodirectionalconnector.group", new Object[]{state.getGroupId()}));
    }

    @Override
    public void loadTooltip(ItemStack itemStack, List<Component> lines) {
        super.loadTooltip(itemStack, lines);
        if (itemStack.m_41782_()) {
            lines.add((Component)new TranslatableComponent("parttype.integrateddynamics.tooltip.monodirectionalconnector.group", new Object[]{itemStack.m_41783_().m_128451_(NBT_KEY_ID)}));
        }
    }

    protected IgnoredBlockStatus.Status getStatus(State state) {
        return state != null && state.hasConnectorId() ? IgnoredBlockStatus.Status.ACTIVE : IgnoredBlockStatus.Status.INACTIVE;
    }

    @Override
    public BlockState getBlockState(IPartContainer partContainer, Direction side) {
        IgnoredBlockStatus.Status status = this.getStatus(partContainer != null ? (State)partContainer.getPartState(side) : null);
        return (BlockState)((BlockState)super.getBlockState(partContainer, side).m_61124_((Property)IgnoredBlock.FACING, (Comparable)side)).m_61124_((Property)IgnoredBlockStatus.STATUS, (Comparable)((Object)status));
    }

    public static ItemStack transformCraftingOutput(CraftingContainer inventory, ItemStack staticOutput) {
        int groupId = -1;
        int stackCount = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            CompoundTag tag;
            ItemStack slotStack = inventory.m_8020_(i);
            if (slotStack.m_41619_()) continue;
            ++stackCount;
            if (groupId != -1 || slotStack.m_41720_() != PartTypes.CONNECTOR_OMNI.getItem() || !slotStack.m_41782_() || !(tag = slotStack.m_41783_()).m_128425_(NBT_KEY_ID, 3)) continue;
            groupId = tag.m_128451_(NBT_KEY_ID);
        }
        if (stackCount == 1) {
            groupId = -1;
        }
        if (groupId < 0) {
            groupId = PartTypeConnectorOmniDirectional.generateGroupId();
        }
        staticOutput = staticOutput.m_41777_();
        CompoundTag tag = staticOutput.m_41784_();
        tag.m_128405_(NBT_KEY_ID, groupId);
        return staticOutput;
    }

    @Override
    public InteractionResult onPartActivated(State partState, BlockPos pos, Level world, Player player, InteractionHand hand, ItemStack heldItem, BlockHitResult hit) {
        if (player.m_36341_() || !partState.isEnabled()) {
            return InteractionResult.PASS;
        }
        if (world.m_5776_()) {
            player.m_5661_((Component)new TranslatableComponent("parttype.integrateddynamics.tooltip.monodirectionalconnector.group", new Object[]{partState.getGroupId()}), true);
        }
        return InteractionResult.SUCCESS;
    }

    public static class State
    extends PartTypeConnector.State<PartTypeConnectorOmniDirectional> {
        private int groupId = -1;
        private boolean addedToGroup = false;

        @Override
        public void writeToNBT(CompoundTag tag) {
            super.writeToNBT(tag);
            tag.m_128405_(NBT_KEY_ID, this.groupId);
        }

        @Override
        public void readFromNBT(CompoundTag tag) {
            super.readFromNBT(tag);
            this.groupId = tag.m_128451_(NBT_KEY_ID);
        }

        @Override
        public Set<ISidedPathElement> getReachableElements() {
            if (this.hasConnectorId()) {
                TreeSet pathElements = Sets.newTreeSet();
                for (PartPos pos : LOADED_GROUPS.getPositions(this.getGroupId())) {
                    if (pos.equals(this.getPartPos())) continue;
                    BlockEntityHelpers.getCapability((DimPos)pos.getPos(), (Direction)pos.getSide(), PathElementConfig.CAPABILITY).ifPresent(pathElement -> pathElements.add(SidedPathElement.of(pathElement, pos.getSide())));
                }
                return pathElements;
            }
            return Collections.emptySet();
        }

        public int getGroupId() {
            return this.groupId;
        }

        public void setGroupId(int groupId) {
            this.groupId = groupId;
            this.sendUpdate();
        }

        public boolean hasConnectorId() {
            return this.groupId >= 0;
        }

        public boolean isAddedToGroup() {
            return this.addedToGroup;
        }

        public void setAddedToGroup(boolean addedToGroup) {
            this.addedToGroup = addedToGroup;
        }
    }

    public static class LoadedGroups {
        private Int2ObjectMap<Set<PartPos>> groupPositions = new Int2ObjectOpenHashMap();
        private boolean modifyingPositions = false;

        public void onStartedEvent(ServerStartedEvent event) {
            this.groupPositions.clear();
        }

        public Set<PartPos> getPositions(int group) {
            Set<PartPos> positions = (Set<PartPos>)this.groupPositions.get(group);
            return positions != null ? positions : Collections.emptySet();
        }

        protected void initNetworkGroup(Set<PartPos> positions) {
            for (PartPos position : positions) {
                if (!position.getPos().isLoaded()) continue;
                NetworkHelpers.initNetwork(position.getPos().getLevel(true), position.getPos().getBlockPos(), position.getSide());
            }
        }

        public void addPosition(int group, PartPos pos, boolean initNetwork) {
            Set positions = (Set)this.groupPositions.get(group);
            if (positions == null) {
                positions = Sets.newTreeSet();
                this.groupPositions.put(group, (Object)positions);
            }
            positions.add(pos);
            if (initNetwork) {
                this.modifyingPositions = true;
                this.initNetworkGroup(positions);
                this.modifyingPositions = false;
            }
        }

        public void removePosition(int group, PartPos pos, boolean initNetwork) {
            Set positions = (Set)this.groupPositions.get(group);
            if (positions == null) {
                positions = Sets.newTreeSet();
                this.groupPositions.put(group, (Object)positions);
            }
            positions.remove(pos);
            if (initNetwork) {
                this.modifyingPositions = true;
                this.initNetworkGroup(positions);
                if (pos.getPos().isLoaded()) {
                    NetworkHelpers.initNetwork(pos.getPos().getLevel(true), pos.getPos().getBlockPos(), pos.getSide());
                }
                this.modifyingPositions = false;
            }
        }

        public boolean isModifyingPositions() {
            return this.modifyingPositions;
        }
    }
}

