/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.cyclops.cyclopscore.modcompat.capabilities.DefaultCapabilityProvider;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHolder;
import org.cyclops.integrateddynamics.capability.variablefacade.VariableFacadeHolderConfig;
import org.cyclops.integrateddynamics.capability.variablefacade.VariableFacadeHolderDefault;
import org.cyclops.integrateddynamics.client.render.blockentity.ItemStackBlockEntityVariableRender;
import org.cyclops.integrateddynamics.core.item.VariableFacadeHandlerRegistry;

public class ItemVariable
extends Item {
    public ItemVariable(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
        IVariableFacade variableFacade = this.getVariableFacade(itemStack);
        variableFacade.appendHoverText(list, world);
        if (variableFacade != VariableFacadeHandlerRegistry.DUMMY_FACADE && Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_7500_()) {
            list.add((Component)new TranslatableComponent("item.integrateddynamics.variable.warning"));
        }
        super.m_7373_(itemStack, world, list, flag);
    }

    public Component m_7626_(ItemStack itemStack) {
        String label;
        IVariableFacade variableFacade = this.getVariableFacade(itemStack);
        if (variableFacade.isValid() && (label = variableFacade.getLabel()) != null) {
            return new TextComponent(label).m_130940_(ChatFormatting.ITALIC);
        }
        return super.m_7626_(itemStack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new DefaultCapabilityProvider(() -> VariableFacadeHolderConfig.CAPABILITY, (Object)new VariableFacadeHolderDefault(stack));
    }

    public IVariableFacade getVariableFacade(ItemStack itemStack) {
        return itemStack.getCapability(VariableFacadeHolderConfig.CAPABILITY).map(IVariableFacadeHolder::getVariableFacade).orElse(VariableFacadeHandlerRegistry.DUMMY_FACADE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return new ItemStackBlockEntityVariableRender();
            }
        });
    }
}

