/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Either;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.cyclops.cyclopscore.helper.RecipeSerializerHelpers;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeMechanicalSqueezer;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSerializerSqueezer;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;

public class RecipeSerializerMechanicalSqueezer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<RecipeMechanicalSqueezer> {
    public RecipeMechanicalSqueezer fromJson(ResourceLocation recipeId, JsonObject json) {
        JsonObject result = GsonHelper.m_13930_((JsonObject)json, (String)"result");
        Ingredient inputIngredient = RecipeSerializerHelpers.getJsonIngredient((JsonObject)json, (String)"item", (boolean)true);
        NonNullList<RecipeSqueezer.IngredientChance> outputItemStacks = RecipeSerializerSqueezer.getJsonItemStackChances(result, "items");
        FluidStack outputFluid = RecipeSerializerHelpers.getJsonFluidStack((JsonObject)result, (String)"fluid", (boolean)false);
        int duration = GsonHelper.m_13927_((JsonObject)json, (String)"duration");
        if (inputIngredient.m_43947_()) {
            throw new JsonSyntaxException("An input item is required");
        }
        if (outputItemStacks.isEmpty() && outputFluid.isEmpty()) {
            throw new JsonSyntaxException("An output item or fluid is required");
        }
        if (duration <= 0) {
            throw new JsonSyntaxException("Durations must be higher than one tick");
        }
        return new RecipeMechanicalSqueezer(recipeId, inputIngredient, outputItemStacks, outputFluid, duration);
    }

    @Nullable
    public RecipeMechanicalSqueezer fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        Ingredient inputIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        NonNullList outputItemStacks = NonNullList.m_122779_();
        int outputItemStacksCount = buffer.readInt();
        for (int i = 0; i < outputItemStacksCount; ++i) {
            outputItemStacks.add((Object)new RecipeSqueezer.IngredientChance((Either<ItemStack, ItemStackFromIngredient>)RecipeSerializerHelpers.readItemStackOrItemStackIngredient((FriendlyByteBuf)buffer), buffer.readFloat()));
        }
        FluidStack outputFluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
        int duration = buffer.m_130242_();
        return new RecipeMechanicalSqueezer(recipeId, inputIngredient, (NonNullList<RecipeSqueezer.IngredientChance>)outputItemStacks, outputFluid, duration);
    }

    public void toNetwork(FriendlyByteBuf buffer, RecipeMechanicalSqueezer recipe) {
        recipe.getInputIngredient().m_43923_(buffer);
        buffer.writeInt(recipe.getOutputItems().size());
        for (RecipeSqueezer.IngredientChance outputItem : recipe.getOutputItems()) {
            RecipeSerializerHelpers.writeItemStackOrItemStackIngredient((FriendlyByteBuf)buffer, outputItem.getIngredient());
            buffer.writeFloat(outputItem.getChance());
        }
        recipe.getOutputFluid().writeToPacket(buffer);
        buffer.m_130130_(recipe.getDuration());
    }
}

