/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLong;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.Helpers;

public class NbtHelpers {
    public static boolean nbtMatchesSubset(CompoundTag a, CompoundTag b, boolean recursive) {
        for (String key : a.m_128431_()) {
            Tag valueA = a.m_128423_(key);
            if (recursive && (valueA instanceof CompoundTag || valueA instanceof ListTag)) {
                CompoundTag tagB;
                CompoundTag tagA;
                Tag valueB = b.m_128423_(key);
                if (valueA instanceof CompoundTag) {
                    if (!(valueB instanceof CompoundTag)) {
                        return false;
                    }
                    tagA = (CompoundTag)valueA;
                    tagB = (CompoundTag)valueB;
                    if (NbtHelpers.nbtMatchesSubset(tagA, tagB, recursive)) continue;
                    return false;
                }
                if (!(valueA instanceof ListTag)) continue;
                if (!(valueB instanceof ListTag)) {
                    return false;
                }
                tagA = (ListTag)valueA;
                tagB = (ListTag)valueB;
                for (int i = 0; i < tagA.size(); ++i) {
                    CompoundTag subTagA = tagA.m_128728_(i);
                    boolean foundA = false;
                    for (int j = 0; j < tagB.size(); ++j) {
                        CompoundTag subTagB = tagB.m_128728_(j);
                        if (!NbtHelpers.nbtMatchesSubset(subTagA, subTagB, recursive)) continue;
                        foundA = true;
                        break;
                    }
                    if (foundA) continue;
                    return false;
                }
                continue;
            }
            if (valueA.equals(b.m_128423_(key))) continue;
            return false;
        }
        return true;
    }

    public static CompoundTag union(CompoundTag ... tags) {
        CompoundTag tag = new CompoundTag();
        for (CompoundTag inputTag : tags) {
            tag.m_128391_(inputTag);
        }
        return tag;
    }

    public static CompoundTag intersection(CompoundTag ... tags) {
        if (tags.length == 0) {
            return new CompoundTag();
        }
        CompoundTag tag = null;
        for (CompoundTag inputTag : tags) {
            if (tag == null) {
                tag = inputTag.m_6426_();
                continue;
            }
            HashSet keys = Sets.newHashSet((Iterable)tag.m_128431_());
            for (String key : keys) {
                byte type;
                if (!inputTag.m_128425_(key, (int)(type = tag.m_128423_(key).m_7060_()))) {
                    tag.m_128473_(key);
                    continue;
                }
                if (type != 10) continue;
                tag.m_128365_(key, (Tag)NbtHelpers.intersection(tag.m_128469_(key), inputTag.m_128469_(key)));
            }
        }
        return tag;
    }

    public static CompoundTag minus(CompoundTag a, CompoundTag b) {
        CompoundTag tag = a.m_6426_();
        for (String key : b.m_128431_()) {
            byte type;
            if (!tag.m_128425_(key, (int)(type = b.m_128423_(key).m_7060_()))) continue;
            if (type == 10) {
                CompoundTag difference = NbtHelpers.minus(tag.m_128469_(key), b.m_128469_(key));
                if (difference.m_128456_()) {
                    tag.m_128473_(key);
                    continue;
                }
                tag.m_128365_(key, (Tag)difference);
                continue;
            }
            tag.m_128473_(key);
        }
        return tag;
    }

    public static ListTag getListNbtTag(ValueTypeList.ValueList<?, ?> value, Component operatorName) {
        ListTag list = new ListTag();
        for (IValue valueNbt : value.getRawValue()) {
            if (value.getRawValue().getValueType() != ValueTypes.NBT) {
                TranslatableComponent error = new TranslatableComponent("operator.integrateddynamics.error.wrong_type", new Object[]{operatorName, new TranslatableComponent(value.getType().getTranslationKey()), 1, new TranslatableComponent(ValueTypes.NBT.getTranslationKey())});
                Helpers.sneakyThrow(new EvaluationException((MutableComponent)error));
            }
            ((ValueTypeNbt.ValueNbt)valueNbt).getRawValue().ifPresent(arg_0 -> list.add(arg_0));
        }
        return list;
    }

    public static ByteArrayTag getListNbtByte(ValueTypeList.ValueList<?, ?> value, Component operatorName) {
        LinkedList list = Lists.newLinkedList();
        for (IValue valueNbt : value.getRawValue()) {
            if (value.getRawValue().getValueType() != ValueTypes.INTEGER) {
                TranslatableComponent error = new TranslatableComponent("operator.integrateddynamics.error.wrong_type", new Object[]{operatorName, new TranslatableComponent(value.getType().getTranslationKey()), 1, new TranslatableComponent(ValueTypes.INTEGER.getTranslationKey())});
                Helpers.sneakyThrow(new EvaluationException((MutableComponent)error));
            }
            list.add((byte)((ValueTypeInteger.ValueInteger)valueNbt).getRawValue());
        }
        return new ByteArrayTag((List)list);
    }

    public static IntArrayTag getListNbtInt(ValueTypeList.ValueList<?, ?> value, Component operatorName) {
        LinkedList list = Lists.newLinkedList();
        for (IValue valueNbt : value.getRawValue()) {
            if (value.getRawValue().getValueType() != ValueTypes.INTEGER) {
                TranslatableComponent error = new TranslatableComponent("operator.integrateddynamics.error.wrong_type", new Object[]{operatorName, new TranslatableComponent(value.getType().getTranslationKey()), 1, new TranslatableComponent(ValueTypes.INTEGER.getTranslationKey())});
                Helpers.sneakyThrow(new EvaluationException((MutableComponent)error));
            }
            list.add(((ValueTypeInteger.ValueInteger)valueNbt).getRawValue());
        }
        return new IntArrayTag((List)list);
    }

    public static LongArrayTag getListNbtLong(ValueTypeList.ValueList<?, ?> value, Component operatorName) {
        LinkedList list = Lists.newLinkedList();
        for (IValue valueNbt : value.getRawValue()) {
            if (value.getRawValue().getValueType() != ValueTypes.LONG) {
                TranslatableComponent error = new TranslatableComponent("operator.integrateddynamics.error.wrong_type", new Object[]{operatorName, new TranslatableComponent(value.getType().getTranslationKey()), 1, new TranslatableComponent(ValueTypes.LONG.getTranslationKey())});
                Helpers.sneakyThrow(new EvaluationException((MutableComponent)error));
            }
            list.add(((ValueTypeLong.ValueLong)valueNbt).getRawValue());
        }
        return new LongArrayTag((List)list);
    }
}

