/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.advancement.criterion.ValuePredicate;
import org.cyclops.integrateddynamics.api.advancement.criterion.VariablePredicate;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperatorRegistry;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperatorSerializer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IOperatorVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.core.evaluate.expression.LazyExpression;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorSerializerDefault;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.item.OperatorVariableFacade;

public class OperatorRegistry
implements IOperatorRegistry {
    private static OperatorRegistry INSTANCE = new OperatorRegistry();
    private static final IOperatorVariableFacade INVALID_FACADE = new OperatorVariableFacade(false, null, null);
    private final List<IOperator> operators = Lists.newArrayList();
    private final Map<String, IOperator> namedOperators = Maps.newHashMap();
    private final Multimap<List<IValueType>, IOperator> inputTypedOperators = HashMultimap.create();
    private final Multimap<IValueType, IOperator> outputTypedOperators = HashMultimap.create();
    private final Multimap<String, IOperator> categoryOperators = HashMultimap.create();
    private final List<IOperatorSerializer> serializers = Lists.newArrayList();
    private final Map<String, IOperatorSerializer> namedSerializers = Maps.newHashMap();
    private final IOperatorSerializer DEFAULT_SERIALIZER = new OperatorSerializerDefault();

    private OperatorRegistry() {
        if (MinecraftHelpers.isModdedEnvironment()) {
            ((IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class)).registerHandler(this);
        }
    }

    public static OperatorRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public <O extends IOperator> O register(O operator) {
        this.operators.add(operator);
        this.namedOperators.put(operator.getUniqueName().toString(), operator);
        this.inputTypedOperators.put((Object)ImmutableList.copyOf((Object[])operator.getInputTypes()), operator);
        this.outputTypedOperators.put((Object)operator.getOutputType(), operator);
        this.categoryOperators.put((Object)operator.getUnlocalizedCategoryName(), operator);
        return operator;
    }

    @Override
    public Collection<IOperator> getOperators() {
        return Collections.unmodifiableList(this.operators);
    }

    @Override
    public IOperator getOperator(ResourceLocation uniqueName) {
        return this.namedOperators.get(uniqueName.toString());
    }

    @Override
    public Collection<IOperator> getOperatorsWithInputTypes(IValueType ... valueTypes) {
        return this.inputTypedOperators.get((Object)ImmutableList.copyOf((Object[])valueTypes));
    }

    @Override
    public Collection<IOperator> getOperatorsWithOutputType(IValueType valueType) {
        return this.outputTypedOperators.get((Object)valueType);
    }

    @Override
    public Collection<IOperator> getOperatorsInCategory(String categoryName) {
        return this.categoryOperators.get((Object)categoryName);
    }

    @Override
    public void registerSerializer(IOperatorSerializer serializer) {
        this.serializers.add(serializer);
        this.namedSerializers.put(serializer.getUniqueName().toString(), serializer);
    }

    @Override
    public Tag serialize(IOperator value) {
        for (IOperatorSerializer serializer : this.serializers) {
            if (!serializer.canHandle(value)) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("serializer", serializer.getUniqueName().toString());
            tag.m_128365_("value", serializer.serialize(value));
            return tag;
        }
        return this.DEFAULT_SERIALIZER.serialize(value);
    }

    @Override
    public IOperator deserialize(Tag value) throws EvaluationException {
        if (value.m_7060_() == 10) {
            CompoundTag tag = (CompoundTag)value;
            String serializerName = tag.m_128461_("serializer");
            IOperatorSerializer serializer = this.namedSerializers.get(serializerName);
            if (serializer == null) {
                throw new EvaluationException((MutableComponent)new TranslatableComponent("operator.integrateddynamics.error.no_derserializer", new Object[]{value}));
            }
            return serializer.deserialize(tag.m_128423_("value"));
        }
        return this.DEFAULT_SERIALIZER.deserialize(value);
    }

    @Override
    public ResourceLocation getUniqueName() {
        return new ResourceLocation("integrateddynamics", "operator");
    }

    @Override
    public IOperatorVariableFacade getVariableFacade(int id, CompoundTag tag) {
        IOperator operator;
        if (!tag.m_128425_("operatorName", 8) || !tag.m_128425_("variableIds", 11)) {
            return INVALID_FACADE;
        }
        try {
            operator = this.deserialize(tag.m_128423_("operatorName"));
        }
        catch (EvaluationException e) {
            return INVALID_FACADE;
        }
        if (operator == null) {
            return INVALID_FACADE;
        }
        int[] variableIds = tag.m_128465_("variableIds");
        return new OperatorVariableFacade(id, operator, variableIds);
    }

    @Override
    public void setVariableFacade(CompoundTag tag, IOperatorVariableFacade variableFacade) {
        tag.m_128365_("operatorName", this.serialize(variableFacade.getOperator()));
        tag.m_128385_("variableIds", variableFacade.getVariableIds());
    }

    @Override
    public VariablePredicate deserializeVariablePredicate(JsonObject element, @Nullable IValueType valueType, ValuePredicate valuePredicate) {
        JsonElement operatorElement = element.get("operator");
        IOperator operator = null;
        if (operatorElement != null && !operatorElement.isJsonNull() && (operator = Operators.REGISTRY.getOperator(new ResourceLocation(GsonHelper.m_13906_((JsonObject)element, (String)"operator")))) == null) {
            throw new JsonSyntaxException("Unknown operator type '" + GsonHelper.m_13906_((JsonObject)element, (String)"operator") + "', valid types are: " + Operators.REGISTRY.getOperators().stream().map(IOperator::getUniqueName).collect(Collectors.toList()));
        }
        JsonElement inputElement = element.get("input");
        Int2ObjectOpenHashMap inputPredicates = new Int2ObjectOpenHashMap();
        if (inputElement != null && !inputElement.isJsonNull()) {
            for (Map.Entry inputEntry : inputElement.getAsJsonObject().entrySet()) {
                try {
                    int slot = Integer.parseInt((String)inputEntry.getKey());
                    inputPredicates.put(slot, (Object)VariablePredicate.deserialize((JsonElement)inputEntry.getValue()));
                }
                catch (NumberFormatException e) {
                    throw new JsonSyntaxException("All inputs must refer to an input id as key, but got '" + (String)inputEntry.getKey() + "\"");
                }
            }
        }
        return new OperatorVariablePredicate(valueType, valuePredicate, operator, (Int2ObjectMap<VariablePredicate>)inputPredicates);
    }

    public static class OperatorVariablePredicate
    extends VariablePredicate<LazyExpression> {
        private final IOperator operator;
        private final Int2ObjectMap<VariablePredicate> inputPredicates;

        public OperatorVariablePredicate(@Nullable IValueType valueType, ValuePredicate valuePredicate, @Nullable IOperator operator, Int2ObjectMap<VariablePredicate> inputPredicates) {
            super(LazyExpression.class, valueType, valuePredicate);
            this.operator = operator;
            this.inputPredicates = inputPredicates;
        }

        @Override
        protected boolean testTyped(LazyExpression variable) {
            if (!super.testTyped(variable) || this.operator != null && variable.getOperator() != this.operator) {
                return false;
            }
            for (int i = 0; i < variable.getInput().length; ++i) {
                IVariable inputVariable = variable.getInput()[i];
                VariablePredicate variablePredicate = (VariablePredicate)this.inputPredicates.get(i);
                if (variablePredicate == null || variablePredicate.test(inputVariable)) continue;
                return false;
            }
            return true;
        }
    }
}

